/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common;

import co.uk.flansmods.common.FlansModPlayerData;
import co.uk.flansmods.common.driveables.EntityDriveable;
import co.uk.flansmods.common.driveables.EntitySeat;
import co.uk.flansmods.common.teams.Gametype;
import co.uk.flansmods.common.teams.TeamsManager;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class FlansModPlayerHandler
implements IPlayerTracker {
    public static Map<String, FlansModPlayerData> serverSideData = new HashMap<String, FlansModPlayerData>();
    public static Map<String, FlansModPlayerData> clientSideData = new HashMap<String, FlansModPlayerData>();
    public static ArrayList<String> clientsToRemoveAfterThisRound = new ArrayList();

    public FlansModPlayerHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        GameRegistry.registerPlayerTracker((IPlayerTracker)this);
    }

    @ForgeSubscribe
    public void onEntityHurt(LivingHurtEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (event instanceof LivingHurtEvent && (entity.field_70154_o instanceof EntityDriveable || entity.field_70154_o instanceof EntitySeat)) {
            event.ammount = 0.0f;
        }
    }

    @ForgeSubscribe
    public void onEntityKilled(LivingDeathEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity instanceof EntityPlayer) {
            FlansModPlayerHandler.getPlayerData((EntityPlayer)((EntityPlayer)entity)).isShooting = false;
        }
    }

    public void tick() {
        for (FlansModPlayerData d : serverSideData.values()) {
            d.tick();
        }
        for (FlansModPlayerData d : clientSideData.values()) {
            d.tick();
        }
    }

    public static FlansModPlayerData getPlayerData(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        return FlansModPlayerHandler.getPlayerData(player.field_71092_bJ, Side.SERVER);
    }

    public static FlansModPlayerData getPlayerData(String username) {
        return FlansModPlayerHandler.getPlayerData(username, Side.SERVER);
    }

    public static FlansModPlayerData getPlayerData(EntityPlayer player, Side side) {
        if (player == null) {
            return null;
        }
        return FlansModPlayerHandler.getPlayerData(player.field_71092_bJ, side);
    }

    public static FlansModPlayerData getPlayerData(String username, Side side) {
        if (side.isClient() && !clientSideData.containsKey(username)) {
            clientSideData.put(username, new FlansModPlayerData(username));
        }
        return side.isClient() ? clientSideData.get(username) : serverSideData.get(username);
    }

    public void onPlayerLogin(EntityPlayer player) {
        if (!serverSideData.containsKey(player.field_71092_bJ)) {
            serverSideData.put(player.field_71092_bJ, new FlansModPlayerData(player.field_71092_bJ));
        }
        if (TeamsManager.getInstance().currentGametype != null && TeamsManager.getInstance().areTeamsValid()) {
            Gametype.sendTeamsMenuToPlayer((EntityPlayerMP)player);
        }
        if (clientsToRemoveAfterThisRound.contains(player.field_71092_bJ)) {
            clientsToRemoveAfterThisRound.remove(player.field_71092_bJ);
        }
    }

    public void onPlayerLogout(EntityPlayer player) {
        if (TeamsManager.getInstance().currentGametype == null) {
            serverSideData.remove(player.field_71092_bJ);
        } else {
            clientsToRemoveAfterThisRound.add(player.field_71092_bJ);
        }
    }

    public void onPlayerChangedDimension(EntityPlayer player) {
    }

    public void onPlayerRespawn(EntityPlayer player) {
    }

    public static void roundEnded() {
        for (String username : clientsToRemoveAfterThisRound) {
            serverSideData.remove(username);
        }
    }
}

