/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.driveables.mechas;

import co.uk.flansmods.client.GuiDriveableController;
import co.uk.flansmods.client.debug.EntityDebugVector;
import co.uk.flansmods.client.model.GunAnimations;
import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.InfoType;
import co.uk.flansmods.common.ItemPart;
import co.uk.flansmods.common.ItemTool;
import co.uk.flansmods.common.RotatedAxes;
import co.uk.flansmods.common.driveables.DriveableData;
import co.uk.flansmods.common.driveables.DriveablePart;
import co.uk.flansmods.common.driveables.DriveableType;
import co.uk.flansmods.common.driveables.EntityDriveable;
import co.uk.flansmods.common.driveables.EntitySeat;
import co.uk.flansmods.common.driveables.EnumDriveablePart;
import co.uk.flansmods.common.driveables.mechas.EnumMechaSlotType;
import co.uk.flansmods.common.driveables.mechas.ItemMechaAddon;
import co.uk.flansmods.common.driveables.mechas.MechaInventory;
import co.uk.flansmods.common.driveables.mechas.MechaItemType;
import co.uk.flansmods.common.driveables.mechas.MechaType;
import co.uk.flansmods.common.guns.BulletType;
import co.uk.flansmods.common.guns.EnumFireMode;
import co.uk.flansmods.common.guns.GunType;
import co.uk.flansmods.common.guns.InventoryHelper;
import co.uk.flansmods.common.guns.ItemBullet;
import co.uk.flansmods.common.guns.ItemGun;
import co.uk.flansmods.common.network.PacketDriveableDamage;
import co.uk.flansmods.common.network.PacketPlaySound;
import co.uk.flansmods.common.network.PacketVehicleControl;
import co.uk.flansmods.common.network.PacketVehicleGUI;
import co.uk.flansmods.common.network.PacketVehicleKey;
import co.uk.flansmods.common.vector.Vector3f;
import co.uk.flansmods.common.vector.Vector3i;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityMecha
extends EntityDriveable {
    public int fMotion = 0;
    public int sMotion = 0;
    private int ticksSinceUsed;
    public int toggleTimer = 0;
    private float moveX = 0.0f;
    private float moveZ = 0.0f;
    public RotatedAxes legAxes;
    public float prevLegsYaw = 0.0f;
    private int jumpDelay = 0;
    public MechaInventory inventory;
    public float legSwing = 0.0f;
    public int shootDelayLeft = 0;
    public int shootDelayRight = 0;
    public int soundDelayLeft = 0;
    public int soundDelayRight = 0;
    public Vector3i breakingBlock = null;
    public float breakingProgress = 0.0f;
    public GunAnimations leftAnimations = new GunAnimations();
    public GunAnimations rightAnimations = new GunAnimations();
    private int foundFuel = -1;
    public boolean couldNotFindFuel = false;

    public EntityMecha(World world) {
        super(world);
        this.func_70105_a(2.0f, 3.0f);
        this.field_70138_W = 3.0f;
        this.legAxes = new RotatedAxes();
        this.inventory = new MechaInventory(this);
    }

    public EntityMecha(World world, double x, double y, double z, MechaType type, DriveableData data, NBTTagCompound tags) {
        super(world, type, data);
        this.legAxes = new RotatedAxes();
        this.func_70105_a(2.0f, 3.0f);
        this.field_70138_W = 3.0f;
        this.func_70107_b(x, y, z);
        this.initType(type, false);
        this.inventory = new MechaInventory(this, tags);
    }

    public EntityMecha(World world, double x, double y, double z, EntityPlayer placer, MechaType type, DriveableData data, NBTTagCompound tags) {
        this(world, x, y, z, type, data, tags);
        this.rotateYaw(placer.field_70177_z + 90.0f);
        this.legAxes.rotateGlobalYaw(placer.field_70177_z + 90.0f);
        this.prevLegsYaw = this.legAxes.getYaw();
    }

    @Override
    protected void initType(DriveableType type, boolean clientSide) {
        super.initType(type, clientSide);
        this.func_70105_a(((MechaType)type).width, ((MechaType)type).height);
        this.field_70138_W = ((MechaType)type).stepHeight;
    }

    @Override
    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74776_a("LegsYaw", this.legAxes.getYaw());
        tag.func_74766_a("Inventory", this.inventory.writeToNBT(new NBTTagCompound()));
    }

    @Override
    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.legAxes.setAngles(tag.func_74760_g("LegsYaw"), 0.0f, 0.0f);
        this.inventory.readFromNBT(tag.func_74775_l("Inventory"));
    }

    @Override
    public void writeUpdateData(DataOutputStream out) {
        try {
            out.writeFloat(this.legAxes.getYaw());
            out.writeFloat(this.legSwing);
            if (!this.field_70170_p.field_72995_K) {
                NBTTagCompound leftTags = new NBTTagCompound();
                NBTTagCompound rightTags = new NBTTagCompound();
                ItemStack leftStack = this.inventory.getStackInSlot(EnumMechaSlotType.leftTool);
                ItemStack rightStack = this.inventory.getStackInSlot(EnumMechaSlotType.rightTool);
                if (leftStack != null) {
                    this.inventory.getStackInSlot(EnumMechaSlotType.leftTool).func_77955_b(leftTags);
                }
                if (rightStack != null) {
                    this.inventory.getStackInSlot(EnumMechaSlotType.rightTool).func_77955_b(rightTags);
                }
                NBTBase.func_74731_a((NBTBase)leftTags, (DataOutput)out);
                NBTBase.func_74731_a((NBTBase)rightTags, (DataOutput)out);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void readUpdateData(DataInputStream in) {
        try {
            this.legAxes.setAngles(in.readFloat(), 0.0f, 0.0f);
            this.legSwing = in.readFloat() / 2.0f;
            if (this.field_70170_p.field_72995_K) {
                NBTTagCompound leftTags = (NBTTagCompound)NBTBase.func_74739_b((DataInput)in);
                NBTTagCompound rightTags = (NBTTagCompound)NBTBase.func_74739_b((DataInput)in);
                this.inventory.setInventorySlotContents(EnumMechaSlotType.leftTool, ItemStack.func_77949_a((NBTTagCompound)leftTags));
                this.inventory.setInventorySlotContents(EnumMechaSlotType.rightTool, ItemStack.func_77949_a((NBTTagCompound)rightTags));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeSpawnData(ByteArrayDataOutput outputData) {
        super.writeSpawnData(outputData);
        try {
            NBTBase.func_74731_a((NBTBase)this.inventory.writeToNBT(new NBTTagCompound()), (DataOutput)outputData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void readSpawnData(ByteArrayDataInput inputData) {
        super.readSpawnData(inputData);
        this.legAxes.rotateGlobalYaw(this.axes.getYaw());
        this.prevLegsYaw = this.legAxes.getYaw();
        try {
            this.inventory.readFromNBT((NBTTagCompound)NBTBase.func_74739_b((DataInput)inputData));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onMouseMoved(int deltaX, int deltaY) {
    }

    public boolean func_130002_c(EntityPlayer entityplayer) {
        if (this.field_70128_L) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack currentItem = entityplayer.func_71045_bC();
        if (currentItem != null && currentItem.func_77973_b() instanceof ItemTool && ((ItemTool)currentItem.func_77973_b()).type.healDriveables) {
            return true;
        }
        MechaType type = this.getMechaType();
        for (int i = 0; i <= type.numPassengers; ++i) {
            if (!this.seats[i].func_130002_c(entityplayer)) continue;
            return true;
        }
        return false;
    }

    public MechaType getMechaType() {
        return MechaType.getMecha(this.driveableType);
    }

    @Override
    public boolean pressKey(int key, EntityPlayer player) {
        MechaType type = this.getMechaType();
        DriveableData data = this.getDriveableData();
        if (this.field_70170_p.field_72995_K && (key == 6 || key == 8 || key == 9)) {
            PacketDispatcher.sendPacketToServer((Packet)PacketVehicleKey.buildKeyPacket(key));
            return true;
        }
        switch (key) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                boolean canThrustCreatively;
                if (this.func_70090_H() && this.shouldFloat() && this.jumpDelay == 0) {
                    this.jumpDelay = 10;
                    this.field_70181_x += (double)0.3f;
                    return true;
                }
                boolean bl = canThrustCreatively = this.seats != null && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d;
                if (this.field_70122_E && this.jumpDelay == 0 && (canThrustCreatively || data.fuelInTank > data.engine.fuelConsumption) && this.isPartIntact(EnumDriveablePart.hips)) {
                    this.jumpDelay = 10;
                    this.field_70181_x += (double)type.jumpVelocity;
                    if (!canThrustCreatively) {
                        data.fuelInTank -= data.engine.fuelConsumption;
                    }
                }
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                this.seats[0].field_70153_n.func_70078_a(null);
                return true;
            }
            case 7: {
                PacketDispatcher.sendPacketToServer((Packet)PacketVehicleGUI.buildGUIPacket(4));
                ((EntityPlayer)this.seats[0].field_70153_n).openGui((Object)FlansMod.instance, 10, this.field_70170_p, this.field_70176_ah, this.field_70162_ai, this.field_70164_aj);
                return true;
            }
            case 8: {
                return true;
            }
            case 9: {
                return true;
            }
            case 10: {
                return true;
            }
            case 11: {
                return true;
            }
            case 12: {
                return true;
            }
            case 13: {
                return true;
            }
            case 14: {
                return true;
            }
            case 15: {
                return true;
            }
            case 16: {
                return true;
            }
            case 17: {
                return true;
            }
        }
        return false;
    }

    private boolean useItem(boolean left) {
        if (left ? this.isPartIntact(EnumDriveablePart.leftArm) : this.isPartIntact(EnumDriveablePart.rightArm)) {
            ItemStack heldStack;
            boolean creative = this.seats[0].field_70153_n instanceof EntityPlayer ? ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d : true;
            ItemStack itemStack = heldStack = left ? this.inventory.getStackInSlot(EnumMechaSlotType.leftTool) : this.inventory.getStackInSlot(EnumMechaSlotType.rightTool);
            if (heldStack == null) {
                return false;
            }
            Item heldItem = heldStack.func_77973_b();
            MechaType mechaType = this.getMechaType();
            if (heldItem instanceof ItemMechaAddon) {
                MechaItemType toolType = ((ItemMechaAddon)heldItem).type;
                float reach = toolType.reach * mechaType.reach;
                Vector3f lookOrigin = new Vector3f((double)((float)mechaType.seats[0].x / 16.0f), (double)((float)mechaType.seats[0].y / 16.0f) + this.seats[0].field_70153_n.func_70042_X(), (double)((float)mechaType.seats[0].z / 16.0f));
                lookOrigin = this.axes.findLocalVectorGlobally(lookOrigin);
                Vector3f.add(lookOrigin, new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v), lookOrigin);
                Vector3f lookVector = this.axes.findLocalVectorGlobally(this.seats[0].looking.findLocalVectorGlobally(new Vector3f(reach, 0.0f, 0.0f)));
                this.field_70170_p.func_72838_d((Entity)new EntityDebugVector(this.field_70170_p, lookOrigin, lookVector, 20));
                Vector3f lookTarget = Vector3f.add(lookVector, lookOrigin, null);
                MovingObjectPosition hit = this.field_70170_p.func_72933_a(lookOrigin.toVec3(), lookTarget.toVec3());
                if (hit != null && hit.field_72313_a == EnumMovingObjectType.TILE) {
                    if (this.breakingBlock == null || this.breakingBlock.x != hit.field_72311_b || this.breakingBlock.y != hit.field_72312_c || this.breakingBlock.z != hit.field_72309_d) {
                        this.breakingProgress = 0.0f;
                    }
                    this.breakingBlock = new Vector3i(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
                }
            } else if (heldItem instanceof ItemGun) {
                int delay;
                ItemGun gunItem = (ItemGun)heldItem;
                GunType gunType = gunItem.type;
                int n = delay = left ? this.shootDelayLeft : this.shootDelayRight;
                if (delay <= 0) {
                    int bulletID;
                    ItemStack bulletStack = null;
                    for (bulletID = 0; bulletID < gunType.numAmmoItemsInGun; ++bulletID) {
                        ItemStack checkingStack = gunItem.getBulletItemStack(heldStack, bulletID);
                        if (checkingStack == null || checkingStack.func_77973_b() == null || checkingStack.func_77960_j() >= checkingStack.func_77958_k()) continue;
                        bulletStack = checkingStack;
                        break;
                    }
                    if (bulletStack == null) {
                        gunItem.reload(heldStack, this.field_70170_p, this, this.driveableData, creative, false);
                    } else if (bulletStack.func_77973_b() instanceof ItemBullet) {
                        this.shoot(heldStack, gunType, bulletStack, creative, left);
                        if (this.field_70170_p.field_72995_K) {
                            int pumpTime;
                            int pumpDelay = gunType.model == null ? 0 : gunType.model.pumpDelay;
                            int n2 = pumpTime = gunType.model == null ? 1 : gunType.model.pumpTime;
                            if (left) {
                                this.leftAnimations.doShoot(pumpDelay, pumpTime);
                            } else {
                                this.rightAnimations.doShoot(pumpDelay, pumpTime);
                            }
                        }
                        bulletStack.func_77964_b(bulletStack.func_77960_j() + 1);
                        gunItem.setBulletItemStack(heldStack, bulletStack, bulletID);
                    }
                }
            }
        }
        return true;
    }

    private void shoot(ItemStack stack, GunType gunType, ItemStack bulletStack, boolean creative, boolean left) {
        MechaType mechaType = this.getMechaType();
        BulletType bulletType = ((ItemBullet)bulletStack.func_77973_b()).type;
        RotatedAxes a = new RotatedAxes();
        Vector3f armVector = new Vector3f(mechaType.armLength, 0.0f, 0.0f);
        Vector3f gunVector = new Vector3f(mechaType.armLength + 1.2f * mechaType.heldItemScale, 0.5f * mechaType.heldItemScale, 0.0f);
        Vector3f armOrigin = left ? mechaType.leftArmOrigin : mechaType.rightArmOrigin;
        a.rotateGlobalYaw(this.axes.getYaw());
        armOrigin = a.findLocalVectorGlobally(armOrigin);
        a.rotateLocalPitch(-this.seats[0].looking.getPitch());
        gunVector = a.findLocalVectorGlobally(gunVector);
        armVector = a.findLocalVectorGlobally(armVector);
        Vector3f bulletOrigin = Vector3f.add(armOrigin, gunVector, null);
        bulletOrigin = Vector3f.add(new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v), bulletOrigin, null);
        if (!this.field_70170_p.field_72995_K) {
            for (int k = 0; k < gunType.numBullets; ++k) {
                this.field_70170_p.func_72838_d((Entity)((ItemBullet)bulletStack.func_77973_b()).getEntity(this.field_70170_p, bulletOrigin, armVector, (EntityLivingBase)this.seats[0].field_70153_n, gunType.getSpread(stack) / 2.0f, gunType.getDamage(stack), gunType.getBulletSpeed(stack), bulletStack.func_77960_j(), (InfoType)mechaType));
            }
        }
        if (left) {
            this.shootDelayLeft = gunType.mode == EnumFireMode.SEMIAUTO ? Math.max(gunType.shootDelay, 5) : gunType.shootDelay;
        } else {
            int n = this.shootDelayRight = gunType.mode == EnumFireMode.SEMIAUTO ? Math.max(gunType.shootDelay, 5) : gunType.shootDelay;
        }
        if (bulletType.dropItemOnShoot != null && !creative) {
            ItemGun.dropItem(this.field_70170_p, this, bulletType.dropItemOnShoot);
        }
        if ((left ? this.soundDelayLeft : this.soundDelayRight) <= 0 && gunType.shootSound != null) {
            PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)50.0, (int)this.field_71093_bK, (Packet)PacketPlaySound.buildSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, gunType.shootSound, gunType.distortSound));
            if (left) {
                this.soundDelayLeft = gunType.shootSoundLength;
            } else {
                this.soundDelayRight = gunType.shootSoundLength;
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        MechaType type = this.getMechaType();
        if (damagesource.func_76355_l().equals("fall")) {
            boolean takeFallDamage = type.takeFallDamage && !this.stopFallDamage();
            boolean damageBlocksFromFalling = type.damageBlocksFromFalling || this.breakBlocksUponFalling();
            float damageToInflict = takeFallDamage ? i * type.fallDamageMultiplier : 0.0f;
            float blockDamageFromFalling = damageBlocksFromFalling ? i * type.blockDamageFromFalling / 10.0f : 0.0f;
            this.driveableData.parts.get((Object)EnumDriveablePart.hips).attack(damageToInflict, false);
            this.checkParts();
            PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)100.0, (int)this.field_71093_bK, (Packet)PacketDriveableDamage.buildUpdatePacket(this));
            if (blockDamageFromFalling > 1.0f) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, blockDamageFromFalling, FlansMod.explosions);
            }
        } else if (damagesource.field_76373_n.equals("player") && ((EntityDamageSource)damagesource).func_76346_g().field_70122_E && (this.seats[0] == null || this.seats[0].field_70153_n == null)) {
            ItemStack mechaStack = new ItemStack(type.itemID, 1, 0);
            mechaStack.field_77990_d = new NBTTagCompound();
            this.driveableData.writeToNBT(mechaStack.field_77990_d);
            this.inventory.writeToNBT(mechaStack.field_77990_d);
            this.func_70099_a(mechaStack, 0.5f);
            this.func_70106_y();
        } else {
            this.driveableData.parts.get((Object)EnumDriveablePart.core).attack(i, damagesource.func_76347_k());
        }
        return true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.jumpDelay > 0) {
            --this.jumpDelay;
        }
        if (this.shootDelayLeft > 0) {
            --this.shootDelayLeft;
        }
        if (this.shootDelayRight > 0) {
            --this.shootDelayRight;
        }
        if (this.soundDelayLeft > 0) {
            --this.soundDelayLeft;
        }
        if (this.soundDelayRight > 0) {
            --this.soundDelayRight;
        }
        this.leftAnimations.update();
        this.rightAnimations.update();
        MechaType type = this.getMechaType();
        DriveableData data = this.getDriveableData();
        if (type == null) {
            FlansMod.log("Mecha type null. Not ticking mecha");
            return;
        }
        this.prevLegsYaw = this.legAxes.getYaw();
        if (this.isPartIntact(EnumDriveablePart.hips)) {
            this.func_70105_a(type.width, type.height);
            this.field_70129_M = type.yOffset;
        } else {
            this.func_70105_a(type.width, type.height - type.chassisHeight);
            this.field_70129_M = type.yOffset - type.chassisHeight;
        }
        boolean thePlayerIsDrivingThis = this.field_70170_p.field_72995_K && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && FlansMod.proxy.isThePlayer((EntityPlayer)this.seats[0].field_70153_n);
        boolean driverIsLiving = this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityLivingBase;
        ++this.ticksSinceUsed;
        if (!this.field_70170_p.field_72995_K && this.seats[0].field_70153_n != null) {
            this.ticksSinceUsed = 0;
        }
        if (!this.field_70170_p.field_72995_K && FlansMod.mechaLove > 0 && this.ticksSinceUsed > FlansMod.mechaLove * 20) {
            this.func_70106_y();
        }
        if (this.toggleTimer > 0) {
            --this.toggleTimer;
        }
        if (this.field_70170_p.field_72995_K && !thePlayerIsDrivingThis && this.serverPositionTransitionTicker > 0) {
            double x = this.field_70165_t + (this.field_70118_ct - this.field_70165_t) / (double)this.serverPositionTransitionTicker;
            double y = this.field_70163_u + (this.field_70117_cu - this.field_70163_u) / (double)this.serverPositionTransitionTicker;
            double z = this.field_70161_v + (this.field_70116_cv - this.field_70161_v) / (double)this.serverPositionTransitionTicker;
            double dYaw = MathHelper.func_76138_g((double)(this.serverYaw - (double)this.axes.getYaw()));
            double dPitch = MathHelper.func_76138_g((double)(this.serverPitch - (double)this.axes.getPitch()));
            double dRoll = MathHelper.func_76138_g((double)(this.serverRoll - (double)this.axes.getRoll()));
            this.field_70177_z = (float)((double)this.axes.getYaw() + dYaw / (double)this.serverPositionTransitionTicker);
            this.field_70125_A = (float)((double)this.axes.getPitch() + dPitch / (double)this.serverPositionTransitionTicker);
            float rotationRoll = (float)((double)this.axes.getRoll() + dRoll / (double)this.serverPositionTransitionTicker);
            --this.serverPositionTransitionTicker;
            this.func_70107_b(x, y, z);
            this.setRotation(this.field_70177_z, this.field_70125_A, rotationRoll);
        }
        if (this.seats[0] != null) {
            if (this.seats[0].field_70153_n instanceof EntityLivingBase && !(this.seats[0].field_70153_n instanceof EntityPlayer)) {
                this.axes.setAngles(((EntityLivingBase)this.seats[0].field_70153_n).field_70761_aq + 90.0f, 0.0f, 0.0f);
            } else {
                if (type.limitHeadTurn) {
                    float axesLegs = this.legAxes.getYaw();
                    float axesBody = this.axes.getYaw();
                    double dYaw = axesBody - axesLegs;
                    if (dYaw > 180.0) {
                        axesBody -= 360.0f;
                    }
                    if (dYaw < -180.0) {
                        axesBody += 360.0f;
                    }
                    if (axesLegs + type.limitHeadTurnValue < axesBody) {
                        this.axes.setAngles(axesLegs + type.limitHeadTurnValue, 0.0f, 0.0f);
                    }
                    if (axesLegs - type.limitHeadTurnValue > axesBody) {
                        this.axes.setAngles(axesLegs - type.limitHeadTurnValue, 0.0f, 0.0f);
                    }
                }
                float yaw = this.seats[0].looking.getYaw() - this.seats[0].prevLooking.getYaw();
                this.axes.rotateGlobalYaw(yaw);
                this.seats[0].looking.rotateGlobalYaw(-yaw);
            }
        }
        this.moveX = 0.0f;
        this.moveZ = 0.0f;
        Vector3f actualMotion = new Vector3f(0.0, this.field_70181_x - 0.024525001645088196, 0.0);
        if (driverIsLiving) {
            Vector3f intent;
            boolean driverIsCreative;
            EntityLivingBase entity = (EntityLivingBase)this.seats[0].field_70153_n;
            boolean bl = driverIsCreative = entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d;
            if (thePlayerIsDrivingThis && Minecraft.func_71410_x().field_71462_r instanceof GuiDriveableController) {
                if (FlansMod.proxy.isKeyDown(0)) {
                    this.moveX = 1.0f;
                }
                if (FlansMod.proxy.isKeyDown(1)) {
                    this.moveX = -1.0f;
                }
                if (FlansMod.proxy.isKeyDown(2)) {
                    this.moveZ = -1.0f;
                }
                if (FlansMod.proxy.isKeyDown(3)) {
                    this.moveZ = 1.0f;
                }
            } else if (this.seats[0].field_70153_n instanceof EntityLiving && !(this.seats[0].field_70153_n instanceof EntityPlayer)) {
                this.moveZ = 1.0f;
            }
            if ((double)Math.abs((intent = new Vector3f(this.moveX, 0.0f, this.moveZ)).lengthSquared()) > 0.1) {
                boolean canThrustCreatively;
                intent.normalise();
                this.legSwing += 1.0f;
                intent = this.axes.findLocalVectorGlobally(intent);
                Vector3f intentOnLegAxes = this.legAxes.findGlobalVectorLocally(intent);
                float intentAngle = (float)Math.atan2(intent.z, intent.x) * 180.0f / (float)Math.PI;
                float angleBetween = intentAngle - this.legAxes.getYaw();
                if (angleBetween > 180.0f) {
                    angleBetween -= 360.0f;
                }
                if (angleBetween < -180.0f) {
                    angleBetween += 360.0f;
                }
                float signBetween = Math.signum(angleBetween);
                if ((double)(angleBetween = Math.abs(angleBetween)) > 0.1) {
                    this.legAxes.rotateGlobalYaw(Math.min(angleBetween, type.rotateSpeed) * signBetween);
                }
                Vector3f motion = this.legAxes.getXAxis();
                motion.scale(type.moveSpeed * data.engine.engineSpeed * 0.215f * intent.lengthSquared());
                boolean bl2 = canThrustCreatively = this.seats != null && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d;
                if ((canThrustCreatively || data.fuelInTank > data.engine.fuelConsumption) && this.isPartIntact(EnumDriveablePart.hips)) {
                    Vector3f.add(actualMotion, motion, actualMotion);
                    if (!canThrustCreatively) {
                        data.fuelInTank -= data.engine.fuelConsumption;
                    }
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.leftMouseHeld) {
                    this.useItem(true);
                }
                if (this.rightMouseHeld) {
                    this.useItem(false);
                }
                if (this.breakingBlock != null) {
                    boolean breakingBlocks;
                    Block blockHit = Block.field_71973_m[this.field_70170_p.func_72798_a(this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z)];
                    int metadata = this.field_70170_p.func_72805_g(this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z);
                    Material material = this.field_70170_p.func_72803_f(this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z);
                    ItemStack leftStack = this.inventory.getStackInSlot(EnumMechaSlotType.leftTool);
                    ItemStack rightStack = this.inventory.getStackInSlot(EnumMechaSlotType.rightTool);
                    boolean leftStackIsTool = leftStack != null && leftStack.func_77973_b() instanceof ItemMechaAddon;
                    boolean rightStackIsTool = rightStack != null && rightStack.func_77973_b() instanceof ItemMechaAddon;
                    boolean bl3 = breakingBlocks = this.leftMouseHeld && leftStackIsTool || this.rightMouseHeld && rightStackIsTool;
                    if (blockHit == null || !breakingBlocks) {
                        if (this.field_70170_p.field_72995_K) {
                            Minecraft.func_71410_x().field_71438_f.func_72705_a(this.field_70157_k, this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z, -1);
                        }
                        this.breakingBlock = null;
                    } else {
                        float blockHardness = blockHit.func_71934_m(this.field_70170_p, this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z);
                        float mineSpeed = 1.0f;
                        boolean atLeastOneEffectiveTool = false;
                        if (leftStackIsTool) {
                            MechaItemType leftType = ((ItemMechaAddon)leftStack.func_77973_b()).type;
                            if (leftType.function.effectiveAgainst(material) && leftType.toolHardness > blockHardness) {
                                mineSpeed *= leftType.speed;
                                atLeastOneEffectiveTool = true;
                            }
                        }
                        if (rightStackIsTool) {
                            MechaItemType rightType = ((ItemMechaAddon)rightStack.func_77973_b()).type;
                            if (rightType.function.effectiveAgainst(material) && rightType.toolHardness > blockHardness) {
                                mineSpeed *= rightType.speed;
                                atLeastOneEffectiveTool = true;
                            }
                        }
                        mineSpeed = blockHardness < -0.01f ? 0.0f : (Math.abs(blockHardness) < 0.01f ? 9001.0f : (mineSpeed /= blockHit.func_71934_m(this.field_70170_p, this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z)));
                        if (this.field_70170_p.field_72995_K) {
                            Minecraft.func_71410_x().field_71438_f.func_72705_a(this.field_70157_k, this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z, (int)(this.breakingProgress * 10.0f));
                        }
                        this.breakingProgress += 0.1f * mineSpeed;
                        if (this.breakingProgress >= 1.0f) {
                            boolean vacuumItems = this.vacuumItems();
                            if (vacuumItems) {
                                for (ItemStack stack : blockHit.getBlockDropped(this.field_70170_p, this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z, metadata, 0)) {
                                    if (InventoryHelper.addItemStackToInventory(this.driveableData, stack, driverIsCreative) || this.field_70170_p.field_72995_K || !this.field_70170_p.func_82736_K().func_82766_b("doTileDrops")) continue;
                                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, (double)((float)this.breakingBlock.x + 0.5f), (double)((float)this.breakingBlock.y + 0.5f), (double)((float)this.breakingBlock.z + 0.5f), stack));
                                }
                            }
                            this.field_70170_p.func_94578_a(this.breakingBlock.x, this.breakingBlock.y, this.breakingBlock.z, atLeastOneEffectiveTool && !vacuumItems);
                        }
                    }
                }
            }
        }
        this.field_70181_x = actualMotion.y;
        this.func_70091_d(actualMotion.x, actualMotion.y, actualMotion.z);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (!this.couldNotFindFuel) {
            ItemStack fuelStack;
            ItemStack itemStack = fuelStack = this.foundFuel == -1 ? null : this.driveableData.func_70301_a(this.foundFuel);
            if (fuelStack != null && fuelStack.field_77994_a <= 0) {
                this.driveableData.func_70299_a(this.foundFuel, null);
                fuelStack = null;
            }
            if (fuelStack == null || !(fuelStack.func_77973_b() instanceof ItemPart) || ((ItemPart)fuelStack.func_77973_b()).type.category != 9) {
                this.foundFuel = -1;
                this.couldNotFindFuel = true;
                for (int i = this.driveableData.getCargoInventoryStart(); i < this.driveableData.getCargoInventoryStart() + type.numCargoSlots; ++i) {
                    ItemStack tempStack = this.driveableData.func_70301_a(i);
                    if (tempStack == null || !(tempStack.func_77973_b() instanceof ItemPart) || ((ItemPart)tempStack.func_77973_b()).type.category != 9) continue;
                    this.foundFuel = i;
                    fuelStack = tempStack;
                    this.couldNotFindFuel = false;
                    break;
                }
            }
            boolean bl = this.fuelling = this.foundFuel != -1 && fuelStack != null && data.fuelInTank < (float)type.fuelTankSize && fuelStack.field_77994_a > 0 && fuelStack.func_77973_b() instanceof ItemPart && ((ItemPart)fuelStack.func_77973_b()).type.category == 9;
            if (this.fuelling) {
                int damage = fuelStack.func_77960_j();
                fuelStack.func_77964_b(damage + 1);
                data.fuelInTank += 100.0f;
                if (damage >= fuelStack.func_77958_k()) {
                    fuelStack.func_77964_b(0);
                    --fuelStack.field_77994_a;
                    if (fuelStack.field_77994_a <= 0) {
                        data.fuel = null;
                    }
                }
            }
            if (FlansMod.hooks.BuildCraftLoaded && !this.fuelling) {
                for (int i = data.getCargoInventoryStart(); i < data.numCargo + type.numCargoSlots; ++i) {
                    ItemStack stack = data.func_70301_a(i);
                    if (stack != null && stack.func_77969_a(FlansMod.hooks.BuildCraftOilBucket) && data.fuelInTank + 5000.0f <= (float)type.fuelTankSize) {
                        data.fuelInTank += 5000.0f;
                        data.func_70299_a(i, new ItemStack(Item.field_77788_aw));
                        this.couldNotFindFuel = false;
                        continue;
                    }
                    if (stack == null || !stack.func_77969_a(FlansMod.hooks.BuildCraftFuelBucket) || !(data.fuelInTank + 10000.0f <= (float)type.fuelTankSize)) continue;
                    data.fuelInTank += 10000.0f;
                    data.func_70299_a(i, new ItemStack(Item.field_77788_aw));
                    this.couldNotFindFuel = false;
                }
            }
        }
        if (thePlayerIsDrivingThis) {
            PacketDispatcher.sendPacketToServer((Packet)PacketVehicleControl.buildUpdatePacket(this));
            this.field_70118_ct = this.field_70165_t;
            this.field_70117_cu = this.field_70163_u;
            this.field_70116_cv = this.field_70161_v;
            this.serverYaw = this.axes.getYaw();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 5 == 0) {
            PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)200.0, (int)this.field_71093_bK, (Packet)PacketVehicleControl.buildUpdatePacket(this));
        }
        for (EntitySeat seat : this.seats) {
            if (seat == null) continue;
            seat.updatePosition();
        }
        if (!driverIsLiving || thePlayerIsDrivingThis) {
            this.legSwing /= type.legSwingLimit;
        }
    }

    public boolean stopFallDamage() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.stopMechaFallDamage) continue;
            return true;
        }
        return false;
    }

    public boolean breakBlocksUponFalling() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.forceBlockFallDamage) continue;
            return true;
        }
        return false;
    }

    public boolean vacuumItems() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.vacuumItems) continue;
            return true;
        }
        return false;
    }

    public boolean shouldFloat() {
        for (MechaItemType type : this.getUpgradeTypes()) {
            if (!type.floater) continue;
            return true;
        }
        return false;
    }

    public ArrayList<MechaItemType> getUpgradeTypes() {
        ArrayList<MechaItemType> types = new ArrayList<MechaItemType>();
        for (ItemStack stack : this.inventory.stacks.values()) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemMechaAddon)) continue;
            types.add(((ItemMechaAddon)stack.func_77973_b()).type);
        }
        return types;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean showInventory(int seat) {
        return seat != 0;
    }

    @Override
    protected void dropItemsOnPartDeath(Vector3f midpoint, DriveablePart part) {
    }

    @Override
    public boolean hasMouseControlMode() {
        return false;
    }

    @Override
    public String getBombInventoryName() {
        return null;
    }
}

