/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.guns;

import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.FlansModPlayerData;
import co.uk.flansmods.common.FlansModPlayerHandler;
import co.uk.flansmods.common.InfoType;
import co.uk.flansmods.common.driveables.EntityDriveable;
import co.uk.flansmods.common.driveables.EntitySeat;
import co.uk.flansmods.common.guns.BulletType;
import co.uk.flansmods.common.guns.EntityDamageSourceGun;
import co.uk.flansmods.common.guns.EntityMG;
import co.uk.flansmods.common.guns.FlansModExplosion;
import co.uk.flansmods.common.network.PacketFlak;
import co.uk.flansmods.common.teams.Team;
import co.uk.flansmods.common.teams.TeamsManager;
import co.uk.flansmods.common.vector.Vector3f;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityBullet
extends Entity
implements IEntityAdditionalSpawnData {
    private static int bulletLife = 600;
    public Entity owner;
    private int ticksInAir;
    public BulletType type;
    public InfoType firedFrom;
    public float damage;
    public boolean shotgun = false;

    public EntityBullet(World world) {
        super(world);
        this.ticksInAir = 0;
        this.func_70105_a(0.5f, 0.5f);
    }

    private EntityBullet(World world, EntityLivingBase shooter, float gunDamage, BulletType bulletType, InfoType shotFrom) {
        this(world);
        this.owner = shooter;
        this.type = bulletType;
        this.firedFrom = shotFrom;
        this.damage = gunDamage;
    }

    public EntityBullet(World world, EntityLivingBase shooter, float spread, float gunDamage, BulletType type1, float speed, boolean shot, InfoType shotFrom) {
        this(world, Vec3.func_72443_a((double)shooter.field_70165_t, (double)(shooter.field_70163_u + (double)shooter.func_70047_e()), (double)shooter.field_70161_v), shooter.field_70177_z, shooter.field_70125_A, shooter, spread, gunDamage, type1, speed, shotFrom);
        this.shotgun = shot;
    }

    public EntityBullet(World world, Vec3 origin, float yaw, float pitch, EntityLivingBase shooter, float spread, float gunDamage, BulletType type1, InfoType shotFrom) {
        this(world, origin, yaw, pitch, shooter, spread, gunDamage, type1, 3.0f, shotFrom);
    }

    public EntityBullet(World world, Vec3 origin, float yaw, float pitch, EntityLivingBase shooter, float spread, float gunDamage, BulletType type1, float speed, InfoType shotFrom) {
        this(world, shooter, gunDamage, type1, shotFrom);
        this.damage = gunDamage;
        this.func_70012_b(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, yaw, pitch);
        float offset = 0.0f;
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * offset);
        this.field_70163_u -= 0.0;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * offset);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.setArrowHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, spread, speed);
    }

    public EntityBullet(World world, Vector3f origin, Vector3f direction, EntityLivingBase shooter, float spread, float gunDamage, BulletType type1, float speed, InfoType shotFrom) {
        this(world, shooter, gunDamage, type1, shotFrom);
        this.damage = gunDamage;
        this.func_70107_b(origin.x, origin.y, origin.z);
        this.field_70159_w = direction.x;
        this.field_70181_x = direction.y;
        this.field_70179_y = direction.z;
        this.setArrowHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, spread, speed);
    }

    public EntityBullet(World world, Vec3 origin, float yaw, float pitch, double motX, double motY, double motZ, EntityLivingBase shooter, float gunDamage, BulletType type1, InfoType shotFrom) {
        super(world);
        this.type = type1;
        this.firedFrom = shotFrom;
        this.ticksInAir = 0;
        this.owner = shooter;
        this.damage = gunDamage;
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, yaw, pitch);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70159_w = motX;
        this.field_70181_x = motY;
        this.field_70179_y = motZ;
    }

    protected void func_70088_a() {
    }

    public void setArrowHeading(double d, double d1, double d2, float spread, float speed) {
        float f2 = MathHelper.func_76133_a((double)(d * d + d1 * d1 + d2 * d2));
        d /= (double)f2;
        d1 /= (double)f2;
        d2 /= (double)f2;
        d += this.field_70146_Z.nextGaussian() * 0.005 * (double)spread;
        d1 += this.field_70146_Z.nextGaussian() * 0.005 * (double)spread;
        d2 += this.field_70146_Z.nextGaussian() * 0.005 * (double)spread;
        this.field_70159_w = d *= (double)speed;
        this.field_70181_x = d1 *= (double)speed;
        this.field_70179_y = d2 *= (double)speed;
        float f3 = MathHelper.func_76133_a((double)(d * d + d2 * d2));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(d, d2) * 180.0 / 3.1415927410125732);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(d1, f3) * 180.0 / 3.1415927410125732);
    }

    public void func_70016_h(double d, double d1, double d2) {
        this.field_70159_w = d;
        this.field_70181_x = d1;
        this.field_70179_y = d2;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(d * d + d2 * d2));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(d, d2) * 180.0 / 3.1415927410125732);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(d1, f) * 180.0 / 3.1415927410125732);
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.ticksInAir;
        if (this.ticksInAir > this.type.fuse && this.type.fuse > 0 && !this.field_70128_L) {
            this.func_70106_y();
        }
        if (this.field_70173_aa > bulletLife) {
            this.func_70106_y();
        }
        for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
            EntityDriveable driveable;
            Object obj = this.field_70170_p.field_72996_f.get(i);
            if (!(obj instanceof EntityDriveable) || (driveable = (EntityDriveable)obj).isPartOfThis(this.owner) || !(this.func_70032_d(driveable) <= driveable.getDriveableType().bulletDetectionRadius) || !driveable.attackFromBullet(this, new Vector3f((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v), new Vector3f((float)this.field_70159_w, (float)this.field_70181_x, (float)this.field_70179_y)) || this.type.penetratesEntities) continue;
            this.func_70106_y();
        }
        Vec3 posVec = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 nextPosVec = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        MovingObjectPosition hit = this.field_70170_p.func_72831_a(posVec, nextPosVec, false, true);
        posVec = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        nextPosVec = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        if (hit != null && !(hit.field_72308_g != null ? this.type.penetratesEntities : this.type.penetratesBlocks)) {
            nextPosVec = Vec3.func_72443_a((double)hit.field_72307_f.field_72450_a, (double)hit.field_72307_f.field_72448_b, (double)hit.field_72307_f.field_72449_c);
        }
        if (!this.field_70128_L && hit != null) {
            if (this.type.explodeOnImpact && this.ticksInAir > 5 && (hit.field_72308_g == null || !this.isPartOfOwner(hit.field_72308_g))) {
                this.func_70106_y();
            } else if (hit.field_72308_g == null) {
                int xTile = hit.field_72311_b;
                int yTile = hit.field_72312_c;
                int zTile = hit.field_72309_d;
                int blockID = this.field_70170_p.func_72798_a(xTile, yTile, zTile);
                Material mat = this.field_70170_p.func_72803_f(xTile, yTile, zTile);
                if (this.type.breaksGlass && mat == Material.field_76264_q) {
                    if (FlansMod.canBreakGlass) {
                        this.field_70170_p.func_94571_i(xTile, yTile, zTile);
                    }
                    FlansMod.proxy.playBlockBreakSound(xTile, yTile, zTile, blockID);
                }
                if (!this.type.penetratesBlocks) {
                    this.func_70107_b(hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c);
                    this.func_70106_y();
                }
            }
        }
        if (!this.field_70128_L) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b((double)this.type.hitBoxSize, (double)this.type.hitBoxSize, (double)this.type.hitBoxSize));
            for (int l = 0; l < list.size(); ++l) {
                DamageSource damagesource;
                Entity checkEntity = (Entity)list.get(l);
                if (checkEntity instanceof EntityDriveable) continue;
                if (checkEntity instanceof EntityPlayer) {
                    FlansModPlayerData data = FlansModPlayerHandler.getPlayerData((EntityPlayer)checkEntity, this.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER);
                    if (checkEntity != this.owner && data != null && data.team == Team.spectators) continue;
                }
                if ((!checkEntity.func_70067_L() || this.isPartOfOwner(checkEntity)) && this.ticksInAir < 20) continue;
                float hitDamage = this.damage * (float)this.type.damageVsLiving;
                DamageSource damageSource = damagesource = this.owner == null ? DamageSource.field_76377_j : this.getBulletDamage();
                if (hitDamage == 0.0f && checkEntity instanceof EntityPlayerMP && TeamsManager.getInstance().currentGametype != null) {
                    TeamsManager.getInstance().currentGametype.playerAttacked((EntityPlayerMP)checkEntity, damagesource);
                }
                if (checkEntity.func_70097_a(damagesource, hitDamage) && checkEntity instanceof EntityLivingBase) {
                    ++((EntityLivingBase)checkEntity).field_70720_be;
                    ((EntityLivingBase)checkEntity).field_70172_ad = ((EntityLivingBase)checkEntity).field_70771_an / 2;
                }
                if (this.type.penetratesEntities) continue;
                this.func_70107_b(checkEntity.field_70165_t, checkEntity.field_70163_u, checkEntity.field_70161_v);
                this.func_70106_y();
                break;
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float motionXZ = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / 3.1415927410125732);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, motionXZ) * 180.0 / 3.1415927410125732);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float drag = 0.99f;
        float gravity = 0.02f;
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float bubbleMotion = 0.25f;
                this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)bubbleMotion, this.field_70163_u - this.field_70181_x * (double)bubbleMotion, this.field_70161_v - this.field_70179_y * (double)bubbleMotion, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            drag = 0.8f;
        }
        this.field_70159_w *= (double)drag;
        this.field_70181_x *= (double)drag;
        this.field_70179_y *= (double)drag;
        this.field_70181_x -= (double)(gravity * this.type.fallSpeed);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.type.smokeTrail) {
            double dX = (this.field_70165_t - this.field_70169_q) / 10.0;
            double dY = (this.field_70163_u - this.field_70167_r) / 10.0;
            double dZ = (this.field_70161_v - this.field_70166_s) / 10.0;
            for (int i = 0; i < 10; ++i) {
                this.field_70170_p.func_72869_a(this.type.trailParticles, this.field_70169_q + dX * (double)i, this.field_70167_r + dY * (double)i, this.field_70166_s + dZ * (double)i, 0.0, 0.0, 0.0);
            }
        }
    }

    private DamageSource getBulletDamage() {
        if (this.owner instanceof EntityPlayer) {
            return new EntityDamageSourceGun(this.type.shortName, this, (EntityPlayer)this.owner, this.firedFrom).func_76349_b();
        }
        return new EntityDamageSourceIndirect(this.type.shortName, (Entity)this, this.owner).func_76349_b();
    }

    private boolean isPartOfOwner(Entity entity) {
        if (this.owner == null) {
            return false;
        }
        if (entity == this.owner || entity == this.owner.field_70153_n || entity == this.owner.field_70154_o) {
            return true;
        }
        if (this.owner instanceof EntityPlayer) {
            if (FlansModPlayerHandler.getPlayerData((EntityPlayer)this.owner, this.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER) == null) {
                return false;
            }
            EntityMG mg = FlansModPlayerHandler.getPlayerData((EntityPlayer)((EntityPlayer)this.owner), (Side)(this.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER)).mountingGun;
            if (mg != null && mg == entity) {
                return true;
            }
        }
        if (this.owner.field_70154_o instanceof EntitySeat) {
            return ((EntitySeat)this.owner.field_70154_o).driveable == null || ((EntitySeat)this.owner.field_70154_o).driveable.isPartOfThis(entity);
        }
        return false;
    }

    public void func_70106_y() {
        if (this.field_70128_L) {
            return;
        }
        super.func_70106_y();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.type.explosion > 0) {
            if (this.owner instanceof EntityPlayer) {
                new FlansModExplosion(this.field_70170_p, this, (EntityPlayer)this.owner, this.firedFrom, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.type.explosion, FlansMod.explosions);
            } else {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.type.explosion, FlansMod.explosions);
            }
        }
        if (this.type.fire > 0) {
            for (int i = (int)this.field_70165_t - this.type.fire; i < (int)this.field_70165_t + this.type.fire; ++i) {
                for (int k = (int)this.field_70161_v - this.type.fire; k < (int)this.field_70161_v + this.type.fire; ++k) {
                    for (int j = (int)this.field_70163_u - 1; j < (int)this.field_70163_u + 1; ++j) {
                        if (this.field_70170_p.func_72803_f(i, j, k) != Material.field_76249_a) continue;
                        this.field_70170_p.func_72832_d(i, j, k, Block.field_72067_ar.field_71990_ca, 0, 3);
                    }
                }
            }
        }
        if (this.type.flak > 0) {
            PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)200.0, (int)this.field_71093_bK, (Packet)PacketFlak.buildFlakPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.type.flak, this.type.flakParticles));
        }
        if (this.type.dropItemOnHit != null) {
            String itemName = this.type.dropItemOnHit;
            int damage = 0;
            if (itemName.contains(".")) {
                damage = Integer.parseInt(itemName.split("\\.")[1]);
                itemName = itemName.split("\\.")[0];
            }
            ItemStack dropStack = InfoType.getRecipeElement(itemName, damage);
            this.func_70099_a(dropStack, 1.0f);
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74778_a("type", this.type.shortName);
        if (this.owner == null) {
            tag.func_74778_a("owner", "null");
        } else {
            tag.func_74778_a("owner", this.owner.func_70023_ak());
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        String typeString = tag.func_74779_i("type");
        String ownerName = tag.func_74779_i("owner");
        if (typeString != null) {
            this.type = BulletType.getBullet(typeString);
        }
        if (ownerName != null && !ownerName.equals("null")) {
            this.owner = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72361_f(ownerName);
        }
    }

    public float func_70053_R() {
        return this.type.hitBoxSize;
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeUTF(this.type.shortName);
        if (this.owner == null) {
            data.writeUTF("null");
        } else {
            data.writeUTF(this.owner.func_70023_ak());
        }
    }

    public void readSpawnData(ByteArrayDataInput data) {
        try {
            this.type = BulletType.getBullet(data.readUTF());
            String name = data.readUTF();
            for (Object obj : this.field_70170_p.field_73010_i) {
                if (!((EntityPlayer)obj).field_71092_bJ.equals(name)) continue;
                this.owner = (EntityPlayer)obj;
            }
        }
        catch (Exception e) {
            FlansMod.log("Failed to read bullet owner from server.");
            super.func_70106_y();
            e.printStackTrace();
        }
    }

    public int func_70070_b(float par1) {
        int j;
        if (this.type.hasLight) {
            return 0xF000F0;
        }
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72899_e(i, 0, j = MathHelper.func_76128_c((double)this.field_70161_v))) {
            double d0 = (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * 0.66;
            int k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)this.field_70129_M + d0));
            return this.field_70170_p.func_72802_i(i, k, j, 0);
        }
        return 0;
    }
}

