/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.guns;

import co.uk.flansmods.client.FlansModClient;
import co.uk.flansmods.client.model.GunAnimations;
import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.FlansModPlayerData;
import co.uk.flansmods.common.FlansModPlayerHandler;
import co.uk.flansmods.common.InfoType;
import co.uk.flansmods.common.driveables.EntitySeat;
import co.uk.flansmods.common.guns.AttachmentType;
import co.uk.flansmods.common.guns.BulletType;
import co.uk.flansmods.common.guns.EntityMG;
import co.uk.flansmods.common.guns.EnumFireMode;
import co.uk.flansmods.common.guns.GunType;
import co.uk.flansmods.common.guns.IScope;
import co.uk.flansmods.common.guns.InventoryHelper;
import co.uk.flansmods.common.guns.ItemBullet;
import co.uk.flansmods.common.network.PacketGunFire;
import co.uk.flansmods.common.network.PacketPlaySound;
import co.uk.flansmods.common.network.PacketReload;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;

public class ItemGun
extends Item {
    public GunType type;
    private static boolean mouseHeld;
    private static boolean lastMouseHeld;
    public int soundDelay;

    public ItemGun(int i, GunType gun) {
        super(i);
        this.field_77777_bU = 1;
        this.type = gun;
        this.type.item = this;
        this.func_77656_e(this.type.numAmmoItemsInGun);
        this.func_77637_a(FlansMod.tabFlanGuns);
    }

    public boolean func_77651_p() {
        return true;
    }

    public ItemStack getBulletItemStack(ItemStack gun, int id) {
        if (!gun.func_77942_o()) {
            gun.field_77990_d = new NBTTagCompound("tag");
            return null;
        }
        if (!gun.field_77990_d.func_74764_b("ammo")) {
            NBTTagList ammoTagsList = new NBTTagList();
            for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
                ammoTagsList.func_74742_a((NBTBase)new NBTTagCompound());
            }
            gun.field_77990_d.func_74782_a("ammo", (NBTBase)ammoTagsList);
            return null;
        }
        NBTTagList ammoTagsList = gun.field_77990_d.func_74761_m("ammo");
        NBTTagCompound ammoTags = (NBTTagCompound)ammoTagsList.func_74743_b(id);
        if (!ammoTags.func_74764_b("id")) {
            return null;
        }
        return new ItemStack((int)ammoTags.func_74765_d("id"), (int)ammoTags.func_74765_d("num"), (int)ammoTags.func_74765_d("dam"));
    }

    public void setBulletItemStack(ItemStack gun, ItemStack bullet, int id) {
        NBTTagList ammoTagsList;
        if (!gun.func_77942_o()) {
            gun.field_77990_d = new NBTTagCompound("tag");
        }
        if (!gun.field_77990_d.func_74764_b("ammo")) {
            ammoTagsList = new NBTTagList();
            for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
                ammoTagsList.func_74742_a((NBTBase)new NBTTagCompound());
            }
            gun.field_77990_d.func_74782_a("ammo", (NBTBase)ammoTagsList);
        }
        ammoTagsList = gun.field_77990_d.func_74761_m("ammo");
        NBTTagCompound ammoTags = (NBTTagCompound)ammoTagsList.func_74743_b(id);
        if (bullet == null) {
            ammoTags.func_82580_o("id");
            ammoTags.func_82580_o("num");
            ammoTags.func_82580_o("dam");
        }
        ammoTags.func_74777_a("id", (short)bullet.field_77993_c);
        ammoTags.func_74777_a("num", (short)bullet.field_77994_a);
        ammoTags.func_74777_a("dam", (short)bullet.func_77960_j());
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List lines, boolean advancedTooltips) {
        for (AttachmentType attachment : this.type.getCurrentAttachments(stack)) {
            String line = attachment.name;
            lines.add(line);
        }
        for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
            ItemStack bulletStack = this.getBulletItemStack(stack, i);
            if (bulletStack == null || !(bulletStack.func_77973_b() instanceof ItemBullet)) continue;
            BulletType bulletType = ((ItemBullet)bulletStack.func_77973_b()).type;
            String line = bulletType.name + " " + (bulletStack.func_77958_k() - bulletStack.func_77960_j()) + "/" + bulletStack.func_77958_k();
            lines.add(line);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onUpdateClient(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71071_by.func_70448_g() == itemstack) {
            lastMouseHeld = mouseHeld;
            mouseHeld = Mouse.isButtonDown((int)1);
            if (this.type.deployable) {
                return;
            }
            if (mouseHeld && !lastMouseHeld) {
                PacketDispatcher.sendPacketToServer((Packet)PacketGunFire.buildGunFirePacket(true));
                this.clientSideShoot((EntityPlayer)entity, itemstack);
            }
            if (this.type.mode == EnumFireMode.FULLAUTO && !mouseHeld && lastMouseHeld) {
                PacketDispatcher.sendPacketToServer((Packet)PacketGunFire.buildGunFirePacket(false));
            }
            if (this.type.mode == EnumFireMode.FULLAUTO && mouseHeld) {
                this.clientSideShoot((EntityPlayer)entity, itemstack);
            }
            GameSettings gameSettings = FMLClientHandler.instance().getClient().field_71474_y;
            IScope currentScope = this.type.getCurrentScope(itemstack);
            if (Mouse.isButtonDown((int)0) && FlansModClient.scopeTime <= 0 && FMLClientHandler.instance().getClient().field_71462_r == null) {
                if (FlansModClient.currentScope == null) {
                    FlansModClient.currentScope = currentScope;
                    FlansModClient.lastZoomLevel = currentScope.getZoomFactor();
                    FlansModClient.lastFOVZoomLevel = currentScope.getFOVFactor();
                    float f = FlansModClient.originalMouseSensitivity = gameSettings.field_74341_c;
                    gameSettings.field_74341_c = f / (float)Math.sqrt(currentScope.getZoomFactor());
                    FlansModClient.originalThirdPerson = gameSettings.field_74320_O;
                    gameSettings.field_74320_O = 0;
                    FlansModClient.originalFOV = gameSettings.field_74334_X;
                } else {
                    FlansModClient.currentScope = null;
                    gameSettings.field_74341_c = FlansModClient.originalMouseSensitivity;
                    gameSettings.field_74320_O = FlansModClient.originalThirdPerson;
                    gameSettings.field_74334_X = FlansModClient.originalFOV;
                }
                FlansModClient.scopeTime = 10;
            }
            if (FMLClientHandler.instance().getClient().field_71462_r != null && FlansModClient.currentScope != null) {
                FlansModClient.currentScope = null;
                gameSettings.field_74341_c = FlansModClient.originalMouseSensitivity;
                gameSettings.field_74320_O = FlansModClient.originalThirdPerson;
                gameSettings.field_74334_X = FlansModClient.originalFOV;
            }
        }
        if (this.soundDelay > 0) {
            --this.soundDelay;
        }
    }

    public void clientSideShoot(EntityPlayer player, ItemStack stack) {
        if (FlansModClient.shootTime <= 0) {
            boolean hasAmmo = false;
            for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
                ItemStack bulletStack = this.getBulletItemStack(stack, i);
                if (bulletStack == null || bulletStack.func_77973_b() == null || bulletStack.func_77960_j() >= bulletStack.func_77958_k()) continue;
                hasAmmo = true;
                break;
            }
            if (hasAmmo) {
                GunAnimations animations = null;
                if (FlansModClient.gunAnimations.containsKey(player)) {
                    animations = FlansModClient.gunAnimations.get(player);
                } else {
                    animations = new GunAnimations();
                    FlansModClient.gunAnimations.put((EntityLivingBase)player, animations);
                }
                int pumpDelay = this.type.model == null ? 0 : this.type.model.pumpDelay;
                int pumpTime = this.type.model == null ? 1 : this.type.model.pumpTime;
                animations.doShoot(pumpDelay, pumpTime);
                FlansModClient.playerRecoil += this.type.getRecoil(stack);
                FlansModClient.shootTime = this.type.shootDelay;
            }
        }
    }

    public void onUpdateServer(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            FlansModPlayerData data = FlansModPlayerHandler.getPlayerData((EntityPlayer)player);
            if (player.field_71071_by.func_70448_g() != itemstack) {
                if (player.field_71071_by.func_70448_g() == null || player.field_71071_by.func_70448_g().func_77973_b() == null || !(player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemGun)) {
                    data.isShooting = false;
                }
                return;
            }
            if (this.type.mode == EnumFireMode.FULLAUTO && data.isShooting) {
                this.tryToShoot(itemstack, world, player);
            }
        }
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        if (world.field_72995_K) {
            this.onUpdateClient(itemstack, world, entity, i, flag);
        } else {
            this.onUpdateServer(itemstack, world, entity, i, flag);
        }
    }

    public ItemStack onMouseHeld(ItemStack stack, World world, EntityPlayerMP player, boolean isShooting) {
        FlansModPlayerData data = FlansModPlayerHandler.getPlayerData((EntityPlayer)player);
        if (data.shootClickDelay == 0) {
            if (player.field_70154_o instanceof EntitySeat && ((EntitySeat)player.field_70154_o).seatInfo.id == 0) {
                return stack;
            }
            data.isShooting = isShooting;
            if (this.type.mode == EnumFireMode.SEMIAUTO && isShooting) {
                data.isShooting = false;
                return this.tryToShoot(stack, world, player);
            }
        }
        return stack;
    }

    public ItemStack tryToShoot(ItemStack gunStack, World world, EntityPlayerMP entityplayer) {
        if (this.type.deployable) {
            return gunStack;
        }
        FlansModPlayerData data = FlansModPlayerHandler.getPlayerData((EntityPlayer)entityplayer);
        if (data.shootTime <= 0) {
            int bulletID;
            ItemStack bulletStack = null;
            for (bulletID = 0; bulletID < this.type.numAmmoItemsInGun; ++bulletID) {
                ItemStack checkingStack = this.getBulletItemStack(gunStack, bulletID);
                if (checkingStack == null || checkingStack.func_77973_b() == null || checkingStack.func_77960_j() >= checkingStack.func_77958_k()) continue;
                bulletStack = checkingStack;
                break;
            }
            if (bulletStack == null) {
                if (this.reload(gunStack, world, (EntityPlayer)entityplayer, false)) {
                    data.shootTime = (int)this.type.getReloadTime(gunStack);
                    PacketDispatcher.sendPacketToPlayer((Packet)PacketReload.buildReloadPacket(), (Player)((Player)entityplayer));
                    if (this.type.reloadSound != null) {
                        PacketDispatcher.sendPacketToAllAround((double)entityplayer.field_70165_t, (double)entityplayer.field_70163_u, (double)entityplayer.field_70161_v, (double)50.0, (int)entityplayer.field_71093_bK, (Packet)PacketPlaySound.buildSoundPacket(entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, this.type.reloadSound, true));
                    }
                }
            } else if (bulletStack.func_77973_b() instanceof ItemBullet) {
                this.shoot(gunStack, world, bulletStack, (EntityPlayer)entityplayer);
                bulletStack.func_77964_b(bulletStack.func_77960_j() + 1);
                this.setBulletItemStack(gunStack, bulletStack, bulletID);
            }
        }
        return gunStack;
    }

    public boolean reload(ItemStack gunStack, World world, EntityPlayer player, boolean forceReload) {
        return this.reload(gunStack, world, (Entity)player, (IInventory)player.field_71071_by, player.field_71075_bZ.field_75098_d, forceReload);
    }

    public boolean reload(ItemStack gunStack, World world, Entity entity, IInventory inventory, boolean creative, boolean forceReload) {
        if (this.type.deployable) {
            return false;
        }
        if (forceReload && !this.type.canForceReload) {
            return false;
        }
        boolean reloadedSomething = false;
        for (int i = 0; i < this.type.numAmmoItemsInGun; ++i) {
            ItemStack bulletStack = this.getBulletItemStack(gunStack, i);
            if (bulletStack != null && bulletStack.func_77960_j() != bulletStack.func_77958_k() && !forceReload) continue;
            int bestSlot = -1;
            int bulletsInBestSlot = 0;
            for (int j = 0; j < inventory.func_70302_i_(); ++j) {
                int bulletsInThisSlot;
                ItemStack item = inventory.func_70301_a(j);
                if (item == null || !(item.func_77973_b() instanceof ItemBullet) || !this.type.isAmmo(((ItemBullet)item.func_77973_b()).type) || (bulletsInThisSlot = item.func_77958_k() - item.func_77960_j()) <= bulletsInBestSlot) continue;
                bestSlot = j;
                bulletsInBestSlot = bulletsInThisSlot;
            }
            if (bestSlot == -1) continue;
            ItemStack newBulletStack = inventory.func_70301_a(bestSlot);
            BulletType newBulletType = ((ItemBullet)newBulletStack.func_77973_b()).type;
            if (bulletStack != null && bulletStack.func_77973_b() instanceof ItemBullet && ((ItemBullet)bulletStack.func_77973_b()).type.dropItemOnReload != null && !creative) {
                ItemGun.dropItem(world, entity, ((ItemBullet)bulletStack.func_77973_b()).type.dropItemOnReload);
            }
            if (bulletStack != null && bulletStack.func_77960_j() < bulletStack.func_77958_k() && !InventoryHelper.addItemStackToInventory(inventory, bulletStack, creative)) {
                entity.func_70099_a(bulletStack, 0.5f);
            }
            ItemStack stackToLoad = newBulletStack.func_77946_l();
            stackToLoad.field_77994_a = 1;
            this.setBulletItemStack(gunStack, stackToLoad, i);
            if (!creative) {
                --newBulletStack.field_77994_a;
            }
            if (newBulletStack.field_77994_a <= 0) {
                newBulletStack = null;
            }
            inventory.func_70299_a(bestSlot, newBulletStack);
            reloadedSomething = true;
        }
        return reloadedSomething;
    }

    public static void dropItem(World world, Entity entity, String itemName) {
        if (itemName != null) {
            int damage = 0;
            if (itemName.contains(".")) {
                damage = Integer.parseInt(itemName.split("\\.")[1]);
                itemName = itemName.split("\\.")[0];
            }
            ItemStack dropStack = InfoType.getRecipeElement(itemName, damage);
            entity.func_70099_a(dropStack, 0.5f);
        }
    }

    private void shoot(ItemStack stack, World world, ItemStack bulletStack, EntityPlayer entityplayer) {
        BulletType bullet = ((ItemBullet)bulletStack.func_77973_b()).type;
        if (this.soundDelay <= 0 && this.type.shootSound != null) {
            AttachmentType barrel = this.type.getBarrel(stack);
            boolean silenced = barrel != null && barrel.silencer;
            PacketDispatcher.sendPacketToAllAround((double)entityplayer.field_70165_t, (double)entityplayer.field_70163_u, (double)entityplayer.field_70161_v, (double)50.0, (int)entityplayer.field_71093_bK, (Packet)PacketPlaySound.buildSoundPacket(entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, this.type.shootSound, this.type.distortSound, silenced));
            this.soundDelay = this.type.shootSoundLength;
        }
        if (!world.field_72995_K) {
            for (int k = 0; k < this.type.numBullets; ++k) {
                world.func_72838_d(((ItemBullet)bulletStack.func_77973_b()).getEntity(world, (EntityLivingBase)entityplayer, (entityplayer.func_70093_af() ? 0.7f : 1.0f) * this.type.getSpread(stack), this.type.getDamage(stack), this.type.getBulletSpeed(stack), this.type.numBullets > 1, bulletStack.func_77960_j(), this.type));
            }
            if (bullet.dropItemOnShoot != null && !entityplayer.field_71075_bZ.field_75098_d) {
                ItemGun.dropItem(world, (Entity)entityplayer, bullet.dropItemOnShoot);
            }
        }
        FlansModPlayerHandler.getPlayerData((EntityPlayer)entityplayer).shootTime = this.type.shootDelay;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (this.type.deployable) {
            Vec3 lookVec;
            float cosYaw = MathHelper.func_76134_b((float)(-entityplayer.field_70177_z * 0.01745329f - 3.141593f));
            float sinYaw = MathHelper.func_76126_a((float)(-entityplayer.field_70177_z * 0.01745329f - 3.141593f));
            float cosPitch = -MathHelper.func_76134_b((float)(-entityplayer.field_70125_A * 0.01745329f));
            float sinPitch = MathHelper.func_76126_a((float)(-entityplayer.field_70125_A * 0.01745329f));
            double length = 5.0;
            Vec3 posVec = Vec3.func_72443_a((double)entityplayer.field_70165_t, (double)(entityplayer.field_70163_u + 1.62 - (double)entityplayer.field_70129_M), (double)entityplayer.field_70161_v);
            MovingObjectPosition look = world.func_72901_a(posVec, lookVec = posVec.func_72441_c((double)(sinYaw * cosPitch) * length, (double)sinPitch * length, (double)(cosYaw * cosPitch) * length), true);
            if (look != null && look.field_72313_a == EnumMovingObjectType.TILE && look.field_72310_e == 1) {
                int playerDir = MathHelper.func_76128_c((double)((double)(entityplayer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                int i = look.field_72311_b;
                int j = look.field_72312_c;
                int k = look.field_72309_d;
                if (!world.field_72995_K) {
                    if (world.func_72798_a(i, j, k) == Block.field_72037_aS.field_71990_ca) {
                        --j;
                    }
                    if (!(!this.isSolid(world, i, j, k) || world.func_72798_a(i, j + 1, k) != 0 && world.func_72798_a(i, j + 1, k) != Block.field_72037_aS.field_71990_ca || world.func_72798_a(i + (playerDir == 1 ? 1 : 0) - (playerDir == 3 ? 1 : 0), j + 1, k - (playerDir == 0 ? 1 : 0) + (playerDir == 2 ? 1 : 0)) != 0 || world.func_72798_a(i + (playerDir == 1 ? 1 : 0) - (playerDir == 3 ? 1 : 0), j, k - (playerDir == 0 ? 1 : 0) + (playerDir == 2 ? 1 : 0)) != 0 && world.func_72798_a(i + (playerDir == 1 ? 1 : 0) - (playerDir == 3 ? 1 : 0), j, k - (playerDir == 0 ? 1 : 0) + (playerDir == 2 ? 1 : 0)) != Block.field_72037_aS.field_71990_ca)) {
                        for (EntityMG mg : EntityMG.mgs) {
                            if (mg.blockX != i || mg.blockY != j + 1 || mg.blockZ != k || mg.field_70128_L) continue;
                            return itemstack;
                        }
                        if (!world.field_72995_K) {
                            world.func_72838_d((Entity)new EntityMG(world, i, j + 1, k, playerDir, this.type));
                        }
                        if (!entityplayer.field_71075_bZ.field_75098_d) {
                            itemstack.field_77994_a = 0;
                        }
                    }
                }
            }
        }
        if (world.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                Minecraft.func_71410_x().field_71460_t.field_78516_c.func_78441_a();
            }
        }
        return itemstack;
    }

    private boolean isSolid(World world, int i, int j, int k) {
        int blockID = world.func_72798_a(i, j, k);
        if (blockID == 0) {
            return false;
        }
        return Block.field_71973_m[blockID].field_72018_cp.func_76220_a() && Block.field_71973_m[blockID].func_71926_d();
    }

    public float getDamageVsEntity(Entity par1Entity, ItemStack itemStack) {
        return this.type.getMeleeDamage(itemStack);
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return this.type.meleeDamage == 0.0f || this.type.FOVFactor != 1.0f;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int X, int Y, int Z, EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack par1ItemStack, int par2) {
        return this.type.colour;
    }

    public boolean isItemStackDamageable() {
        return true;
    }

    public void func_77633_a(int i, CreativeTabs tabs, List list) {
        NBTTagCompound tags;
        ItemStack gunStack = new ItemStack(i, 1, 0);
        gunStack.field_77990_d = tags = new NBTTagCompound();
        list.add(gunStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister icon) {
        this.field_77791_bV = icon.func_94245_a("FlansMod:" + this.type.iconPath);
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 100;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }
}

