/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.teams;

import co.uk.flansmods.common.FlansModPlayerData;
import co.uk.flansmods.common.FlansModPlayerHandler;
import co.uk.flansmods.common.network.PacketTeamSelect;
import co.uk.flansmods.common.teams.ITeamBase;
import co.uk.flansmods.common.teams.ITeamObject;
import co.uk.flansmods.common.teams.PlayerClass;
import co.uk.flansmods.common.teams.Team;
import co.uk.flansmods.common.teams.TeamsManager;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.Vec3;

public abstract class Gametype {
    public static List<Gametype> gametypes = new ArrayList<Gametype>();
    public static TeamsManager teamsManager = TeamsManager.getInstance();
    public static Random rand = new Random();
    public String name;
    public String shortName;
    public int numTeamsRequired;

    public static Gametype getGametype(String type) {
        for (Gametype gametype : gametypes) {
            if (!gametype.shortName.equals(type)) continue;
            return gametype;
        }
        return null;
    }

    public Gametype(String s, String s1, int numTeams) {
        this.name = s;
        this.shortName = s1;
        this.numTeamsRequired = numTeams;
        gametypes.add(this);
    }

    public EntityPlayerMP getPlayer(String username) {
        return MinecraftServer.func_71196_a((MinecraftServer)FMLCommonHandler.instance().getMinecraftServerInstance()).func_72361_f(username);
    }

    public static FlansModPlayerData getPlayerData(EntityPlayerMP player) {
        return FlansModPlayerHandler.getPlayerData((EntityPlayer)player);
    }

    public static void sendPacketToPlayer(Packet packet, EntityPlayerMP player) {
        PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)((Player)player));
    }

    public static void sendTeamsMenuToPlayer(EntityPlayerMP player) {
        if (Gametype.teamsManager.teams == null) {
            return;
        }
        Team[] availableTeams = new Team[Gametype.teamsManager.teams.length + 1];
        for (int i = 0; i < Gametype.teamsManager.teams.length; ++i) {
            availableTeams[i] = Gametype.teamsManager.teams[i];
        }
        availableTeams[Gametype.teamsManager.teams.length] = Team.spectators;
        Gametype.getPlayerData((EntityPlayerMP)player).team = Team.spectators;
        Gametype.sendPacketToPlayer(PacketTeamSelect.buildTeamChoicesPacket(availableTeams), player);
    }

    public static void sendClassMenuToPlayer(EntityPlayerMP player) {
        Team team = Gametype.getPlayerData((EntityPlayerMP)player).team;
        if (team == null) {
            Gametype.sendTeamsMenuToPlayer(player);
        } else if (team != Team.spectators && team.classes.size() > 0) {
            Gametype.sendPacketToPlayer(PacketTeamSelect.buildClassChoicesPacket(team.classes.toArray(new PlayerClass[team.classes.size()])), player);
        }
    }

    public static String[] getPlayerNames() {
        return MinecraftServer.func_71276_C().func_71213_z();
    }

    public static List<EntityPlayer> getPlayers() {
        return MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
    }

    public static void showTeamsMenuToAll(boolean spectatorsValid) {
        for (EntityPlayer player : Gametype.getPlayers()) {
            if (Gametype.getPlayerData((EntityPlayerMP)player) == null) continue;
            if (Gametype.getPlayerData((EntityPlayerMP)((EntityPlayerMP)player)).team == null || !Gametype.isAValidTeam(Gametype.getPlayerData((EntityPlayerMP)((EntityPlayerMP)player)).team, spectatorsValid)) {
                Gametype.sendTeamsMenuToPlayer((EntityPlayerMP)player);
                continue;
            }
            if (Gametype.getPlayerData((EntityPlayerMP)((EntityPlayerMP)player)).playerClass != null) continue;
            Gametype.sendClassMenuToPlayer((EntityPlayerMP)player);
        }
    }

    public static boolean isAValidTeam(Team team, boolean spectatorsValid) {
        if (Gametype.teamsManager.teams == null) {
            return false;
        }
        if (team == Team.spectators && spectatorsValid) {
            return true;
        }
        for (Team t : Gametype.teamsManager.teams) {
            if (t != team) continue;
            return true;
        }
        return false;
    }

    public static void resetScores() {
        if (Gametype.teamsManager.teams != null) {
            for (Team team : Gametype.teamsManager.teams) {
                if (team == null) continue;
                team.score = 0;
            }
        }
        for (EntityPlayer player : Gametype.getPlayers()) {
            Gametype.getPlayerData((EntityPlayerMP)player).resetScore();
        }
    }

    public static void respawnAll() {
        for (EntityPlayer player : Gametype.getPlayers()) {
            TeamsManager.getInstance().forceRespawn((EntityPlayerMP)player);
        }
    }

    public static void givePoints(EntityPlayerMP player, int points) {
        FlansModPlayerData data = Gametype.getPlayerData(player);
        data.score += points;
        if (data.team != null) {
            data.team.score += points;
        }
    }

    public static EntityPlayerMP getPlayerFromDamageSource(DamageSource source) {
        EntityPlayerMP attacker = null;
        if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_76346_g() instanceof EntityPlayerMP) {
            attacker = (EntityPlayerMP)((EntityDamageSource)source).func_76346_g();
        }
        if (source instanceof EntityDamageSourceIndirect && ((EntityDamageSourceIndirect)source).func_76364_f() instanceof EntityPlayerMP) {
            attacker = (EntityPlayerMP)((EntityDamageSourceIndirect)source).func_76364_f();
        }
        return attacker;
    }

    public abstract void teamsSet();

    public abstract void initGametype();

    public void startNewRound() {
        FlansModPlayerHandler.roundEnded();
        for (ITeamBase base : Gametype.teamsManager.bases) {
            base.startRound();
        }
        Gametype.respawnAll();
        for (EntityPlayer player : Gametype.getPlayers()) {
            Gametype.getPlayerData((EntityPlayerMP)((EntityPlayerMP)player)).playerClass = null;
            Gametype.getPlayerData((EntityPlayerMP)((EntityPlayerMP)player)).newPlayerClass = null;
            if (Gametype.getPlayerData((EntityPlayerMP)((EntityPlayerMP)player)).team == null) continue;
            Gametype.getPlayerData((EntityPlayerMP)((EntityPlayerMP)player)).team.removePlayer(player);
        }
        Gametype.resetScores();
        TeamsManager.messageAll("\u00a7fA new round has started!");
        if (Gametype.teamsManager.teams != null) {
            for (Team team : Gametype.teamsManager.teams) {
                if (team != null) continue;
                return;
            }
            Gametype.showTeamsMenuToAll(false);
        }
    }

    public void stopGametype() {
        FlansModPlayerHandler.roundEnded();
    }

    public abstract void tick();

    public abstract void playerJoined(EntityPlayerMP var1);

    public abstract void playerRespawned(EntityPlayerMP var1);

    public abstract void playerQuit(EntityPlayerMP var1);

    public abstract boolean playerChoseTeam(EntityPlayerMP var1, Team var2, Team var3);

    public abstract boolean playerChoseClass(EntityPlayerMP var1, PlayerClass var2);

    public abstract boolean playerAttacked(EntityPlayerMP var1, DamageSource var2);

    public abstract void playerKilled(EntityPlayerMP var1, DamageSource var2);

    public abstract void baseAttacked(ITeamBase var1, DamageSource var2);

    public abstract void objectAttacked(ITeamObject var1, DamageSource var2);

    public abstract void baseClickedByPlayer(ITeamBase var1, EntityPlayerMP var2);

    public abstract void objectClickedByPlayer(ITeamObject var1, EntityPlayerMP var2);

    public abstract Vec3 getSpawnPoint(EntityPlayerMP var1);

    public abstract boolean setVariable(String var1, String var2);

    public abstract void readFromNBT(NBTTagCompound var1);

    public abstract void saveToNBT(NBTTagCompound var1);

    public abstract boolean sortScoreboardByTeam();
}

