/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.teams;

import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.FlansModPlayerData;
import co.uk.flansmods.common.guns.EntityDamageSourceGun;
import co.uk.flansmods.common.teams.Gametype;
import co.uk.flansmods.common.teams.ITeamBase;
import co.uk.flansmods.common.teams.ITeamObject;
import co.uk.flansmods.common.teams.PlayerClass;
import co.uk.flansmods.common.teams.Team;
import co.uk.flansmods.common.teams.TeamsManager;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;

public class GametypeNerf
extends Gametype {
    public boolean friendlyFire = false;
    public boolean autoBalance = true;
    public int scoreLimit = 25;
    public int newRoundTimer = 0;
    public int time;
    public int autoBalanceInterval = 1200;

    public GametypeNerf() {
        super("Nerf Team Deathmatch", "Nerf", 2);
    }

    @Override
    public void initGametype() {
        this.startNewRound();
    }

    @Override
    public void teamsSet() {
        this.startNewRound();
    }

    @Override
    public void stopGametype() {
        super.stopGametype();
        GametypeNerf.resetScores();
    }

    @Override
    public void tick() {
        --this.newRoundTimer;
        if (this.newRoundTimer == 0) {
            if (FlansMod.useRotation) {
                TeamsManager.getInstance().switchToNextGametype();
                return;
            }
            this.startNewRound();
        }
        if (GametypeNerf.teamsManager.teams != null) {
            for (Team team : GametypeNerf.teamsManager.teams) {
                if (team == null || team.score < this.scoreLimit || this.newRoundTimer >= 0) continue;
                TeamsManager.messageAll("\u00a7" + team.textColour + team.name + "\u00a7f won!");
                this.newRoundTimer = 200;
                TeamsManager.messageAll("\u00a7fThe next round will start in 10 seconds");
                this.time = -300;
            }
        }
        ++this.time;
        if (this.autoBalance && this.time % this.autoBalanceInterval == this.autoBalanceInterval - 200 && this.needAutobalance()) {
            TeamsManager.messageAll("\u00a7fAutobalancing teams...");
        }
        if (this.autoBalance && this.time % this.autoBalanceInterval == 0 && this.needAutobalance()) {
            this.autobalance();
        }
    }

    public boolean needAutobalance() {
        int membersTeamB;
        if (GametypeNerf.teamsManager.teams == null || GametypeNerf.teamsManager.teams[0] == null || GametypeNerf.teamsManager.teams[1] == null) {
            return false;
        }
        int membersTeamA = GametypeNerf.teamsManager.teams[0].members.size();
        return Math.abs(membersTeamA - (membersTeamB = GametypeNerf.teamsManager.teams[1].members.size())) > 1;
    }

    public void autobalance() {
        int i;
        int membersTeamB;
        if (GametypeNerf.teamsManager.teams == null || GametypeNerf.teamsManager.teams[0] == null || GametypeNerf.teamsManager.teams[1] == null) {
            return;
        }
        int membersTeamA = GametypeNerf.teamsManager.teams[0].members.size();
        if (membersTeamA - (membersTeamB = GametypeNerf.teamsManager.teams[1].members.size()) > 1) {
            for (i = 0; i < (membersTeamA - membersTeamB) / 2; ++i) {
                GametypeNerf.sendClassMenuToPlayer(this.getPlayer(GametypeNerf.teamsManager.teams[1].addPlayer(GametypeNerf.teamsManager.teams[0].removeWorstPlayer())));
            }
        }
        if (membersTeamB - membersTeamA > 1) {
            for (i = 0; i < (membersTeamB - membersTeamA) / 2; ++i) {
                GametypeNerf.sendClassMenuToPlayer(this.getPlayer(GametypeNerf.teamsManager.teams[0].addPlayer(GametypeNerf.teamsManager.teams[1].removeWorstPlayer())));
            }
        }
    }

    @Override
    public void playerJoined(EntityPlayerMP player) {
        GametypeNerf.sendTeamsMenuToPlayer(player);
    }

    @Override
    public boolean playerChoseTeam(EntityPlayerMP player, Team team, Team previousTeam) {
        int membersOnBothTeams;
        int membersOnTeamTheyDontWantToJoin;
        int membersOnTeamTheyWantToJoin;
        if (GametypeNerf.teamsManager.teams == null || GametypeNerf.teamsManager.teams[0] == null || GametypeNerf.teamsManager.teams[1] == null) {
            return false;
        }
        if (this.autoBalance && (membersOnTeamTheyWantToJoin = team.members.size()) > (membersOnTeamTheyDontWantToJoin = (membersOnBothTeams = GametypeNerf.teamsManager.teams[0].members.size() + GametypeNerf.teamsManager.teams[1].members.size()) - membersOnTeamTheyWantToJoin)) {
            return false;
        }
        if (previousTeam != null && previousTeam != Team.spectators && previousTeam != team && GametypeNerf.isAValidTeam(previousTeam, true)) {
            ++GametypeNerf.getPlayerData((EntityPlayerMP)player).deaths;
            --GametypeNerf.getPlayerData((EntityPlayerMP)player).score;
            GametypeNerf.getPlayerData((EntityPlayerMP)player).playerClass = null;
            GametypeNerf.getPlayerData((EntityPlayerMP)player).newPlayerClass = null;
        }
        GametypeNerf.sendClassMenuToPlayer(player);
        if (team != previousTeam) {
            teamsManager.forceRespawn(player);
        }
        return true;
    }

    @Override
    public boolean playerChoseClass(EntityPlayerMP player, PlayerClass playerClass) {
        Team team = GametypeNerf.getPlayerData((EntityPlayerMP)player).team;
        if (!team.classes.contains(playerClass)) {
            return false;
        }
        GametypeNerf.getPlayerData((EntityPlayerMP)player).newPlayerClass = playerClass;
        if (GametypeNerf.getPlayerData((EntityPlayerMP)player).playerClass == null) {
            teamsManager.resetInventory((EntityPlayer)player);
        } else {
            player.func_71035_c("You will respawn with the " + playerClass.name.toLowerCase() + " class");
        }
        return true;
    }

    @Override
    public void playerQuit(EntityPlayerMP player) {
    }

    @Override
    public boolean playerAttacked(EntityPlayerMP player, DamageSource source) {
        if (GametypeNerf.getPlayerData(player) == null || GametypeNerf.getPlayerData((EntityPlayerMP)player).team == null) {
            return false;
        }
        if (this.newRoundTimer > 0) {
            return false;
        }
        if (GametypeNerf.getPlayerData((EntityPlayerMP)player).out) {
            return false;
        }
        if (GametypeNerf.getPlayerData((EntityPlayerMP)player).team == Team.spectators) {
            return false;
        }
        EntityPlayerMP attacker = GametypeNerf.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (GametypeNerf.getPlayerData(attacker) == null || GametypeNerf.getPlayerData((EntityPlayerMP)attacker).team == null) {
                return false;
            }
            if (GametypeNerf.getPlayerData((EntityPlayerMP)attacker).team == Team.spectators) {
                return false;
            }
            if (GametypeNerf.getPlayerData((EntityPlayerMP)player).team == GametypeNerf.getPlayerData((EntityPlayerMP)attacker).team && !this.friendlyFire) {
                return false;
            }
            if (GametypeNerf.getPlayerData((EntityPlayerMP)attacker).out) {
                return false;
            }
            if (source instanceof EntityDamageSourceGun) {
                GametypeNerf.getPlayerData((EntityPlayerMP)player).out = true;
                GametypeNerf.givePoints(attacker, 1);
                ++GametypeNerf.getPlayerData((EntityPlayerMP)attacker).kills;
                ++GametypeNerf.getPlayerData((EntityPlayerMP)player).deaths;
                player.func_71035_c("You are hit. Go back to base to respawn");
                attacker.func_71035_c("You hit " + player.field_71092_bJ + ". He is out until he returns to base");
            }
        }
        return false;
    }

    @Override
    public void playerKilled(EntityPlayerMP player, DamageSource source) {
    }

    @Override
    public void baseAttacked(ITeamBase base, DamageSource source) {
    }

    @Override
    public void objectAttacked(ITeamObject object, DamageSource source) {
    }

    @Override
    public void baseClickedByPlayer(ITeamBase base, EntityPlayerMP player) {
        if (GametypeNerf.getPlayerData((EntityPlayerMP)player).out) {
            GametypeNerf.getPlayerData((EntityPlayerMP)player).out = false;
            player.func_71035_c("You are back in the game!");
        }
    }

    @Override
    public void objectClickedByPlayer(ITeamObject object, EntityPlayerMP player) {
        if (GametypeNerf.getPlayerData((EntityPlayerMP)player).out) {
            GametypeNerf.getPlayerData((EntityPlayerMP)player).out = false;
            player.func_71035_c("You are back in the game!");
        }
    }

    @Override
    public Vec3 getSpawnPoint(EntityPlayerMP player) {
        FlansModPlayerData data = GametypeNerf.getPlayerData(player);
        ArrayList<ITeamObject> validSpawnPoints = new ArrayList<ITeamObject>();
        if (data.team == null) {
            return null;
        }
        for (int j = 0; j < data.team.bases.size(); ++j) {
            ITeamBase base = data.team.bases.get(j);
            if (base.getMap() != GametypeNerf.teamsManager.currentMap) continue;
            for (int i = 0; i < base.getObjects().size(); ++i) {
                if (!base.getObjects().get(i).isSpawnPoint()) continue;
                validSpawnPoints.add(base.getObjects().get(i));
            }
        }
        if (validSpawnPoints.size() > 0) {
            ITeamObject spawnPoint = (ITeamObject)validSpawnPoints.get(rand.nextInt(validSpawnPoints.size()));
            return Vec3.func_72443_a((double)spawnPoint.getPosX(), (double)spawnPoint.getPosY(), (double)spawnPoint.getPosZ());
        }
        return null;
    }

    @Override
    public void playerRespawned(EntityPlayerMP player) {
    }

    @Override
    public boolean setVariable(String variable, String value) {
        if (variable.toLowerCase().equals("scorelimit")) {
            this.scoreLimit = Integer.parseInt(value);
            return true;
        }
        if (variable.toLowerCase().equals("friendlyfire")) {
            this.friendlyFire = Boolean.parseBoolean(value);
            return true;
        }
        if (variable.toLowerCase().equals("autobalance")) {
            this.autoBalance = Boolean.parseBoolean(value);
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound tags) {
        this.scoreLimit = tags.func_74762_e("TDMScoreLimit");
        this.friendlyFire = tags.func_74767_n("TDMFriendlyFire");
        this.autoBalance = tags.func_74767_n("TDMAutoBalance");
    }

    @Override
    public void saveToNBT(NBTTagCompound tags) {
        tags.func_74768_a("TDMScoreLimit", this.scoreLimit);
        tags.func_74757_a("TDMFriendlyFire", this.friendlyFire);
        tags.func_74757_a("TDMAutoBalance", this.autoBalance);
    }

    @Override
    public boolean sortScoreboardByTeam() {
        return true;
    }
}

