/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class OreDictionary {
    private static boolean hasInit = false;
    private static int maxID = 0;
    private static HashMap<String, Integer> oreIDs = new HashMap();
    private static HashMap<Integer, ArrayList<ItemStack>> oreStacks = new HashMap();
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    public static void initVanillaEntries() {
        if (!hasInit) {
            OreDictionary.registerOre("logWood", new ItemStack(Block.field_71951_J, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("plankWood", new ItemStack(Block.field_71988_x, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("slabWood", new ItemStack((Block)Block.field_72092_bO, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("stairWood", Block.field_72063_at);
            OreDictionary.registerOre("stairWood", Block.field_72072_bX);
            OreDictionary.registerOre("stairWood", Block.field_72070_bY);
            OreDictionary.registerOre("stairWood", Block.field_72074_bW);
            OreDictionary.registerOre("stickWood", Item.field_77669_D);
            OreDictionary.registerOre("treeSapling", new ItemStack(Block.field_71987_y, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new ItemStack((Block)Block.field_71952_K, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("oreGold", Block.field_71941_G);
            OreDictionary.registerOre("oreIron", Block.field_71949_H);
            OreDictionary.registerOre("oreLapis", Block.field_71947_N);
            OreDictionary.registerOre("oreDiamond", Block.field_72073_aw);
            OreDictionary.registerOre("oreRedstone", Block.field_72047_aN);
            OreDictionary.registerOre("oreEmerald", Block.field_72068_bR);
            OreDictionary.registerOre("oreQuartz", Block.field_94342_cr);
            OreDictionary.registerOre("stone", Block.field_71981_t);
            OreDictionary.registerOre("cobblestone", Block.field_71978_w);
            OreDictionary.registerOre("record", Item.field_77819_bI);
            OreDictionary.registerOre("record", Item.field_77797_bJ);
            OreDictionary.registerOre("record", Item.field_77799_bK);
            OreDictionary.registerOre("record", Item.field_77793_bL);
            OreDictionary.registerOre("record", Item.field_77795_bM);
            OreDictionary.registerOre("record", Item.field_77805_bN);
            OreDictionary.registerOre("record", Item.field_77807_bO);
            OreDictionary.registerOre("record", Item.field_77801_bP);
            OreDictionary.registerOre("record", Item.field_77803_bQ);
            OreDictionary.registerOre("record", Item.field_77783_bR);
            OreDictionary.registerOre("record", Item.field_77781_bS);
            OreDictionary.registerOre("record", Item.field_85180_cf);
        }
        HashMap<ItemStack, String> replacements = new HashMap<ItemStack, String>();
        replacements.put(new ItemStack(Item.field_77669_D), "stickWood");
        replacements.put(new ItemStack(Block.field_71988_x), "plankWood");
        replacements.put(new ItemStack(Block.field_71988_x, 1, Short.MAX_VALUE), "plankWood");
        replacements.put(new ItemStack(Block.field_71981_t), "stone");
        replacements.put(new ItemStack(Block.field_71981_t, 1, Short.MAX_VALUE), "stone");
        replacements.put(new ItemStack(Block.field_71978_w), "cobblestone");
        replacements.put(new ItemStack(Block.field_71978_w, 1, Short.MAX_VALUE), "cobblestone");
        String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        for (int i = 0; i < 16; ++i) {
            ItemStack dye = new ItemStack(Item.field_77756_aW, 1, i);
            if (!hasInit) {
                OreDictionary.registerOre(dyes[i], dye);
            }
            replacements.put(dye, dyes[i]);
        }
        hasInit = true;
        ItemStack[] replaceStacks = replacements.keySet().toArray(new ItemStack[replacements.keySet().size()]);
        ItemStack[] exclusions = new ItemStack[]{new ItemStack(Block.field_71948_O), new ItemStack(Item.field_77743_bc), new ItemStack(Block.field_72007_bm), new ItemStack((Block)Block.field_72079_ak), new ItemStack(Block.field_72057_aH), new ItemStack(Block.field_82515_ce)};
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        ArrayList<Object> recipesToRemove = new ArrayList<Object>();
        ArrayList<Object> recipesToAdd = new ArrayList<Object>();
        for (Object obj : recipes) {
            ItemStack output;
            ShapedRecipes recipe;
            if (obj instanceof ShapedRecipes) {
                recipe = (ShapedRecipes)obj;
                output = recipe.func_77571_b();
                if (output != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.field_77574_d, replaceStacks)) continue;
                recipesToRemove.add(recipe);
                recipesToAdd.add(new ShapedOreRecipe(recipe, replacements));
                continue;
            }
            if (!(obj instanceof ShapelessRecipes) || (output = (recipe = (ShapelessRecipes)obj).func_77571_b()) != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.field_77579_b.toArray(new ItemStack[recipe.field_77579_b.size()]), replaceStacks)) continue;
            recipesToRemove.add((IRecipe)obj);
            ShapelessOreRecipe newRecipe = new ShapelessOreRecipe((ShapelessRecipes)recipe, replacements);
            recipesToAdd.add(newRecipe);
        }
        recipes.removeAll(recipesToRemove);
        recipes.addAll(recipesToAdd);
        if (recipesToRemove.size() > 0) {
            System.out.println("Replaced " + recipesToRemove.size() + " ore recipies");
        }
    }

    public static int getOreID(String name) {
        Integer val = oreIDs.get(name);
        if (val == null) {
            val = maxID++;
            oreIDs.put(name, val);
            oreStacks.put(val, new ArrayList());
        }
        return val;
    }

    public static String getOreName(int id) {
        for (Map.Entry<String, Integer> entry : oreIDs.entrySet()) {
            if (id != entry.getValue()) continue;
            return entry.getKey();
        }
        return "Unknown";
    }

    public static int getOreID(ItemStack itemStack) {
        if (itemStack == null) {
            return -1;
        }
        for (Map.Entry<Integer, ArrayList<ItemStack>> ore : oreStacks.entrySet()) {
            for (ItemStack target : ore.getValue()) {
                if (itemStack.field_77993_c != target.field_77993_c || target.func_77960_j() != Short.MAX_VALUE && itemStack.func_77960_j() != target.func_77960_j()) continue;
                return ore.getKey();
            }
        }
        return -1;
    }

    public static ArrayList<ItemStack> getOres(String name) {
        return OreDictionary.getOres(OreDictionary.getOreID(name));
    }

    public static String[] getOreNames() {
        return oreIDs.keySet().toArray(new String[oreIDs.keySet().size()]);
    }

    public static ArrayList<ItemStack> getOres(Integer id) {
        ArrayList<Object> val = oreStacks.get(id);
        if (val == null) {
            val = new ArrayList();
            oreStacks.put(id, val);
        }
        return val;
    }

    private static boolean containsMatch(boolean strict, ItemStack[] inputs, ItemStack ... targets) {
        for (ItemStack input : inputs) {
            for (ItemStack target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean itemMatches(ItemStack target, ItemStack input, boolean strict) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.field_77993_c == input.field_77993_c && (target.func_77960_j() == Short.MAX_VALUE && !strict || target.func_77960_j() == input.func_77960_j());
    }

    public static void registerOre(String name, Item ore) {
        OreDictionary.registerOre(name, new ItemStack(ore));
    }

    public static void registerOre(String name, Block ore) {
        OreDictionary.registerOre(name, new ItemStack(ore));
    }

    public static void registerOre(String name, ItemStack ore) {
        OreDictionary.registerOre(name, OreDictionary.getOreID(name), ore);
    }

    public static void registerOre(int id, Item ore) {
        OreDictionary.registerOre(id, new ItemStack(ore));
    }

    public static void registerOre(int id, Block ore) {
        OreDictionary.registerOre(id, new ItemStack(ore));
    }

    public static void registerOre(int id, ItemStack ore) {
        OreDictionary.registerOre(OreDictionary.getOreName(id), id, ore);
    }

    private static void registerOre(String name, int id, ItemStack ore) {
        ArrayList<ItemStack> ores = OreDictionary.getOres(id);
        ore = ore.func_77946_l();
        ores.add(ore);
        MinecraftForge.EVENT_BUS.post((Event)new OreRegisterEvent(name, ore));
    }

    static {
        OreDictionary.initVanillaEntries();
    }

    public static class OreRegisterEvent
    extends Event {
        public final String Name;
        public final ItemStack Ore;

        public OreRegisterEvent(String name, ItemStack ore) {
            this.Name = name;
            this.Ore = ore;
        }
    }
}

