package info.jbcs.minecraft.statues;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;

public class EntityStatuePlayer extends EntityPlayer {
	static ResourceLocation	emptySkin	= new ResourceLocation("statues:textures/steve.png");
	String					skinName	= "";
	ResourceLocation		skin;
	AbstractTexture			dataSkin;

	StatueParameters		pose;

	public EntityStatuePlayer(World world, String username) {
		super(world, username);
	}

	@Override
	public void sendChatToPlayer(ChatMessageComponent chatmessagecomponent) {

	}

	@Override
	public boolean canCommandSenderUseCommand(int i, String s) {
		return false;
	}

	@Override
	public ChunkCoordinates getPlayerCoordinates() {
		return null;
	}

	public void applySkin(String name, Block block, int side, int meta) {
		if(block==null) block=Block.stone;
		
		ResourceLocation steveSkin = new ResourceLocation("statues:textures/steve.png|B" + block.blockID + "," + side + "," + meta);
		AbstractTexture steveDataSkin = getDataForSteve(steveSkin, new ResourceLocation("statues:textures/steve.png"), block, side, meta);

		if (name != null && !name.isEmpty()) {
			skin = new ResourceLocation("skins/" + StringUtils.stripControlCodes(name) + "|B" + block.blockID + "," + side + "," + meta);
			dataSkin = getTextureForSkin(skin, steveDataSkin, name, block, side, meta);
		} else {
			skin = steveSkin;
			dataSkin = steveDataSkin;
		}
	}

	public AbstractTexture getTextureSkin() {
		return dataSkin;
	}

	public ResourceLocation getLocationSkin() {
		return skin;
	}

	public AbstractTexture getTextureForSkin(ResourceLocation skin, AbstractTexture fallbackSkin, String name, Block block, int side, int meta) {
		TextureManager texturemanager = Minecraft.getMinecraft().getTextureManager();
		AbstractTexture tex = (AbstractTexture) texturemanager.getTexture(skin);

		if (tex == null) {
			tex = new StatueTextureDownloaded(skin, AbstractClientPlayer.getSkinUrl(name), fallbackSkin, new ImageStatueBufferDownload(this, block, side, meta, name+"."+block.blockID+"."+meta));
			texturemanager.loadTexture(skin, tex);
		}

		return tex;
	}

	public AbstractTexture getDataForSteve(ResourceLocation skin, ResourceLocation base, Block block, int side, int meta) {
		TextureManager texturemanager = Minecraft.getMinecraft().getTextureManager();
		AbstractTexture tex = (AbstractTexture) texturemanager.getTexture(skin);

		if (tex == null) {
			tex = new StatueTextureStatic(base, new ImageStatueBufferDownload(this, block, side, meta,"steve."+block.blockID+"."+meta));
			texturemanager.loadTexture(skin, tex);
		}

		return tex;
	}
}
