package info.jbcs.minecraft.statues;

import info.jbcs.minecraft.utilities.General;
import info.jbcs.minecraft.utilities.packets.PacketData;
import info.jbcs.minecraft.utilities.packets.PacketHandler;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;

public class Packets {

	static PacketHandler sculpt = new PacketHandler("Sculpture creation packet") {
		@Override
		public void onData(DataInputStream stream, EntityPlayer player) throws IOException {
			final int x = stream.readInt();
			final int y = stream.readInt();
			final int z = stream.readInt();
			int face = stream.readByte();
			
			final int id=player.worldObj.getBlockId(x,y,z);
			if(! Statues.canSculpt(id,player.worldObj,x,y,z)) return;

			final int meta=player.worldObj.getBlockMetadata(x,y,z);
			if(id!=player.worldObj.getBlockId(x,y+1,z) || meta !=player.worldObj.getBlockMetadata(x,y+1,z)) return;
			
			player.worldObj.setBlock(x, y, z, Statues.statue.blockID,face,3);
			
			TileEntity tileEntity = player.worldObj.getBlockTileEntity(x, y, z);
			if (!(tileEntity instanceof TileEntityStatue))
				return;
			TileEntityStatue entity = (TileEntityStatue) tileEntity;

			entity.pose.read(stream);
			entity.skinName=Packet.readString(stream, 16);
			entity.block=General.getBlock(id);
			entity.meta=meta;
			entity.facing=2;
			
			player.worldObj.setBlock(x, y+1, z, Statues.statue.blockID, face|4,3);
			player.worldObj.notifyBlocksOfNeighborChange(x, y, z, Statues.statue.blockID);
			player.worldObj.markBlockForUpdate(x, y, z);
			
			sculpted.sendToPlayers(player.posX, player.posY, player.posZ, player.dimension, 30,new PacketData(){
				@Override
				public void data(DataOutputStream stream) throws IOException {
					stream.writeInt(x);
					stream.writeInt(y);
					stream.writeInt(z);
					stream.writeShort(id);
					stream.writeByte(meta);
				}
			});
		}
	};

	static PacketHandler adjustStatue = new PacketHandler("Adjust sculpture packet") {
		@Override
		public void onData(DataInputStream stream, EntityPlayer player) throws IOException {
			final int x = stream.readInt();
			final int y = stream.readInt();
			final int z = stream.readInt();
			float itemLeftA = stream.readFloat();
			float itemRightA = stream.readFloat();
			
			TileEntity tileEntity = player.worldObj.getBlockTileEntity(x, y, z);
			if (!(tileEntity instanceof TileEntityStatue))
				return;
			TileEntityStatue entity = (TileEntityStatue) tileEntity;

			entity.pose.itemLeftA=itemLeftA;
			entity.pose.itemRightA=itemRightA;
			player.worldObj.markBlockForUpdate(x, y, z);
		}
	};

	static PacketHandler sculpted = new PacketHandler("A block has been sculpted") {
		@Override
		public void onData(DataInputStream stream, EntityPlayer player) throws IOException {
			final int x=stream.readInt();
			final int y=stream.readInt();
			final int z=stream.readInt();
			final short id=stream.readShort();
			final byte meta=stream.readByte();
			
			GeneralStatueClient.spawnSculptEffect(x, y, z, id, meta);
			GeneralStatueClient.spawnSculptEffect(x, y+1, z, id, meta);
		}
	};

}
