/**
 * TileEntity class of the statue
 */

package info.jbcs.minecraft.statues;

import info.jbcs.minecraft.utilities.General;
import info.jbcs.minecraft.utilities.InventoryStatic;

import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;

public class TileEntityStatue extends TileEntity implements IInventory {
	private EntityPlayer	clientPlayer;
	public String			skinName	= "";
	public StatueParameters	pose		= new StatueParameters();

	public Block			block		= Block.stone;
	public int				meta		= 0;
	public int				facing		= 0;
	boolean					updated		= true;

	InventoryStatic inventory = new InventoryStatic(6) {
		@Override
		public String getInvName() {
			return "Statue";
		}
		
		@Override
		public boolean isUseableByPlayer(EntityPlayer entityplayer) {
			if (worldObj.getBlockTileEntity(xCoord, yCoord, zCoord) != TileEntityStatue.this) {
				return false;
			} else {
				return entityplayer.getDistanceSq(xCoord + 0.5D, yCoord + 0.5D, zCoord + 0.5D) <= 64D;
			}
		}
		
		@Override
		public void onInventoryChanged() {
			if(clientPlayer==null) return;
			
			clientPlayer.inventory.mainInventory[0]=getStackInSlot(4);
			clientPlayer.inventory.mainInventory[1]=getStackInSlot(5);
			clientPlayer.inventory.armorInventory[0]=getStackInSlot(3);
			clientPlayer.inventory.armorInventory[1]=getStackInSlot(2);
			clientPlayer.inventory.armorInventory[2]=getStackInSlot(1);
			clientPlayer.inventory.armorInventory[3]=getStackInSlot(0);
		}
		
	};

	void randomize(Random rand){
	}

	@Override
	public int getSizeInventory() {
		return inventory.getSizeInventory();
	}

	@Override
	public ItemStack getStackInSlot(int i) {
		return inventory.getStackInSlot(i);
	}

	@Override
	public ItemStack decrStackSize(int i, int j) {
		return inventory.decrStackSize(i, j);
	}

	@Override
	public void setInventorySlotContents(int i, ItemStack itemstack) {
		inventory.setInventorySlotContents(i, itemstack);
	}

	@Override
	public String getInvName() {
		return inventory.getInvName();
	}

	@Override
	public int getInventoryStackLimit() {
		return inventory.getInventoryStackLimit();
	}

	@Override
	public boolean isUseableByPlayer(EntityPlayer entityplayer) {
		return inventory.isUseableByPlayer(entityplayer);
	}

	public EntityStatuePlayer getStatue(){
		if(clientPlayer==null){
			EntityStatuePlayer player=new EntityStatuePlayer(worldObj, skinName);
			player.ticksExisted=10;
			player.pose=pose;		
			player.applySkin(skinName, block, facing, meta);

			clientPlayer=player;
			inventory.onInventoryChanged();
		}
		
		return (EntityStatuePlayer)clientPlayer;
	}
	
	@Override
	public void readFromNBT(NBTTagCompound nbttagcompound) {
		super.readFromNBT(nbttagcompound);

		if(nbttagcompound.hasKey("items")){
			inventory.clear();
			inventory.readFromNBT(nbttagcompound);
		}

		skinName = nbttagcompound.getString("skin");
		pose.readFromNBT(nbttagcompound);
		
		block=General.getBlock(nbttagcompound.getShort("blockId"));
		if(block==null) block=Block.stone;
		meta=nbttagcompound.getByte("meta");
		facing=nbttagcompound.getByte("face");
		
		updateModel();
	}

	@Override
	public void writeToNBT(NBTTagCompound nbttagcompound) {
		super.writeToNBT(nbttagcompound);
		
		inventory.writeToNBT(nbttagcompound);
		nbttagcompound.setString("skin", skinName);
		pose.writeToNBT(nbttagcompound);
		
		nbttagcompound.setShort("blockId",(short)block.blockID);
		nbttagcompound.setByte("meta",(byte)meta);
		nbttagcompound.setByte("face",(byte)facing);
	}

	@Override
	public void onInventoryChanged() {
		worldObj.markBlockForUpdate(xCoord, yCoord, zCoord);
	}

	@Override
	public void openChest() {

	}

	@Override
	public void closeChest() {

	}

	@Override
	public boolean isInvNameLocalized() {
		return false;
	}

	@Override
	public boolean isItemValidForSlot(int i, ItemStack itemstack) {
		return true;
	}

	@Override
	public Packet getDescriptionPacket() {
		if ((worldObj.getBlockMetadata(xCoord, yCoord, zCoord) & 4) != 0)
			return null;

		NBTTagCompound tag = new NBTTagCompound();
		writeToNBT(tag);
		return new Packet132TileEntityData(xCoord, yCoord, zCoord, 1, tag);
	}

	@Override
	public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
		readFromNBT(pkt.data);
		
		if(worldObj.isRemote && Minecraft.getMinecraft().currentScreen instanceof GuiStatue){
			GuiStatue gui=(GuiStatue) Minecraft.getMinecraft().currentScreen;
			pose.itemLeftA=gui.ila;
			pose.itemRightA=gui.ira;
		}
	}

	@Override
	public ItemStack getStackInSlotOnClosing(int i) {
		return null;
	}
	
	public void updateModel() {
		if(clientPlayer!=null && worldObj!=null && worldObj.isRemote){
			((EntityStatuePlayer)clientPlayer).applySkin(skinName, block, facing, meta);
		}
		
		updated=false;
	}
	
    @Override
	public void updateEntity(){
    	if(updated) return;
    	updated=true;
    	
    }

}