/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.launcher;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class FMLTweaker
implements ITweaker {
    private List<String> args;
    private File assetsDir;
    private String profile;
    private File gameDir;
    private Map<String, String> launchArgs;
    private List<String> standaloneArgs;
    private static URI jarLocation;

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        this.gameDir = gameDir == null ? new File(".") : gameDir;
        this.assetsDir = assetsDir;
        this.profile = profile;
        this.args = args;
        this.launchArgs = (Map)Launch.blackboard.get("launchArgs");
        this.standaloneArgs = Lists.newArrayList();
        if (this.launchArgs == null) {
            this.launchArgs = Maps.newHashMap();
            Launch.blackboard.put("launchArgs", this.launchArgs);
        }
        String classifier = null;
        for (String arg : args) {
            if (arg.startsWith("-")) {
                if (classifier != null) {
                    classifier = this.launchArgs.put(classifier, "");
                    continue;
                }
                if (arg.contains("=")) {
                    classifier = this.launchArgs.put(arg.substring(0, arg.indexOf(61)), arg.substring(arg.indexOf(61) + 1));
                    continue;
                }
                classifier = arg;
                continue;
            }
            if (classifier != null) {
                classifier = this.launchArgs.put(classifier, arg);
                continue;
            }
            this.standaloneArgs.add(arg);
        }
        if (!this.launchArgs.containsKey("--version")) {
            this.launchArgs.put("--version", profile != null ? profile : "UnknownFMLProfile");
        }
        if (!this.launchArgs.containsKey("--gameDir") && gameDir != null) {
            this.launchArgs.put("--gameDir", gameDir.getAbsolutePath());
        }
        if (!this.launchArgs.containsKey("--assetsDir") && assetsDir != null) {
            this.launchArgs.put("--assetsDir", assetsDir.getAbsolutePath());
        }
        try {
            jarLocation = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            Logger.getLogger("FMLTWEAK").log(Level.SEVERE, "Missing URI information for FML tweak");
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        classLoader.addTransformerExclusion("cpw.mods.fml.repackage.");
        classLoader.addTransformerExclusion("cpw.mods.fml.relauncher.");
        classLoader.addTransformerExclusion("cpw.mods.fml.common.asm.transformers.");
        classLoader.addClassLoaderExclusion("LZMA.");
        FMLLaunchHandler.configureForClientLaunch(classLoader, this);
        FMLLaunchHandler.appendCoreMods();
    }

    public String getLaunchTarget() {
        return "net.minecraft.client.main.Main";
    }

    public String[] getLaunchArguments() {
        ArrayList args = Lists.newArrayList();
        args.addAll(this.standaloneArgs);
        for (Map.Entry<String, String> arg : this.launchArgs.entrySet()) {
            args.add(arg.getKey());
            args.add(arg.getValue());
        }
        this.launchArgs.clear();
        return args.toArray(new String[args.size()]);
    }

    public File getGameDir() {
        return this.gameDir;
    }

    public static URI getJarLocation() {
        return jarLocation;
    }

    public void injectCascadingTweak(String tweakClassName) {
        List tweakClasses = (List)Launch.blackboard.get("TweakClasses");
        tweakClasses.add(tweakClassName);
    }
}

