/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.classloading.FMLForgePlugin;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.inventory.InventoryType;

public class EnumHelper {
    private static Object reflectionFactory = null;
    private static Method newConstructorAccessor = null;
    private static Method newInstance = null;
    private static Method newFieldAccessor = null;
    private static Method fieldAccessorSet = null;
    private static boolean isSetup = false;
    private static Class[][] commonTypes = new Class[][]{{zj.class}, {wj.class, Integer.TYPE, int[].class, Integer.TYPE}, {om.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, {oj.class}, {oh.class, Class.class, Integer.TYPE, akc.class, Boolean.TYPE}, {aim.class}, {aav.class}, {nr.class}, {apx.class}, {atb.class}, {ach.class, Integer.TYPE}, {ug.class}, {yd.class, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE}};

    public static Biome addBukkitBiome(String name) {
        return EnumHelper.addEnum(Biome.class, name, new Class[0], new Object[0]);
    }

    public static World.Environment addBukkitEnvironment(int id, String name) {
        if (!isSetup) {
            EnumHelper.setup();
        }
        return EnumHelper.addEnum(World.Environment.class, name, new Class[]{Integer.TYPE}, new Object[]{id});
    }

    public static WorldType addBukkitWorldType(String name) {
        if (!isSetup) {
            EnumHelper.setup();
        }
        WorldType worldType = EnumHelper.addEnum(WorldType.class, name, new Class[]{String.class}, new Object[]{name});
        Map BY_NAME = (Map)ReflectionHelper.getPrivateValue(WorldType.class, null, "BY_NAME");
        BY_NAME.put(name.toUpperCase(), worldType);
        return worldType;
    }

    public static EntityType addBukkitEntityType(String name, Class<? extends Entity> clazz, int typeId, boolean independent) {
        String entityType = name.replace("-", "_").toUpperCase();
        EntityType bukkitType = EnumHelper.addEnum(EntityType.class, entityType, new Class[]{String.class, Class.class, Integer.TYPE, Boolean.TYPE}, new Object[]{name, clazz, typeId, independent});
        Map NAME_MAP = (Map)ReflectionHelper.getPrivateValue(EntityType.class, null, "NAME_MAP");
        Map ID_MAP = (Map)ReflectionHelper.getPrivateValue(EntityType.class, null, "ID_MAP");
        NAME_MAP.put(name.toLowerCase(), bukkitType);
        ID_MAP.put((short)typeId, bukkitType);
        return bukkitType;
    }

    public static InventoryType addInventoryType(asp tileentity) {
        if (!mo.class.isAssignableFrom(tileentity.getClass())) {
            return null;
        }
        String id = (String)asp.b.get(tileentity.getClass());
        try {
            mo teInv = (mo)tileentity;
            int size = teInv.j_();
            return EnumHelper.addEnum(InventoryType.class, id, new Class[]{Integer.TYPE, String.class}, new Object[]{size, id});
        }
        catch (Throwable e) {
            MinecraftServer.F();
            if (MinecraftServer.tileEntityConfig.enableTEInventoryWarning.getValue().booleanValue()) {
                Logger.getLogger(MinecraftServer.class.getName()).log(Level.SEVERE, "Could not create inventory type " + tileentity.getClass().getName() + " Exception: " + e.toString());
                Logger.getLogger(MinecraftServer.class.getName()).log(Level.SEVERE, "Could not determine default inventory size for type " + tileentity.getClass().getName() + " using size of 9");
            }
            return EnumHelper.addEnum(InventoryType.class, id, new Class[]{Integer.TYPE, String.class}, new Object[]{9, id});
        }
    }

    public static zj addAction(String name) {
        return EnumHelper.addEnum(zj.class, name, new Object[0]);
    }

    public static wj addArmorMaterial(String name, int durability, int[] reductionAmounts, int enchantability) {
        return EnumHelper.addEnum(wj.class, name, durability, reductionAmounts, enchantability);
    }

    public static om addArt(String name, String tile, int sizeX, int sizeY, int offsetX, int offsetY) {
        return EnumHelper.addEnum(om.class, name, tile, sizeX, sizeY, offsetX, offsetY);
    }

    public static oj addCreatureAttribute(String name) {
        return EnumHelper.addEnum(oj.class, name, new Object[0]);
    }

    public static oh addCreatureType(String name, Class typeClass, int maxNumber, akc material, boolean peaceful) {
        return EnumHelper.addEnum(oh.class, name, typeClass, maxNumber, material, peaceful);
    }

    public static aim addDoor(String name) {
        return EnumHelper.addEnum(aim.class, name, new Object[0]);
    }

    public static aav addEnchantmentType(String name) {
        return EnumHelper.addEnum(aav.class, name, new Object[0]);
    }

    public static nr addEntitySize(String name) {
        return EnumHelper.addEnum(nr.class, name, new Object[0]);
    }

    public static apx addMobType(String name) {
        return EnumHelper.addEnum(apx.class, name, new Object[0]);
    }

    public static atb addMovingObjectType(String name) {
        if (!isSetup) {
            EnumHelper.setup();
        }
        return EnumHelper.addEnum(atb.class, name, new Object[0]);
    }

    public static ach addSkyBlock(String name, int lightValue) {
        return EnumHelper.addEnum(ach.class, name, lightValue);
    }

    public static ug addStatus(String name) {
        return EnumHelper.addEnum(ug.class, name, new Object[0]);
    }

    public static yd addToolMaterial(String name, int harvestLevel, int maxUses, float efficiency, float damage, int enchantability) {
        return EnumHelper.addEnum(yd.class, name, harvestLevel, maxUses, Float.valueOf(efficiency), Float.valueOf(damage), enchantability);
    }

    private static void setup() {
        if (isSetup) {
            return;
        }
        try {
            Method getReflectionFactory = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("getReflectionFactory", new Class[0]);
            reflectionFactory = getReflectionFactory.invoke(null, new Object[0]);
            newConstructorAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newConstructorAccessor", Constructor.class);
            newInstance = Class.forName("sun.reflect.ConstructorAccessor").getDeclaredMethod("newInstance", Object[].class);
            newFieldAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newFieldAccessor", Field.class, Boolean.TYPE);
            fieldAccessorSet = Class.forName("sun.reflect.FieldAccessor").getDeclaredMethod("set", Object.class, Object.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        isSetup = true;
    }

    private static Object getConstructorAccessor(Class<?> enumClass, Class<?>[] additionalParameterTypes) throws Exception {
        Class[] parameterTypes = new Class[additionalParameterTypes.length + 2];
        parameterTypes[0] = String.class;
        parameterTypes[1] = Integer.TYPE;
        System.arraycopy(additionalParameterTypes, 0, parameterTypes, 2, additionalParameterTypes.length);
        return newConstructorAccessor.invoke(reflectionFactory, enumClass.getDeclaredConstructor(parameterTypes));
    }

    private static <T extends Enum<?>> T makeEnum(Class<T> enumClass, String value, int ordinal, Class<?>[] additionalTypes, Object[] additionalValues) throws Exception {
        Object[] parms = new Object[additionalValues.length + 2];
        parms[0] = value;
        parms[1] = ordinal;
        System.arraycopy(additionalValues, 0, parms, 2, additionalValues.length);
        return (T)((Enum)enumClass.cast(newInstance.invoke(EnumHelper.getConstructorAccessor(enumClass, additionalTypes), new Object[]{parms})));
    }

    public static void setFailsafeFieldValue(Field field, Object target, Object value) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        Object fieldAccessor = newFieldAccessor.invoke(reflectionFactory, field, false);
        fieldAccessorSet.invoke(fieldAccessor, target, value);
    }

    private static void blankField(Class<?> enumClass, String fieldName) throws Exception {
        for (Field field : Class.class.getDeclaredFields()) {
            if (!field.getName().contains(fieldName)) continue;
            field.setAccessible(true);
            EnumHelper.setFailsafeFieldValue(field, enumClass, null);
            break;
        }
    }

    private static void cleanEnumCache(Class<?> enumClass) throws Exception {
        EnumHelper.blankField(enumClass, "enumConstantDirectory");
        EnumHelper.blankField(enumClass, "enumConstants");
    }

    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, Object ... paramValues) {
        return EnumHelper.addEnum(commonTypes, enumType, enumName, paramValues);
    }

    public static <T extends Enum<?>> T addEnum(Class[][] map, Class<T> enumType, String enumName, Object ... paramValues) {
        for (Class[] lookup : map) {
            if (lookup[0] != enumType) continue;
            Class[] paramTypes = new Class[lookup.length - 1];
            if (paramTypes.length > 0) {
                System.arraycopy(lookup, 1, paramTypes, 0, paramTypes.length);
            }
            return EnumHelper.addEnum(enumType, enumName, paramTypes, paramValues);
        }
        return null;
    }

    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, Class<?>[] paramTypes, Object[] paramValues) {
        Field[] fields;
        if (!isSetup) {
            EnumHelper.setup();
        }
        Field valuesField = null;
        for (Field field : fields = enumType.getDeclaredFields()) {
            String name = field.getName();
            if (!name.equals("$VALUES") && !name.equals("ENUM$VALUES")) continue;
            valuesField = field;
            break;
        }
        int flags = (FMLForgePlugin.RUNTIME_DEOBF ? 1 : 2) | 8 | 0x10 | 0x1000;
        if (valuesField == null) {
            String valueType = String.format("[L%s;", enumType.getName().replace('.', '/'));
            for (Field field : fields) {
                if ((field.getModifiers() & flags) != flags || !field.getType().getName().replace('.', '/').equals(valueType)) continue;
                valuesField = field;
                break;
            }
        }
        if (valuesField == null) {
            FMLLog.severe("Could not find $VALUES field for enum: %s", enumType.getName());
            FMLLog.severe("Runtime Deobf: %s", FMLForgePlugin.RUNTIME_DEOBF);
            FMLLog.severe("Flags: %s", String.format("%16s", Integer.toBinaryString(flags)).replace(' ', '0'));
            FMLLog.severe("Fields:", new Object[0]);
            for (Field field : fields) {
                String mods = String.format("%16s", Integer.toBinaryString(field.getModifiers())).replace(' ', '0');
                FMLLog.severe("       %s %s: %s", mods, field.getName(), field.getType().getName());
            }
            return null;
        }
        valuesField.setAccessible(true);
        try {
            Enum[] previousValues = (Enum[])valuesField.get(enumType);
            ArrayList<Enum> values = new ArrayList<Enum>(Arrays.asList(previousValues));
            T newValue = EnumHelper.makeEnum(enumType, enumName, values.size(), paramTypes, paramValues);
            values.add((Enum)newValue);
            EnumHelper.setFailsafeFieldValue(valuesField, null, values.toArray((Enum[])Array.newInstance(enumType, 0)));
            EnumHelper.cleanEnumCache(enumType);
            return newValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T extends Enum<?>> T replaceEnum(Class<T> enumType, String enumName, int ordinal, Class<?>[] paramTypes, Object[] paramValues) {
        Field[] fields;
        if (!isSetup) {
            EnumHelper.setup();
        }
        Field valuesField = null;
        for (Field field : fields = enumType.getDeclaredFields()) {
            String name = field.getName();
            if (!name.equals("$VALUES") && !name.equals("ENUM$VALUES")) continue;
            valuesField = field;
            break;
        }
        int flags = (FMLForgePlugin.RUNTIME_DEOBF ? 1 : 2) | 8 | 0x10 | 0x1000;
        if (valuesField == null) {
            String valueType = String.format("[L%s;", enumType.getName().replace('.', '/'));
            for (Field field : fields) {
                if ((field.getModifiers() & flags) != flags || !field.getType().getName().replace('.', '/').equals(valueType)) continue;
                valuesField = field;
                break;
            }
        }
        if (valuesField == null) {
            FMLLog.severe("Could not find $VALUES field for enum: %s", enumType.getName());
            FMLLog.severe("Runtime Deobf: %s", FMLForgePlugin.RUNTIME_DEOBF);
            FMLLog.severe("Flags: %s", String.format("%16s", Integer.toBinaryString(flags)).replace(' ', '0'));
            FMLLog.severe("Fields:", new Object[0]);
            for (Field field : fields) {
                String mods = String.format("%16s", Integer.toBinaryString(field.getModifiers())).replace(' ', '0');
                FMLLog.severe("       %s %s: %s", mods, field.getName(), field.getType().getName());
            }
            return null;
        }
        valuesField.setAccessible(true);
        try {
            Enum[] previousValues = (Enum[])valuesField.get(enumType);
            Enum[] newValues = new Enum[previousValues.length];
            T newValue = null;
            for (Enum enumValue : previousValues) {
                if (enumValue.ordinal() == ordinal) {
                    newValue = EnumHelper.makeEnum(enumType, enumName, ordinal, paramTypes, paramValues);
                    newValues[enumValue.ordinal()] = newValue;
                    continue;
                }
                newValues[enumValue.ordinal()] = enumValue;
            }
            ArrayList<Enum> values = new ArrayList<Enum>(Arrays.asList(newValues));
            EnumHelper.setFailsafeFieldValue(valuesField, null, values.toArray((Enum[])Array.newInstance(enumType, 0)));
            EnumHelper.cleanEnumCache(enumType);
            return newValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static {
        if (!isSetup) {
            EnumHelper.setup();
        }
    }
}

