/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.player;

import net.minecraftforge.cauldron.CauldronUtils;
import net.minecraftforge.event.Cancelable;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.bukkit.craftbukkit.v1_6_R3.event.CraftEventFactory;

@Cancelable
public class PlayerInteractEvent
extends PlayerEvent {
    public final Action action;
    public final int x;
    public final int y;
    public final int z;
    public final int face;
    public Event.Result useBlock = Event.Result.DEFAULT;
    public Event.Result useItem = Event.Result.DEFAULT;

    public PlayerInteractEvent(uf player, Action action, int x2, int y, int z2, int face) {
        super(player);
        this.action = action;
        this.x = x2;
        this.y = y;
        this.z = z2;
        this.face = face;
        if (face == -1) {
            this.useBlock = Event.Result.DENY;
        }
        org.bukkit.event.player.PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent((uf)player, (org.bukkit.event.block.Action)CauldronUtils.convertForgeToBukkitAction(action), (int)x2, (int)y, (int)z2, (int)face, (ye)player.by());
        this.useBlock = CauldronUtils.convertBukkitToForgeResult(event.useInteractedBlock());
        this.useItem = CauldronUtils.convertBukkitToForgeResult(event.useItemInHand());
        if (event.isCancelled()) {
            this.setCanceled(true);
        }
    }

    @Override
    public void setCanceled(boolean cancel) {
        super.setCanceled(cancel);
        Event.Result result = cancel ? Event.Result.DENY : (this.useBlock = this.useBlock == Event.Result.DENY ? Event.Result.DEFAULT : this.useBlock);
        this.useItem = cancel ? Event.Result.DENY : (this.useItem == Event.Result.DENY ? Event.Result.DEFAULT : this.useItem);
    }

    public static enum Action {
        RIGHT_CLICK_AIR,
        RIGHT_CLICK_BLOCK,
        LEFT_CLICK_BLOCK;

    }
}

