/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_6_R3;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_6_R3.CraftChunkSnapshot;
import org.bukkit.craftbukkit.v1_6_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_6_R3.block.CraftBlock;
import org.bukkit.entity.Entity;

public class CraftChunk
implements Chunk {
    private WeakReference<adr> weakChunk;
    private final js worldServer;
    private final int x;
    private final int z;
    private static final byte[] emptyData = new byte[2048];
    private static final short[] emptyBlockIDs = new short[4096];
    private static final byte[] emptySkyLight = new byte[2048];

    public CraftChunk(adr chunk) {
        if (!(chunk instanceof adq)) {
            this.weakChunk = new WeakReference<adr>(chunk);
        }
        this.worldServer = (js)this.getHandle().e;
        this.x = this.getHandle().g;
        this.z = this.getHandle().h;
    }

    @Override
    public World getWorld() {
        return this.worldServer.getWorld();
    }

    public CraftWorld getCraftWorld() {
        return (CraftWorld)this.getWorld();
    }

    public adr getHandle() {
        adr c = (adr)this.weakChunk.get();
        if (c == null && !((c = this.worldServer.e(this.x, this.z)) instanceof adq)) {
            this.weakChunk = new WeakReference<adr>(c);
        }
        return c;
    }

    void breakLink() {
        this.weakChunk.clear();
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    public String toString() {
        return "CraftChunk{x=" + this.getX() + "z=" + this.getZ() + '}';
    }

    @Override
    public Block getBlock(int x, int y, int z) {
        return new CraftBlock(this, this.getX() << 4 | x & 0xF, y & 0xFF, this.getZ() << 4 | z & 0xF);
    }

    @Override
    public Entity[] getEntities() {
        int count = 0;
        int index = 0;
        adr chunk = this.getHandle();
        for (int i = 0; i < 16; ++i) {
            count += chunk.j[i].size();
        }
        Entity[] entities = new Entity[count];
        for (int i = 0; i < 16; ++i) {
            for (Object obj : chunk.j[i].toArray()) {
                if (!(obj instanceof nn)) continue;
                entities[index++] = ((nn)obj).getBukkitEntity();
            }
        }
        return entities;
    }

    @Override
    public BlockState[] getTileEntities() {
        int index = 0;
        adr chunk = this.getHandle();
        BlockState[] entities = new BlockState[chunk.i.size()];
        for (Object obj : chunk.i.keySet().toArray()) {
            if (!(obj instanceof aco)) continue;
            aco position = (aco)obj;
            entities[index++] = this.worldServer.getWorld().getBlockAt(position.a + (chunk.g << 4), position.b, position.c + (chunk.h << 4)).getState();
        }
        return entities;
    }

    @Override
    public boolean isLoaded() {
        return this.getWorld().isChunkLoaded(this);
    }

    @Override
    public boolean load() {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), true);
    }

    @Override
    public boolean load(boolean generate) {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), generate);
    }

    @Override
    public boolean unload() {
        return this.getWorld().unloadChunk(this.getX(), this.getZ());
    }

    @Override
    public boolean unload(boolean save) {
        return this.getWorld().unloadChunk(this.getX(), this.getZ(), save);
    }

    @Override
    public boolean unload(boolean save, boolean safe) {
        return this.getWorld().unloadChunk(this.getX(), this.getZ(), save, safe);
    }

    @Override
    public ChunkSnapshot getChunkSnapshot() {
        return this.getChunkSnapshot(true, false, false);
    }

    @Override
    public ChunkSnapshot getChunkSnapshot(boolean includeMaxBlockY, boolean includeBiome, boolean includeBiomeTempRain) {
        adr chunk = this.getHandle();
        ads[] cs = chunk.i();
        short[][] sectionBlockIDs = new short[cs.length][];
        byte[][] sectionBlockData = new byte[cs.length][];
        byte[][] sectionSkyLights = new byte[cs.length][];
        byte[][] sectionEmitLights = new byte[cs.length][];
        boolean[] sectionEmpty = new boolean[cs.length];
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] == null) {
                sectionBlockIDs[i] = emptyBlockIDs;
                sectionBlockData[i] = emptyData;
                sectionSkyLights[i] = emptySkyLight;
                sectionEmitLights[i] = emptyData;
                sectionEmpty[i] = true;
                continue;
            }
            short[] blockids = new short[4096];
            byte[] baseids = cs[i].g();
            for (int j = 0; j < 4096; ++j) {
                blockids[j] = (short)(baseids[j] & 0xFF);
            }
            if (cs[i].i() != null) {
                int j;
                if (cs[i].i().isTrivialArray()) {
                    int tval = cs[i].i().getTrivialArrayValue();
                    if (tval != 0) {
                        tval <<= 8;
                        j = 0;
                        while (j < 4096) {
                            int n = j++;
                            blockids[n] = (short)(blockids[n] | tval);
                        }
                    }
                } else {
                    byte[] extids = cs[i].i().getValueArray();
                    for (j = 0; j < 2048; ++j) {
                        short b = (short)(extids[j] & 0xFF);
                        if (b == 0) continue;
                        int n = j << 1;
                        blockids[n] = (short)(blockids[n] | (b & 0xF) << 8);
                        int n2 = (j << 1) + 1;
                        blockids[n2] = (short)(blockids[n2] | (b & 0xF0) << 4);
                    }
                }
            }
            sectionBlockIDs[i] = blockids;
            if (cs[i].j().isTrivialArray() && cs[i].j().getTrivialArrayValue() == 0) {
                sectionBlockData[i] = emptyData;
            } else {
                sectionBlockData[i] = new byte[2048];
                cs[i].j().copyToByteArray(sectionBlockData[i], 0);
            }
            if (cs[i].l() == null) {
                sectionSkyLights[i] = emptyData;
            } else if (cs[i].l().isTrivialArray()) {
                if (cs[i].l().getTrivialArrayValue() == 0) {
                    sectionSkyLights[i] = emptyData;
                } else if (cs[i].l().getTrivialArrayValue() == 15) {
                    sectionSkyLights[i] = emptySkyLight;
                } else {
                    sectionSkyLights[i] = new byte[2048];
                    cs[i].l().copyToByteArray(sectionSkyLights[i], 0);
                }
            } else {
                sectionSkyLights[i] = new byte[2048];
                cs[i].l().copyToByteArray(sectionSkyLights[i], 0);
            }
            if (cs[i].k().isTrivialArray() && cs[i].k().getTrivialArrayValue() == 0) {
                sectionEmitLights[i] = emptyData;
                continue;
            }
            sectionEmitLights[i] = new byte[2048];
            cs[i].k().copyToByteArray(sectionEmitLights[i], 0);
        }
        int[] hmap = null;
        if (includeMaxBlockY) {
            hmap = new int[256];
            System.arraycopy(chunk.f, 0, hmap, 0, 256);
        }
        acq[] biome = null;
        double[] biomeTemp = null;
        double[] biomeRain = null;
        if (includeBiome || includeBiomeTempRain) {
            acv wcm = chunk.e.u();
            if (includeBiome) {
                biome = new acq[256];
                for (int i = 0; i < 256; ++i) {
                    biome[i] = chunk.a(i & 0xF, i >> 4, wcm);
                }
            }
            if (includeBiomeTempRain) {
                int i;
                biomeTemp = new double[256];
                biomeRain = new double[256];
                float[] dat = wcm.b(null, this.getX() << 4, this.getZ() << 4, 16, 16);
                for (i = 0; i < 256; ++i) {
                    biomeTemp[i] = dat[i];
                }
                dat = wcm.a(null, this.getX() << 4, this.getZ() << 4, 16, 16);
                for (i = 0; i < 256; ++i) {
                    biomeRain[i] = dat[i];
                }
            }
        }
        World world = this.getWorld();
        return new CraftChunkSnapshot(this.getX(), this.getZ(), world.getName(), world.getFullTime(), sectionBlockIDs, sectionBlockData, sectionSkyLights, sectionEmitLights, sectionEmpty, hmap, biome, biomeTemp, biomeRain);
    }

    public static ChunkSnapshot getEmptyChunkSnapshot(int x, int z, CraftWorld world, boolean includeBiome, boolean includeBiomeTempRain) {
        acq[] biome = null;
        double[] biomeTemp = null;
        double[] biomeRain = null;
        if (includeBiome || includeBiomeTempRain) {
            acv wcm = world.getHandle().u();
            if (includeBiome) {
                biome = new acq[256];
                for (int i = 0; i < 256; ++i) {
                    biome[i] = world.getHandle().a((x << 4) + (i & 0xF), (z << 4) + (i >> 4));
                }
            }
            if (includeBiomeTempRain) {
                int i;
                biomeTemp = new double[256];
                biomeRain = new double[256];
                float[] dat = wcm.b(null, x << 4, z << 4, 16, 16);
                for (i = 0; i < 256; ++i) {
                    biomeTemp[i] = dat[i];
                }
                dat = wcm.a(null, x << 4, z << 4, 16, 16);
                for (i = 0; i < 256; ++i) {
                    biomeRain[i] = dat[i];
                }
            }
        }
        int hSection = world.getMaxHeight() >> 4;
        short[][] blockIDs = new short[hSection][];
        byte[][] skyLight = new byte[hSection][];
        byte[][] emitLight = new byte[hSection][];
        byte[][] blockData = new byte[hSection][];
        boolean[] empty = new boolean[hSection];
        for (int i = 0; i < hSection; ++i) {
            blockIDs[i] = emptyBlockIDs;
            skyLight[i] = emptySkyLight;
            emitLight[i] = emptyData;
            blockData[i] = emptyData;
            empty[i] = true;
        }
        return new CraftChunkSnapshot(x, z, world.getName(), world.getFullTime(), blockIDs, blockData, skyLight, emitLight, empty, new int[256], biome, biomeTemp, biomeRain);
    }

    static {
        Arrays.fill(emptySkyLight, (byte)-1);
    }
}

