/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_6_R3.block;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.craftbukkit.v1_6_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_6_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftInventoryDoubleChest;
import org.bukkit.inventory.Inventory;

public class CraftChest
extends CraftBlockState
implements Chest {
    private final CraftWorld world;
    private final ary chest;

    public CraftChest(Block block) {
        super(block);
        this.world = (CraftWorld)block.getWorld();
        this.chest = (ary)this.world.getTileEntityAt(this.getX(), this.getY(), this.getZ());
    }

    @Override
    public Inventory getBlockInventory() {
        return new CraftInventory((mo)this.chest);
    }

    @Override
    public Inventory getInventory() {
        CraftInventory right;
        CraftInventory left;
        int id;
        int x = this.getX();
        int y = this.getY();
        int z = this.getZ();
        CraftInventory inventory = new CraftInventory((mo)this.chest);
        if (this.world.getBlockTypeIdAt(x, y, z) == Material.CHEST.getId()) {
            id = Material.CHEST.getId();
        } else if (this.world.getBlockTypeIdAt(x, y, z) == Material.TRAPPED_CHEST.getId()) {
            id = Material.TRAPPED_CHEST.getId();
        } else {
            throw new IllegalStateException("CraftChest is not a chest but is instead " + this.world.getBlockAt(x, y, z));
        }
        if (this.world.getBlockTypeIdAt(x - 1, y, z) == id) {
            left = new CraftInventory((mo)((ary)this.world.getHandle().r(x - 1, y, z)));
            inventory = new CraftInventoryDoubleChest(left, inventory);
        }
        if (this.world.getBlockTypeIdAt(x + 1, y, z) == id) {
            right = new CraftInventory((mo)((ary)this.world.getHandle().r(x + 1, y, z)));
            inventory = new CraftInventoryDoubleChest(inventory, right);
        }
        if (this.world.getBlockTypeIdAt(x, y, z - 1) == id) {
            left = new CraftInventory((mo)((ary)this.world.getHandle().r(x, y, z - 1)));
            inventory = new CraftInventoryDoubleChest(left, inventory);
        }
        if (this.world.getBlockTypeIdAt(x, y, z + 1) == id) {
            right = new CraftInventory((mo)((ary)this.world.getHandle().r(x, y, z + 1)));
            inventory = new CraftInventoryDoubleChest(inventory, right);
        }
        return inventory;
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        if (result) {
            this.chest.e();
        }
        return result;
    }
}

