/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_6_R3.chunkio;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.world.ChunkDataEvent;
import org.bukkit.craftbukkit.v1_6_R3.CraftServer;
import org.bukkit.craftbukkit.v1_6_R3.chunkio.QueuedChunk;
import org.bukkit.craftbukkit.v1_6_R3.util.AsynchronousExecutor;
import org.bukkit.craftbukkit.v1_6_R3.util.LongHash;
import org.bukkit.event.world.ChunkLoadEvent;

class ChunkIOProvider
implements AsynchronousExecutor.CallBackProvider<QueuedChunk, adr, Runnable, RuntimeException> {
    private final AtomicInteger threadNumber = new AtomicInteger(1);

    ChunkIOProvider() {
    }

    @Override
    public adr callStage1(QueuedChunk queuedChunk) throws RuntimeException {
        aee loader = queuedChunk.loader;
        Object[] data = loader.loadChunk__Async_CB(queuedChunk.world, queuedChunk.x, queuedChunk.z);
        if (data != null) {
            queuedChunk.compound = (by)data[1];
            return (adr)data[0];
        }
        return null;
    }

    @Override
    public void callStage2(QueuedChunk queuedChunk, adr chunk) throws RuntimeException {
        CraftServer server;
        if (chunk == null) {
            queuedChunk.provider.originalGetChunkAt(queuedChunk.x, queuedChunk.z);
            return;
        }
        queuedChunk.loader.loadEntities(chunk, queuedChunk.compound.l("Level"), queuedChunk.world);
        MinecraftForge.EVENT_BUS.post((Event)new ChunkDataEvent.Load(chunk, queuedChunk.compound));
        chunk.n = queuedChunk.provider.h.I();
        queuedChunk.provider.f.put(LongHash.toLong(queuedChunk.x, queuedChunk.z), chunk);
        queuedChunk.provider.g.add(chunk);
        chunk.c();
        if (queuedChunk.provider.d != null) {
            queuedChunk.provider.h.timings.syncChunkLoadStructuresTimer.startTiming();
            queuedChunk.provider.d.e(queuedChunk.x, queuedChunk.z);
            queuedChunk.provider.h.timings.syncChunkLoadStructuresTimer.stopTiming();
        }
        if ((server = queuedChunk.provider.h.getServer()) != null) {
            server.getPluginManager().callEvent(new ChunkLoadEvent(chunk.bukkitChunk, false));
        }
        chunk.a((ado)queuedChunk.provider, (ado)queuedChunk.provider, queuedChunk.x, queuedChunk.z);
    }

    @Override
    public void callStage3(QueuedChunk queuedChunk, adr chunk, Runnable runnable) throws RuntimeException {
        runnable.run();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable, "Chunk I/O Executor Thread-" + this.threadNumber.getAndIncrement());
        thread.setDaemon(true);
        return thread;
    }
}

