/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_6_R3.entity;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.Validate;
import org.bukkit.Achievement;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ManuallyAbandonedConversationCanceller;
import org.bukkit.craftbukkit.v1_6_R3.CraftEffect;
import org.bukkit.craftbukkit.v1_6_R3.CraftOfflinePlayer;
import org.bukkit.craftbukkit.v1_6_R3.CraftServer;
import org.bukkit.craftbukkit.v1_6_R3.CraftSound;
import org.bukkit.craftbukkit.v1_6_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_6_R3.conversations.ConversationTracker;
import org.bukkit.craftbukkit.v1_6_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_6_R3.map.CraftMapView;
import org.bukkit.craftbukkit.v1_6_R3.map.RenderData;
import org.bukkit.craftbukkit.v1_6_R3.scoreboard.CraftScoreboard;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnregisterChannelEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.map.MapView;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.scoreboard.Scoreboard;

@DelegateDeserialization(value=CraftOfflinePlayer.class)
public class CraftPlayer
extends CraftHumanEntity
implements Player {
    private long firstPlayed = 0L;
    private long lastPlayed = 0L;
    private boolean hasPlayedBefore = false;
    private final ConversationTracker conversationTracker = new ConversationTracker();
    private final Set<String> channels = new HashSet<String>();
    private final Map<String, Player> hiddenPlayers = new MapMaker().softValues().makeMap();
    private int hash = 0;
    private double health = 20.0;
    private boolean scaledHealth = false;
    private double healthScale = 20.0;
    private final Player.Spigot spigot = new Player.Spigot(){

        @Override
        public void playEffect(Location location, Effect effect, int id, int data, float offsetX, float offsetY, float offsetZ, float speed, int particleCount, int radius) {
            em packet;
            Validate.notNull((Object)location, (String)"Location cannot be null");
            Validate.notNull((Object)((Object)effect), (String)"Effect cannot be null");
            Validate.notNull((Object)location.getWorld(), (String)"World cannot be null");
            if (effect.getType() != Effect.Type.PARTICLE) {
                int packetData = effect.getId();
                packet = new em(packetData, location.getBlockX(), location.getBlockY(), location.getBlockZ(), id, false);
            } else {
                StringBuilder particleFullName = new StringBuilder();
                particleFullName.append(effect.getName());
                if (effect.getData() != null && (effect.getData().equals(Material.class) || effect.getData().equals(MaterialData.class))) {
                    particleFullName.append('_').append(id);
                }
                if (effect.getData() != null && effect.getData().equals(MaterialData.class)) {
                    particleFullName.append('_').append(data);
                }
                packet = new en(effect.getName(), (float)location.getX(), (float)location.getY(), (float)location.getZ(), offsetX, offsetY, offsetZ, (float)particleCount, radius);
            }
            if (!location.getWorld().equals(CraftPlayer.this.getWorld())) {
                return;
            }
            CraftPlayer.this.getHandle().a.b((ey)packet);
        }

        @Override
        public boolean getCollidesWithEntities() {
            return CraftPlayer.this.getHandle().collidesWithEntities;
        }

        @Override
        public void setCollidesWithEntities(boolean collides) {
            CraftPlayer.this.getHandle().collidesWithEntities = collides;
            CraftPlayer.this.getHandle().m = collides;
        }
    };

    public CraftPlayer(CraftServer server, jv entity) {
        super(server, (uf)entity);
        this.firstPlayed = System.currentTimeMillis();
    }

    @Override
    public boolean isOp() {
        return this.server.getHandle().e(this.getName());
    }

    @Override
    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.getHandle().b(this.getName());
        } else {
            this.server.getHandle().c(this.getName());
        }
        this.perm.recalculatePermissions();
    }

    @Override
    public boolean isOnline() {
        for (Object obj : this.server.getHandle().a) {
            jv player = (jv)obj;
            if (!player.c_().equalsIgnoreCase(this.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public InetSocketAddress getAddress() {
        if (this.getHandle().a == null) {
            return null;
        }
        SocketAddress addr = this.getHandle().a.a.c();
        if (addr instanceof InetSocketAddress) {
            return (InetSocketAddress)addr;
        }
        return null;
    }

    @Override
    public double getEyeHeight() {
        return this.getEyeHeight(false);
    }

    @Override
    public double getEyeHeight(boolean ignoreSneaking) {
        if (ignoreSneaking) {
            return 1.62;
        }
        if (this.isSneaking()) {
            return 1.54;
        }
        return 1.62;
    }

    @Override
    public void sendRawMessage(String message) {
        if (this.getHandle().a == null) {
            return;
        }
        this.getHandle().a.b((ey)new dm(cv.d((String)message)));
    }

    @Override
    public void sendMessage(String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(message);
        }
    }

    @Override
    public void sendMessage(String[] messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public String getDisplayName() {
        return this.getHandle().cb_displayName;
    }

    @Override
    public void setDisplayName(String name) {
        this.getHandle().cb_displayName = name;
    }

    @Override
    public String getPlayerListName() {
        return this.getHandle().listName;
    }

    @Override
    public void setPlayerListName(String name) {
        String oldName = this.getHandle().listName;
        if (name == null) {
            name = this.getName();
        }
        if (oldName.equals(name)) {
            return;
        }
        if (name.length() > 16) {
            throw new IllegalArgumentException("Player list names can only be a maximum of 16 characters long");
        }
        for (int i = 0; i < this.server.getHandle().a.size(); ++i) {
            if (!((jv)this.server.getHandle().a.get((int)i)).listName.equals(name)) continue;
            throw new IllegalArgumentException(name + " is already assigned as a player list name for someone");
        }
        this.getHandle().listName = name;
        fd oldpacket = new fd(oldName, false, 9999);
        fd packet = new fd(name, true, this.getHandle().i);
        for (int i = 0; i < this.server.getHandle().a.size(); ++i) {
            jv entityplayer = (jv)this.server.getHandle().a.get(i);
            if (entityplayer.a == null || !entityplayer.getBukkitEntity().canSee(this)) continue;
            entityplayer.a.b((ey)oldpacket);
            entityplayer.a.b((ey)packet);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OfflinePlayer)) {
            return false;
        }
        OfflinePlayer other = (OfflinePlayer)obj;
        if (this.getName() == null || other.getName() == null) {
            return false;
        }
        boolean nameEquals = this.getName().equalsIgnoreCase(other.getName());
        boolean idEquals = true;
        if (other instanceof CraftPlayer) {
            idEquals = this.getEntityId() == ((CraftPlayer)other).getEntityId();
        }
        return nameEquals && idEquals;
    }

    @Override
    public void kickPlayer(String message) {
        if (Thread.currentThread() != MinecraftServer.F().primaryThread) {
            throw new IllegalStateException("Asynchronous player kick!");
        }
        if (this.getHandle().a == null) {
            return;
        }
        this.getHandle().a.c(message == null ? "" : message);
    }

    @Override
    public void setCompassTarget(Location loc) {
        if (this.getHandle().a == null) {
            return;
        }
        this.getHandle().a.b((ey)new fw(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
    }

    @Override
    public Location getCompassTarget() {
        return this.getHandle().compassTarget;
    }

    @Override
    public void chat(String msg) {
        if (this.getHandle().a == null) {
            return;
        }
        this.getHandle().a.chat(msg, false);
    }

    @Override
    public boolean performCommand(String command) {
        return this.server.dispatchCommand(this, command);
    }

    @Override
    public void playNote(Location loc, byte instrument, byte note) {
        if (this.getHandle().a == null) {
            return;
        }
        int id = this.getHandle().q.a(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        this.getHandle().a.b((ey)new gf(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), id, (int)instrument, (int)note));
    }

    @Override
    public void playNote(Location loc, Instrument instrument, Note note) {
        if (this.getHandle().a == null) {
            return;
        }
        int id = this.getHandle().q.a(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        this.getHandle().a.b((ey)new gf(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), id, (int)instrument.getType(), (int)note.getId()));
    }

    @Override
    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        if (sound == null) {
            return;
        }
        this.playSound(loc, CraftSound.getSound(sound), volume, pitch);
    }

    @Override
    public void playSound(Location loc, String sound, float volume, float pitch) {
        if (loc == null || sound == null || this.getHandle().a == null) {
            return;
        }
        double x = (double)loc.getBlockX() + 0.5;
        double y = (double)loc.getBlockY() + 0.5;
        double z = (double)loc.getBlockZ() + 0.5;
        eo packet = new eo(sound, x, y, z, volume, pitch);
        this.getHandle().a.b((ey)packet);
    }

    @Override
    public void playEffect(Location location, Effect effect, int data) {
        this.spigot().playEffect(location, effect, data, 0, 0.0f, 0.0f, 0.0f, 1.0f, 1, 64);
    }

    @Override
    public <T> void playEffect(Location loc, Effect effect, T data) {
        if (data != null) {
            Validate.isTrue((boolean)data.getClass().equals(effect.getData()), (String)"Wrong kind of data for this effect!");
        } else {
            Validate.isTrue((effect.getData() == null ? 1 : 0) != 0, (String)"Wrong kind of data for this effect!");
        }
        if (data != null && data.getClass().equals(MaterialData.class)) {
            MaterialData materialData = (MaterialData)data;
            Validate.isTrue((!materialData.getItemType().isBlock() ? 1 : 0) != 0, (String)"Material must be block");
            this.spigot().playEffect(loc, effect, materialData.getItemType().getId(), materialData.getData(), 0.0f, 0.0f, 0.0f, 1.0f, 1, 64);
        } else {
            int datavalue = data == null ? 0 : CraftEffect.getDataValue(effect, data);
            this.playEffect(loc, effect, datavalue);
        }
    }

    @Override
    public void sendBlockChange(Location loc, Material material, byte data) {
        this.sendBlockChange(loc, material.getId(), data);
    }

    @Override
    public void sendBlockChange(Location loc, int material, byte data) {
        if (this.getHandle().a == null) {
            return;
        }
        gg packet = new gg(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), (abw)((CraftWorld)loc.getWorld()).getHandle());
        packet.d = material;
        packet.e = data;
        this.getHandle().a.b((ey)packet);
    }

    @Override
    public boolean sendChunkChange(Location loc, int sx2, int sy2, int sz2, byte[] data) {
        if (this.getHandle().a == null) {
            return false;
        }
        throw new NotImplementedException("Chunk changes do not yet work");
    }

    @Override
    public void sendMap(MapView map) {
        if (this.getHandle().a == null) {
            return;
        }
        RenderData data = ((CraftMapView)map).render(this);
        for (int x = 0; x < 128; ++x) {
            byte[] bytes = new byte[131];
            bytes[1] = (byte)x;
            for (int y = 0; y < 128; ++y) {
                bytes[y + 3] = data.buffer[y * 128 + x];
            }
            dr packet = new dr((short)Material.MAP.getId(), map.getId(), bytes);
            this.getHandle().a.b((ey)packet);
        }
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        jv entity = this.getHandle();
        if (this.getHealth() == 0.0 || entity.M) {
            return false;
        }
        if (entity.a == null || entity.a.b) {
            return false;
        }
        if (entity.o != null || entity.n != null) {
            return false;
        }
        Location from = this.getLocation();
        Location to = location;
        PlayerTeleportEvent event = new PlayerTeleportEvent(this, from, to, cause);
        this.server.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        from = event.getFrom();
        to = event.getTo();
        js fromWorld = ((CraftWorld)from.getWorld()).getHandle();
        js toWorld = ((CraftWorld)to.getWorld()).getHandle();
        if (this.getHandle().bp != this.getHandle().bo) {
            this.getHandle().i();
        }
        if (fromWorld == toWorld) {
            entity.a.teleport(to);
        } else {
            this.server.getHandle().respawnPlayer(entity, toWorld.t.i, false, to);
        }
        return true;
    }

    @Override
    public void setSneaking(boolean sneak) {
        this.getHandle().b(sneak);
    }

    @Override
    public boolean isSneaking() {
        return this.getHandle().ah();
    }

    @Override
    public boolean isSprinting() {
        return this.getHandle().ai();
    }

    @Override
    public void setSprinting(boolean sprinting) {
        this.getHandle().c(sprinting);
    }

    @Override
    public void loadData() {
        this.server.getHandle().j.b((uf)this.getHandle());
    }

    @Override
    public void saveData() {
        this.server.getHandle().j.a((uf)this.getHandle());
    }

    @Override
    @Deprecated
    public void updateInventory() {
        this.getHandle().a(this.getHandle().bp);
    }

    @Override
    public void setSleepingIgnored(boolean isSleeping) {
        this.getHandle().fauxSleeping = isSleeping;
        ((CraftWorld)this.getWorld()).getHandle().checkSleepStatus();
    }

    @Override
    public boolean isSleepingIgnored() {
        return this.getHandle().fauxSleeping;
    }

    @Override
    public void awardAchievement(Achievement achievement) {
        this.sendStatistic(achievement.getId(), 1);
    }

    @Override
    public void incrementStatistic(Statistic statistic) {
        this.incrementStatistic(statistic, 1);
    }

    @Override
    public void incrementStatistic(Statistic statistic, int amount) {
        this.sendStatistic(statistic.getId(), amount);
    }

    @Override
    public void incrementStatistic(Statistic statistic, Material material) {
        this.incrementStatistic(statistic, material, 1);
    }

    @Override
    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        if (!statistic.isSubstatistic()) {
            throw new IllegalArgumentException("Given statistic is not a substatistic");
        }
        if (statistic.isBlock() != material.isBlock()) {
            throw new IllegalArgumentException("Given material is not valid for this substatistic");
        }
        int mat = material.getId();
        if (!material.isBlock()) {
            mat -= 255;
        }
        this.sendStatistic(statistic.getId() + mat, amount);
    }

    private void sendStatistic(int id, int amount) {
        if (this.getHandle().a == null) {
            return;
        }
        while (amount > 127) {
            this.sendStatistic(id, 127);
            amount -= 127;
        }
        this.getHandle().a.b((ey)new dk(id, amount));
    }

    @Override
    public void setPlayerTime(long time, boolean relative) {
        this.getHandle().timeOffset = time;
        this.getHandle().relativeTime = relative;
    }

    @Override
    public long getPlayerTimeOffset() {
        return this.getHandle().timeOffset;
    }

    @Override
    public long getPlayerTime() {
        return this.getHandle().getPlayerTime();
    }

    @Override
    public boolean isPlayerTimeRelative() {
        return this.getHandle().relativeTime;
    }

    @Override
    public void resetPlayerTime() {
        this.setPlayerTime(0L, true);
    }

    @Override
    public void setPlayerWeather(WeatherType type) {
        this.getHandle().setPlayerWeather(type, true);
    }

    @Override
    public WeatherType getPlayerWeather() {
        return this.getHandle().getPlayerWeather();
    }

    @Override
    public void resetPlayerWeather() {
        this.getHandle().resetPlayerWeather();
    }

    @Override
    public boolean isBanned() {
        return this.server.getHandle().e().a(this.getName().toLowerCase());
    }

    @Override
    public void setBanned(boolean value) {
        if (value) {
            gm entry = new gm(this.getName().toLowerCase());
            this.server.getHandle().e().a(entry);
        } else {
            this.server.getHandle().e().b(this.getName().toLowerCase());
        }
        this.server.getHandle().e().f();
    }

    @Override
    public boolean isWhitelisted() {
        return this.server.getHandle().h().contains(this.getName().toLowerCase());
    }

    @Override
    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.getHandle().g(this.getName().toLowerCase());
        } else {
            this.server.getHandle().h(this.getName().toLowerCase());
        }
    }

    @Override
    public void setGameMode(GameMode mode) {
        if (this.getHandle().a == null) {
            return;
        }
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null");
        }
        if (mode != this.getGameMode()) {
            PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((Player)this, mode);
            this.server.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                return;
            }
            this.getHandle().c.a(ace.a((int)mode.getValue()));
            this.getHandle().a.b((ey)new ef(3, mode.getValue()));
        }
    }

    @Override
    public GameMode getGameMode() {
        return GameMode.getByValue(this.getHandle().c.b().a());
    }

    @Override
    public void giveExp(int exp) {
        this.getHandle().s(exp);
    }

    @Override
    public void giveExpLevels(int levels) {
        this.getHandle().a(levels);
    }

    @Override
    public float getExp() {
        return this.getHandle().bJ;
    }

    @Override
    public void setExp(float exp) {
        this.getHandle().bJ = exp;
        this.getHandle().bS = -1;
    }

    @Override
    public int getLevel() {
        return this.getHandle().bH;
    }

    @Override
    public void setLevel(int level) {
        this.getHandle().bH = level;
        this.getHandle().bS = -1;
    }

    @Override
    public int getTotalExperience() {
        return this.getHandle().bI;
    }

    @Override
    public void setTotalExperience(int exp) {
        this.getHandle().bI = exp;
    }

    @Override
    public float getExhaustion() {
        return this.getHandle().bI().c;
    }

    @Override
    public void setExhaustion(float value) {
        this.getHandle().bI().c = value;
    }

    @Override
    public float getSaturation() {
        return this.getHandle().bI().b;
    }

    @Override
    public void setSaturation(float value) {
        this.getHandle().bI().b = value;
    }

    @Override
    public int getFoodLevel() {
        return this.getHandle().bI().a;
    }

    @Override
    public void setFoodLevel(int value) {
        this.getHandle().bI().a = value;
    }

    @Override
    public Location getBedSpawnLocation() {
        World world = this.getServer().getWorld(this.getHandle().spawnWorld);
        t bed = this.getHandle().bF();
        if (world != null && bed != null && (bed = uf.a((abw)((CraftWorld)world).getHandle(), (t)bed, (boolean)this.getHandle().bG())) != null) {
            return new Location(world, bed.a, bed.b, bed.c);
        }
        return null;
    }

    @Override
    public void setBedSpawnLocation(Location location) {
        this.setBedSpawnLocation(location, false);
    }

    @Override
    public void setBedSpawnLocation(Location location, boolean override) {
        if (location == null) {
            this.getHandle().a(null, override);
        } else {
            this.getHandle().a(new t(location.getBlockX(), location.getBlockY(), location.getBlockZ()), override);
            this.getHandle().spawnWorld = location.getWorld().getName();
        }
    }

    @Override
    public void hidePlayer(Player player) {
        Validate.notNull((Object)player, (String)"hidden player cannot be null");
        if (this.getHandle().a == null) {
            return;
        }
        if (this.equals(player)) {
            return;
        }
        if (this.hiddenPlayers.containsKey(player.getName())) {
            return;
        }
        this.hiddenPlayers.put(player.getName(), player);
        jm tracker = ((js)this.entity.q).J;
        jv other = ((CraftPlayer)player).getHandle();
        jx entry = (jx)tracker.c.a(other.k);
        if (entry != null) {
            entry.c(this.getHandle());
        }
        this.getHandle().a.b((ey)new fd(player.getPlayerListName(), false, 9999));
    }

    @Override
    public void showPlayer(Player player) {
        Validate.notNull((Object)player, (String)"shown player cannot be null");
        if (this.getHandle().a == null) {
            return;
        }
        if (this.equals(player)) {
            return;
        }
        if (!this.hiddenPlayers.containsKey(player.getName())) {
            return;
        }
        this.hiddenPlayers.remove(player.getName());
        jm tracker = ((js)this.entity.q).J;
        jv other = ((CraftPlayer)player).getHandle();
        jx entry = (jx)tracker.c.a(other.k);
        if (entry != null && !entry.o.contains(this.getHandle())) {
            entry.b(this.getHandle());
        }
        this.getHandle().a.b((ey)new fd(player.getPlayerListName(), true, this.getHandle().i));
    }

    @Override
    public boolean canSee(Player player) {
        return !this.hiddenPlayers.containsKey(player.getName());
    }

    @Override
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.getName());
        return result;
    }

    @Override
    public Player getPlayer() {
        return this;
    }

    public jv getHandle() {
        return (jv)this.entity;
    }

    public void setHandle(jv entity) {
        super.setHandle((uf)entity);
    }

    @Override
    public String toString() {
        return "CraftPlayer{name=" + this.getName() + '}';
    }

    @Override
    public int hashCode() {
        if (this.hash == 0 || this.hash == 485) {
            this.hash = 485 + (this.getName() != null ? this.getName().toLowerCase().hashCode() : 0);
        }
        return this.hash;
    }

    @Override
    public long getFirstPlayed() {
        return this.firstPlayed;
    }

    @Override
    public long getLastPlayed() {
        return this.lastPlayed;
    }

    @Override
    public boolean hasPlayedBefore() {
        return this.hasPlayedBefore;
    }

    public void setFirstPlayed(long firstPlayed) {
        this.firstPlayed = firstPlayed;
    }

    public void readExtraData(by nbttagcompound) {
        this.hasPlayedBefore = true;
        if (nbttagcompound.b("bukkit")) {
            by data = nbttagcompound.l("bukkit");
            if (data.b("firstPlayed")) {
                this.firstPlayed = data.f("firstPlayed");
                this.lastPlayed = data.f("lastPlayed");
            }
            if (data.b("newExp")) {
                jv handle = this.getHandle();
                handle.newExp = data.e("newExp");
                handle.newTotalExp = data.e("newTotalExp");
                handle.newLevel = data.e("newLevel");
                handle.expToDrop = data.e("expToDrop");
                handle.keepLevel = data.n("keepLevel");
            }
        }
    }

    public void setExtraData(by nbttagcompound) {
        if (!nbttagcompound.b("bukkit")) {
            nbttagcompound.a("bukkit", new by());
        }
        by data = nbttagcompound.l("bukkit");
        jv handle = this.getHandle();
        data.a("newExp", handle.newExp);
        data.a("newTotalExp", handle.newTotalExp);
        data.a("newLevel", handle.newLevel);
        data.a("expToDrop", handle.expToDrop);
        data.a("keepLevel", handle.keepLevel);
        data.a("firstPlayed", this.getFirstPlayed());
        data.a("lastPlayed", System.currentTimeMillis());
    }

    @Override
    public boolean beginConversation(Conversation conversation) {
        return this.conversationTracker.beginConversation(conversation);
    }

    @Override
    public void abandonConversation(Conversation conversation) {
        this.conversationTracker.abandonConversation(conversation, new ConversationAbandonedEvent(conversation, new ManuallyAbandonedConversationCanceller()));
    }

    @Override
    public void abandonConversation(Conversation conversation, ConversationAbandonedEvent details) {
        this.conversationTracker.abandonConversation(conversation, details);
    }

    @Override
    public void acceptConversationInput(String input) {
        this.conversationTracker.acceptConversationInput(input);
    }

    @Override
    public boolean isConversing() {
        return this.conversationTracker.isConversing();
    }

    @Override
    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage(this.server.getMessenger(), source, channel, message);
        if (this.getHandle().a == null) {
            return;
        }
        if (this.channels.contains(channel)) {
            ea packet = new ea();
            packet.a = channel;
            packet.b = message.length;
            packet.c = message;
            this.getHandle().a.b((ey)packet);
        }
    }

    @Override
    public void setTexturePack(String url) {
        Validate.notNull((Object)url, (String)"Texture pack URL cannot be null");
        byte[] message = (url + "\u0000" + "16").getBytes();
        Validate.isTrue((message.length <= 32766 ? 1 : 0) != 0, (String)"Texture pack URL is too long");
        this.getHandle().a.b((ey)new ea("MC|TPack", message));
    }

    public void addChannel(String channel) {
        if (this.channels.add(channel)) {
            this.server.getPluginManager().callEvent(new PlayerRegisterChannelEvent((Player)this, channel));
        }
    }

    public void removeChannel(String channel) {
        if (this.channels.remove(channel)) {
            this.server.getPluginManager().callEvent(new PlayerUnregisterChannelEvent((Player)this, channel));
        }
    }

    @Override
    public Set<String> getListeningPluginChannels() {
        return ImmutableSet.copyOf(this.channels);
    }

    public void sendSupportedChannels() {
        if (this.getHandle().a == null) {
            return;
        }
        Set<String> listening = this.server.getMessenger().getIncomingChannels();
        if (!listening.isEmpty()) {
            ea packet = new ea();
            packet.a = "REGISTER";
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            for (String channel : listening) {
                try {
                    stream.write(channel.getBytes("UTF8"));
                    stream.write(0);
                }
                catch (IOException ex) {
                    Logger.getLogger(CraftPlayer.class.getName()).log(Level.SEVERE, "Could not send Plugin Channel REGISTER to " + this.getName(), ex);
                }
            }
            packet.c = stream.toByteArray();
            packet.b = packet.c.length;
            this.getHandle().a.b((ey)packet);
        }
    }

    @Override
    public EntityType getType() {
        return EntityType.PLAYER;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getPlayerMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getPlayerMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        uy container = this.getHandle().bp;
        if (container.getBukkitView().getType() != prop.getType()) {
            return false;
        }
        this.getHandle().a(container, prop.getId(), value);
        return true;
    }

    public void disconnect(String reason) {
        this.conversationTracker.abandonAllConversations();
        this.perm.clearPermissions();
    }

    @Override
    public boolean isFlying() {
        return this.getHandle().bG.b;
    }

    @Override
    public void setFlying(boolean value) {
        if (!this.getAllowFlight() && value) {
            throw new IllegalArgumentException("Cannot make player fly if getAllowFlight() is false");
        }
        this.getHandle().bG.b = value;
        this.getHandle().o();
    }

    @Override
    public boolean getAllowFlight() {
        return this.getHandle().bG.c;
    }

    @Override
    public void setAllowFlight(boolean value) {
        if (this.isFlying() && !value) {
            this.getHandle().bG.b = false;
        }
        this.getHandle().bG.c = value;
        this.getHandle().o();
    }

    @Override
    public int getNoDamageTicks() {
        if (this.getHandle().bT > 0) {
            return Math.max(this.getHandle().bT, this.getHandle().af);
        }
        return this.getHandle().af;
    }

    @Override
    public void setFlySpeed(float value) {
        this.validateSpeed(value);
        jv player = this.getHandle();
        player.bG.a(Math.max(value, 1.0E-4f) / 2.0f);
        player.o();
    }

    @Override
    public void setWalkSpeed(float value) {
        this.validateSpeed(value);
        jv player = this.getHandle();
        player.bG.b(Math.max(value, 1.0E-4f) / 2.0f);
        player.o();
    }

    @Override
    public float getFlySpeed() {
        return this.getHandle().bG.a() * 2.0f;
    }

    @Override
    public float getWalkSpeed() {
        return this.getHandle().bG.b() * 2.0f;
    }

    private void validateSpeed(float value) {
        if (value < 0.0f) {
            if (value < -1.0f) {
                throw new IllegalArgumentException(value + " is too low");
            }
        } else if (value > 1.0f) {
            throw new IllegalArgumentException(value + " is too high");
        }
    }

    @Override
    public void setMaxHealth(double amount) {
        super.setMaxHealth(amount);
        this.health = Math.min(this.health, this.health);
        this.getHandle().m();
    }

    @Override
    public void resetMaxHealth() {
        super.resetMaxHealth();
        this.getHandle().m();
    }

    @Override
    public CraftScoreboard getScoreboard() {
        return this.server.getScoreboardManager().getPlayerBoard(this);
    }

    @Override
    public void setScoreboard(Scoreboard scoreboard) {
        Validate.notNull((Object)scoreboard, (String)"Scoreboard cannot be null");
        ka playerConnection = this.getHandle().a;
        if (playerConnection == null) {
            throw new IllegalStateException("Cannot set scoreboard yet");
        }
        if (playerConnection.b) {
            throw new IllegalStateException("Cannot set scoreboard for invalid CraftPlayer");
        }
        this.server.getScoreboardManager().setPlayerBoard(this, scoreboard);
    }

    @Override
    public void setHealthScale(double value) {
        Validate.isTrue(((float)value > 0.0f ? 1 : 0) != 0, (String)"Must be greater than 0");
        this.healthScale = value;
        this.scaledHealth = true;
        this.updateScaledHealth();
    }

    @Override
    public double getHealthScale() {
        return this.healthScale;
    }

    @Override
    public void setHealthScaled(boolean scale) {
        this.scaledHealth = scale;
        if (this.scaledHealth != this.scaledHealth) {
            this.updateScaledHealth();
        }
    }

    @Override
    public boolean isHealthScaled() {
        return this.scaledHealth;
    }

    public float getScaledHealth() {
        return (float)(this.isHealthScaled() ? this.getHealth() * this.getHealthScale() / this.getMaxHealth() : this.getHealth());
    }

    @Override
    public double getHealth() {
        return this.health;
    }

    public void setRealHealth(double health) {
        this.health = health;
    }

    public void updateScaledHealth() {
        pa attributemapserver = (pa)this.getHandle().aX();
        Set set = attributemapserver.b();
        this.injectScaledMaxHealth(set, true);
        this.getHandle().v().b(6, (Object)Float.valueOf(this.getScaledHealth()));
        this.getHandle().a.b((ey)new fs(this.getScaledHealth(), this.getHandle().bI().a(), this.getHandle().bI().e()));
        this.getHandle().a.b((ey)new gh(this.getHandle().k, (Collection)set));
        set.clear();
        this.getHandle().maxHealthCache = this.getMaxHealth();
    }

    public void injectScaledMaxHealth(Collection collection, boolean force) {
        if (!this.scaledHealth && !force) {
            return;
        }
        for (Object genericInstance : collection) {
            or attribute = ((os)genericInstance).a();
            if (!attribute.a().equals("generic.maxHealth")) continue;
            collection.remove(genericInstance);
            break;
        }
        collection.add(new ox(this.getHandle().aX(), (or)new oy("generic.maxHealth", this.scaledHealth ? this.healthScale : this.getMaxHealth(), 0.0, 3.4028234663852886E38).a("Max Health").a(true)));
    }

    @Override
    public Player.Spigot spigot() {
        return this.spigot;
    }
}

