/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_6_R3.inventory;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.apache.commons.lang.Validate;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftMetaSkull;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class CraftItemFactory
implements ItemFactory {
    static final Color DEFAULT_LEATHER_COLOR = Color.fromRGB(10511680);
    static final Collection<String> KNOWN_NBT_ATTRIBUTE_NAMES;
    private static final CraftItemFactory instance;

    private CraftItemFactory() {
    }

    @Override
    public boolean isApplicable(ItemMeta meta, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return this.isApplicable(meta, itemstack.getType());
    }

    @Override
    public boolean isApplicable(ItemMeta meta, Material type) {
        if (type == null || meta == null) {
            return false;
        }
        if (!(meta instanceof CraftMetaItem)) {
            throw new IllegalArgumentException("Meta of " + meta.getClass().toString() + " not created by " + CraftItemFactory.class.getName());
        }
        return ((CraftMetaItem)meta).applicableTo(type);
    }

    @Override
    public ItemMeta getItemMeta(Material material) {
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        return this.getItemMeta(material, null);
    }

    private ItemMeta getItemMeta(Material material, CraftMetaItem meta) {
        switch (material) {
            case AIR: {
                return null;
            }
            case WRITTEN_BOOK: 
            case BOOK_AND_QUILL: {
                return meta instanceof CraftMetaBook ? meta : new CraftMetaBook(meta);
            }
            case SKULL_ITEM: {
                return meta instanceof CraftMetaSkull ? meta : new CraftMetaSkull(meta);
            }
            case LEATHER_HELMET: 
            case LEATHER_CHESTPLATE: 
            case LEATHER_LEGGINGS: 
            case LEATHER_BOOTS: {
                return meta instanceof CraftMetaLeatherArmor ? meta : new CraftMetaLeatherArmor(meta);
            }
            case POTION: {
                return meta instanceof CraftMetaPotion ? meta : new CraftMetaPotion(meta);
            }
            case MAP: {
                return meta instanceof CraftMetaMap ? meta : new CraftMetaMap(meta);
            }
            case FIREWORK: {
                return meta instanceof CraftMetaFirework ? meta : new CraftMetaFirework(meta);
            }
            case FIREWORK_CHARGE: {
                return meta instanceof CraftMetaCharge ? meta : new CraftMetaCharge(meta);
            }
            case ENCHANTED_BOOK: {
                return meta instanceof CraftMetaEnchantedBook ? meta : new CraftMetaEnchantedBook(meta);
            }
        }
        return new CraftMetaItem(meta);
    }

    @Override
    public boolean equals(ItemMeta meta1, ItemMeta meta2) {
        if (meta1 == meta2) {
            return true;
        }
        if (meta1 != null && !(meta1 instanceof CraftMetaItem)) {
            throw new IllegalArgumentException("First meta of " + meta1.getClass().getName() + " does not belong to " + CraftItemFactory.class.getName());
        }
        if (meta2 != null && !(meta2 instanceof CraftMetaItem)) {
            throw new IllegalArgumentException("Second meta " + meta2.getClass().getName() + " does not belong to " + CraftItemFactory.class.getName());
        }
        if (meta1 == null) {
            return ((CraftMetaItem)meta2).isEmpty();
        }
        if (meta2 == null) {
            return ((CraftMetaItem)meta1).isEmpty();
        }
        return this.equals((CraftMetaItem)meta1, (CraftMetaItem)meta2);
    }

    boolean equals(CraftMetaItem meta1, CraftMetaItem meta2) {
        return meta1.equalsCommon(meta2) && meta1.notUncommon(meta2) && meta2.notUncommon(meta1);
    }

    public static CraftItemFactory instance() {
        return instance;
    }

    @Override
    public ItemMeta asMetaFor(ItemMeta meta, ItemStack stack) {
        Validate.notNull((Object)stack, (String)"Stack cannot be null");
        return this.asMetaFor(meta, stack.getType());
    }

    @Override
    public ItemMeta asMetaFor(ItemMeta meta, Material material) {
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        if (!(meta instanceof CraftMetaItem)) {
            throw new IllegalArgumentException("Meta of " + (meta != null ? meta.getClass().toString() : "null") + " not created by " + CraftItemFactory.class.getName());
        }
        return this.getItemMeta(material, (CraftMetaItem)meta);
    }

    @Override
    public Color getDefaultLeatherColor() {
        return DEFAULT_LEATHER_COLOR;
    }

    static {
        instance = new CraftItemFactory();
        ConfigurationSerialization.registerClass(CraftMetaItem.SerializableMeta.class);
        KNOWN_NBT_ATTRIBUTE_NAMES = ImmutableSet.builder().add((Object)"generic.attackDamage").add((Object)"generic.followRange").add((Object)"generic.knockbackResistance").add((Object)"generic.maxHealth").add((Object)"generic.movementSpeed").add((Object)"horse.jumpStrength").add((Object)"zombie.spawnReinforcements").build();
    }
}

