/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_6_R3.inventory;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftMetaSkull;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@DelegateDeserialization(value=ItemStack.class)
public final class CraftItemStack
extends ItemStack {
    ye handle;

    public static ye asNMSCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return stack.handle == null ? null : stack.handle.m();
        }
        if (original == null || original.getTypeId() <= 0) {
            return null;
        }
        ye stack = new ye(original.getTypeId(), original.getAmount(), (int)original.getDurability());
        if (original.hasItemMeta()) {
            CraftItemStack.setItemMeta(stack, original.getItemMeta());
        }
        return stack;
    }

    public static ye copyNMSStack(ye original, int amount) {
        ye stack = original.m();
        stack.b = amount;
        return stack;
    }

    public static ItemStack asBukkitCopy(ye original) {
        if (original == null) {
            return new ItemStack(Material.AIR);
        }
        return CraftItemStack.asCraftMirror(CraftItemStack.copyNMSStack(original, original.b));
    }

    public static CraftItemStack asCraftMirror(ye original) {
        return new CraftItemStack(original);
    }

    public static CraftItemStack asCraftCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return new CraftItemStack(stack.handle == null ? null : stack.handle.m());
        }
        return new CraftItemStack(original);
    }

    public static CraftItemStack asNewCraftStack(yc item) {
        return CraftItemStack.asNewCraftStack(item, 1);
    }

    public static CraftItemStack asNewCraftStack(yc item, int amount) {
        return new CraftItemStack(item.cv, amount, 0, null);
    }

    private CraftItemStack(ye item) {
        this.handle = item;
    }

    private CraftItemStack(ItemStack item) {
        this(item.getTypeId(), item.getAmount(), item.getDurability(), item.hasItemMeta() ? item.getItemMeta() : null);
    }

    private CraftItemStack(int typeId, int amount, short durability, ItemMeta itemMeta) {
        this.setTypeId(typeId);
        this.setAmount(amount);
        this.setDurability(durability);
        this.setItemMeta(itemMeta);
    }

    @Override
    public int getTypeId() {
        return this.handle != null ? this.handle.d : 0;
    }

    @Override
    public void setTypeId(int type) {
        if (this.getTypeId() == type) {
            return;
        }
        if (type == 0) {
            this.handle = null;
        } else if (this.handle == null) {
            this.handle = new ye(type, 1, 0);
        } else {
            this.handle.d = type;
            if (this.hasItemMeta()) {
                CraftItemStack.setItemMeta(this.handle, CraftItemStack.getItemMeta(this.handle));
            }
        }
        this.setData(null);
    }

    @Override
    public int getAmount() {
        return this.handle != null ? this.handle.b : 0;
    }

    @Override
    public void setAmount(int amount) {
        if (this.handle == null) {
            return;
        }
        if (amount == 0) {
            this.handle = null;
        } else {
            this.handle.b = amount;
        }
    }

    @Override
    public void setDurability(short durability) {
        if (this.handle != null) {
            this.handle.b((int)durability);
        }
    }

    @Override
    public short getDurability() {
        if (this.handle != null) {
            return (short)this.handle.k();
        }
        return -1;
    }

    @Override
    public int getMaxStackSize() {
        return this.handle == null ? Material.AIR.getMaxStackSize() : this.handle.b().m();
    }

    @Override
    public void addUnsafeEnchantment(Enchantment ench, int level) {
        Validate.notNull((Object)ench, (String)"Cannot add null enchantment");
        if (!CraftItemStack.makeTag(this.handle)) {
            return;
        }
        cg list = CraftItemStack.getEnchantmentList(this.handle);
        if (list == null) {
            list = new cg(CraftMetaItem.ENCHANTMENTS.NBT);
            this.handle.e.a(CraftMetaItem.ENCHANTMENTS.NBT, (cl)list);
        }
        int size = list.c();
        for (int i = 0; i < size; ++i) {
            by tag = (by)list.b(i);
            short id = tag.d(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            if (id != ench.getId()) continue;
            tag.a(CraftMetaItem.ENCHANTMENTS_LVL.NBT, (short)level);
            return;
        }
        by tag = new by();
        tag.a(CraftMetaItem.ENCHANTMENTS_ID.NBT, (short)ench.getId());
        tag.a(CraftMetaItem.ENCHANTMENTS_LVL.NBT, (short)level);
        list.a((cl)tag);
    }

    static boolean makeTag(ye item) {
        if (item == null) {
            return false;
        }
        if (item.e == null) {
            item.d(new by("tag"));
        }
        return true;
    }

    @Override
    public boolean containsEnchantment(Enchantment ench) {
        return this.getEnchantmentLevel(ench) > 0;
    }

    @Override
    public int getEnchantmentLevel(Enchantment ench) {
        Validate.notNull((Object)ench, (String)"Cannot find null enchantment");
        if (this.handle == null) {
            return 0;
        }
        return aaw.a((int)ench.getId(), (ye)this.handle);
    }

    @Override
    public int removeEnchantment(Enchantment ench) {
        int i;
        Validate.notNull((Object)ench, (String)"Cannot remove null enchantment");
        cg list = CraftItemStack.getEnchantmentList(this.handle);
        if (list == null) {
            return 0;
        }
        int index = Integer.MIN_VALUE;
        int level = Integer.MIN_VALUE;
        int size = list.c();
        for (i = 0; i < size; ++i) {
            by enchantment = (by)list.b(i);
            int id = 0xFFFF & enchantment.d(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            if (id != ench.getId()) continue;
            index = i;
            level = 0xFFFF & enchantment.d(CraftMetaItem.ENCHANTMENTS_LVL.NBT);
            break;
        }
        if (index == Integer.MIN_VALUE) {
            return 0;
        }
        if (size == 1) {
            this.handle.e.o(CraftMetaItem.ENCHANTMENTS.NBT);
            if (this.handle.e.d()) {
                this.handle.e = null;
            }
            return level;
        }
        cg listCopy = new cg(CraftMetaItem.ENCHANTMENTS.NBT);
        for (i = 0; i < size; ++i) {
            if (i == index) continue;
            listCopy.a(list.b(i));
        }
        this.handle.e.a(CraftMetaItem.ENCHANTMENTS.NBT, (cl)listCopy);
        return level;
    }

    @Override
    public Map<Enchantment, Integer> getEnchantments() {
        return CraftItemStack.getEnchantments(this.handle);
    }

    static Map<Enchantment, Integer> getEnchantments(ye item) {
        cg list;
        ImmutableMap.Builder result = ImmutableMap.builder();
        cg cg2 = list = item == null ? null : item.r();
        if (list == null) {
            return result.build();
        }
        for (int i = 0; i < list.c(); ++i) {
            int id = 0xFFFF & ((by)list.b(i)).d(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            int level = 0xFFFF & ((by)list.b(i)).d(CraftMetaItem.ENCHANTMENTS_LVL.NBT);
            result.put((Object)Enchantment.getById(id), (Object)level);
        }
        return result.build();
    }

    static cg getEnchantmentList(ye item) {
        return item == null ? null : item.r();
    }

    @Override
    public CraftItemStack clone() {
        CraftItemStack itemStack = (CraftItemStack)super.clone();
        if (this.handle != null) {
            itemStack.handle = this.handle.m();
        }
        return itemStack;
    }

    @Override
    public ItemMeta getItemMeta() {
        return CraftItemStack.getItemMeta(this.handle);
    }

    public static ItemMeta getItemMeta(ye item) {
        if (!CraftItemStack.hasItemMeta(item)) {
            return CraftItemFactory.instance().getItemMeta(CraftItemStack.getType(item));
        }
        switch (CraftItemStack.getType(item)) {
            case WRITTEN_BOOK: 
            case BOOK_AND_QUILL: {
                return new CraftMetaBook(item.e);
            }
            case SKULL_ITEM: {
                return new CraftMetaSkull(item.e);
            }
            case LEATHER_HELMET: 
            case LEATHER_CHESTPLATE: 
            case LEATHER_LEGGINGS: 
            case LEATHER_BOOTS: {
                return new CraftMetaLeatherArmor(item.e);
            }
            case POTION: {
                return new CraftMetaPotion(item.e);
            }
            case MAP: {
                return new CraftMetaMap(item.e);
            }
            case FIREWORK: {
                return new CraftMetaFirework(item.e);
            }
            case FIREWORK_CHARGE: {
                return new CraftMetaCharge(item.e);
            }
            case ENCHANTED_BOOK: {
                return new CraftMetaEnchantedBook(item.e);
            }
        }
        return new CraftMetaItem(item.e);
    }

    static Material getType(ye item) {
        Material material = Material.getMaterial(item == null ? 0 : item.d);
        return material == null ? Material.AIR : material;
    }

    @Override
    public boolean setItemMeta(ItemMeta itemMeta) {
        return CraftItemStack.setItemMeta(this.handle, itemMeta);
    }

    public static boolean setItemMeta(ye item, ItemMeta itemMeta) {
        if (item == null) {
            return false;
        }
        if (itemMeta == null) {
            item.e = null;
            return true;
        }
        if (!CraftItemFactory.instance().isApplicable(itemMeta, CraftItemStack.getType(item))) {
            return false;
        }
        by tag = new by("tag");
        item.d(tag);
        ((CraftMetaItem)itemMeta).applyToItem(tag);
        return true;
    }

    @Override
    public boolean isSimilar(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack == this) {
            return true;
        }
        if (!(stack instanceof CraftItemStack)) {
            return stack.getClass() == ItemStack.class && stack.isSimilar(this);
        }
        CraftItemStack that = (CraftItemStack)stack;
        if (this.handle == that.handle) {
            return true;
        }
        if (this.handle == null || that.handle == null) {
            return false;
        }
        if (that.getTypeId() != this.getTypeId() || this.getDurability() != that.getDurability()) {
            return false;
        }
        return this.hasItemMeta() ? that.hasItemMeta() && this.handle.e.equals((Object)that.handle.e) : !that.hasItemMeta();
    }

    @Override
    public boolean hasItemMeta() {
        return CraftItemStack.hasItemMeta(this.handle);
    }

    static boolean hasItemMeta(ye item) {
        return item != null && item.e != null && !item.e.d();
    }
}

