/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_6_R3.scoreboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_6_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_6_R3.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_6_R3.util.WeakCollection;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public final class CraftScoreboardManager
implements ScoreboardManager {
    private final CraftScoreboard mainScoreboard;
    private final MinecraftServer server;
    private final Collection<CraftScoreboard> scoreboards = new WeakCollection<CraftScoreboard>();
    private final Map<CraftPlayer, CraftScoreboard> playerBoards = new HashMap<CraftPlayer, CraftScoreboard>();

    public CraftScoreboardManager(MinecraftServer minecraftserver, atj scoreboardServer) {
        this.mainScoreboard = new CraftScoreboard(scoreboardServer);
        this.server = minecraftserver;
        this.scoreboards.add(this.mainScoreboard);
    }

    @Override
    public CraftScoreboard getMainScoreboard() {
        return this.mainScoreboard;
    }

    @Override
    public CraftScoreboard getNewScoreboard() {
        CraftScoreboard scoreboard = new CraftScoreboard((atj)new hp(this.server));
        this.scoreboards.add(scoreboard);
        return scoreboard;
    }

    public CraftScoreboard getPlayerBoard(CraftPlayer player) {
        CraftScoreboard board = this.playerBoards.get(player);
        return board == null ? this.getMainScoreboard() : board;
    }

    public void setPlayerBoard(CraftPlayer player, Scoreboard bukkitScoreboard) throws IllegalArgumentException {
        Validate.isTrue((boolean)(bukkitScoreboard instanceof CraftScoreboard), (String)"Cannot set player scoreboard to an unregistered Scoreboard");
        CraftScoreboard scoreboard = (CraftScoreboard)bukkitScoreboard;
        atj oldboard = this.getPlayerBoard(player).getHandle();
        atj newboard = scoreboard.getHandle();
        jv entityplayer = player.getHandle();
        if (oldboard == newboard) {
            return;
        }
        if (scoreboard == this.mainScoreboard) {
            this.playerBoards.remove(player);
        } else {
            this.playerBoards.put(player, scoreboard);
        }
        HashSet<ate> removed = new HashSet<ate>();
        for (int i = 0; i < 3; ++i) {
            ate scoreboardobjective = oldboard.a(i);
            if (scoreboardobjective == null || removed.contains(scoreboardobjective)) continue;
            entityplayer.a.b((ey)new ft(scoreboardobjective, 1));
            removed.add(scoreboardobjective);
        }
        for (atf scoreboardteam : oldboard.g()) {
            entityplayer.a.b((ey)new fu(scoreboardteam, 1));
        }
        this.server.af().a((hp)newboard, player.getHandle());
    }

    public void removePlayer(Player player) {
        this.playerBoards.remove(player);
    }

    public Collection<atg> getScoreboardScores(ato criteria, String name, Collection<atg> collection) {
        for (CraftScoreboard scoreboard : this.scoreboards) {
            atj board = scoreboard.board;
            for (ate objective : board.a(criteria)) {
                collection.add(board.a(name, objective));
            }
        }
        return collection;
    }

    public void updateAllScoresForList(ato criteria, String name, List<jv> of2) {
        for (atg score : this.getScoreboardScores(criteria, name, new ArrayList<atg>())) {
            score.a(of2);
        }
    }
}

