/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_6_R3.updater;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.craftbukkit.v1_6_R3.updater.ArtifactDetails;

public class BukkitDLUpdaterService {
    private static final String API_PREFIX_ARTIFACT = "/api/1.0/downloads/projects/craftbukkit/view/";
    private static final String API_PREFIX_CHANNEL = "/api/1.0/downloads/channels/";
    private static final DateDeserializer dateDeserializer = new DateDeserializer();
    private final String host;

    public BukkitDLUpdaterService(String host) {
        this.host = host;
    }

    public ArtifactDetails getArtifact(String slug, String name) {
        try {
            return this.fetchArtifact(slug);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(BukkitDLUpdaterService.class.getName()).log(Level.WARNING, "Could not get " + name + ": " + ex.getClass().getSimpleName());
        }
        catch (IOException ex) {
            Logger.getLogger(BukkitDLUpdaterService.class.getName()).log(Level.WARNING, "Could not get " + name + ": " + ex.getClass().getSimpleName());
        }
        return null;
    }

    private String getUserAgent() {
        return "CraftBukkit/" + BukkitDLUpdaterService.class.getPackage().getImplementationVersion() + "/" + System.getProperty("java.version");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactDetails fetchArtifact(String slug) throws IOException {
        URL url = new URL("http", this.host, API_PREFIX_ARTIFACT + slug + "/");
        InputStreamReader reader = null;
        try {
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("User-Agent", this.getUserAgent());
            reader = new InputStreamReader(connection.getInputStream());
            Gson gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)dateDeserializer).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
            ArtifactDetails artifactDetails = (ArtifactDetails)gson.fromJson((Reader)reader, ArtifactDetails.class);
            return artifactDetails;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public ArtifactDetails.ChannelDetails getChannel(String slug, String name) {
        try {
            return this.fetchChannel(slug);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(BukkitDLUpdaterService.class.getName()).log(Level.WARNING, "Could not get " + name + ": " + ex.getClass().getSimpleName());
        }
        catch (IOException ex) {
            Logger.getLogger(BukkitDLUpdaterService.class.getName()).log(Level.WARNING, "Could not get " + name + ": " + ex.getClass().getSimpleName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactDetails.ChannelDetails fetchChannel(String slug) throws IOException {
        URL url = new URL("http", this.host, API_PREFIX_CHANNEL + slug + "/");
        InputStreamReader reader = null;
        try {
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("User-Agent", this.getUserAgent());
            reader = new InputStreamReader(connection.getInputStream());
            Gson gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)dateDeserializer).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
            ArtifactDetails.ChannelDetails channelDetails = (ArtifactDetails.ChannelDetails)gson.fromJson((Reader)reader, ArtifactDetails.ChannelDetails.class);
            return channelDetails;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    static class DateDeserializer
    implements JsonDeserializer<Date> {
        private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        DateDeserializer() {
        }

        public Date deserialize(JsonElement je, Type type, JsonDeserializationContext jdc) throws JsonParseException {
            try {
                return format.parse(je.getAsString());
            }
            catch (ParseException ex) {
                throw new JsonParseException("Date is not formatted correctly", (Throwable)ex);
            }
        }
    }
}

