/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_6_R3.util;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_6_R3.CraftWorld;
import org.bukkit.material.MaterialData;

public class StructureGrowDelegate
implements BlockChangeDelegate {
    private final CraftWorld world;
    private final List<BlockState> blocks = new ArrayList<BlockState>();

    public StructureGrowDelegate(abw world) {
        this.world = world.getWorld();
    }

    @Override
    public boolean setRawTypeId(int x, int y, int z, int type) {
        return this.setRawTypeIdAndData(x, y, z, type, 0);
    }

    @Override
    public boolean setRawTypeIdAndData(int x, int y, int z, int type, int data) {
        BlockState state = this.world.getBlockAt(x, y, z).getState();
        state.setTypeId(type);
        state.setData(new MaterialData(type, (byte)data));
        this.blocks.add(state);
        return true;
    }

    @Override
    public boolean setTypeId(int x, int y, int z, int typeId) {
        return this.setRawTypeId(x, y, z, typeId);
    }

    @Override
    public boolean setTypeIdAndData(int x, int y, int z, int typeId, int data) {
        return this.setRawTypeIdAndData(x, y, z, typeId, data);
    }

    @Override
    public int getTypeId(int x, int y, int z) {
        return this.world.getBlockTypeIdAt(x, y, z);
    }

    @Override
    public int getHeight() {
        return this.world.getMaxHeight();
    }

    public List<BlockState> getBlocks() {
        return this.blocks;
    }

    @Override
    public boolean isEmpty(int x, int y, int z) {
        return this.world.getBlockAt(x, y, z).isEmpty();
    }
}

