/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin.java;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.md_5.specialsource.InheritanceMap;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.transformer.MappingTransformer;
import net.md_5.specialsource.transformer.MavenShade;
import org.apache.commons.lang.Validate;
import org.bukkit.Server;
import org.bukkit.Warning;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.AuthorNagException;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.UnknownDependencyException;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.PluginClassLoader;
import org.spigotmc.CustomTimingsHandler;
import org.yaml.snakeyaml.error.YAMLException;

public class JavaPluginLoader
implements PluginLoader {
    final Server server;
    final boolean extended = this.getClass() != JavaPluginLoader.class;
    boolean warn;
    private final Pattern[] fileFilters0 = new Pattern[]{Pattern.compile("\\.jar$")};
    @Deprecated
    protected final Pattern[] fileFilters = this.fileFilters0;
    private final Map<String, Class<?>> classes0 = new HashMap();
    @Deprecated
    protected final Map<String, Class<?>> classes = this.classes0;
    private final Map<String, PluginClassLoader> loaders0 = new LinkedHashMap<String, PluginClassLoader>();
    @Deprecated
    protected final Map<String, PluginClassLoader> loaders = this.loaders0;
    public static final CustomTimingsHandler pluginParentTimer = new CustomTimingsHandler("** Plugins");
    private InheritanceMap globalInheritanceMap = null;

    @Deprecated
    public JavaPluginLoader(Server instance) {
        Validate.notNull((Object)instance, (String)"Server cannot be null");
        this.server = instance;
        boolean bl = this.warn = instance.getWarningState() != Warning.WarningState.OFF;
        if (this.extended && this.warn) {
            this.warn = false;
            instance.getLogger().log(Level.WARNING, "JavaPluginLoader not intended to be extended by " + this.getClass() + ", and may be final in a future version of Bukkit");
        }
    }

    @Override
    public Plugin loadPlugin(File file) throws InvalidPluginException {
        File oldDataFolder;
        PluginDescriptionFile description;
        Validate.notNull((Object)file, (String)"File cannot be null");
        if (!file.exists()) {
            throw new InvalidPluginException(new FileNotFoundException(file.getPath() + " does not exist"));
        }
        try {
            description = this.getPluginDescription(file);
        }
        catch (InvalidDescriptionException ex) {
            throw new InvalidPluginException(ex);
        }
        File dataFolder = new File(file.getParentFile(), description.getName());
        File file2 = oldDataFolder = this.extended ? this.getDataFolder(file) : this.getDataFolder0(file);
        if (!dataFolder.equals(oldDataFolder)) {
            if (dataFolder.isDirectory() && oldDataFolder.isDirectory()) {
                this.server.getLogger().log(Level.INFO, String.format("While loading %s (%s) found old-data folder: %s next to the new one: %s", description.getName(), file, oldDataFolder, dataFolder));
            } else if (oldDataFolder.isDirectory() && !dataFolder.exists()) {
                if (!oldDataFolder.renameTo(dataFolder)) {
                    throw new InvalidPluginException("Unable to rename old data folder: '" + oldDataFolder + "' to: '" + dataFolder + "'");
                }
                this.server.getLogger().log(Level.INFO, String.format("While loading %s (%s) renamed data folder: '%s' to '%s'", description.getName(), file, oldDataFolder, dataFolder));
            }
        }
        if (dataFolder.exists() && !dataFolder.isDirectory()) {
            throw new InvalidPluginException(String.format("Projected datafolder: '%s' for %s (%s) exists and is not a directory", dataFolder, description.getName(), file));
        }
        ImmutableList depend = description.getDepend();
        if (depend == null) {
            depend = ImmutableList.of();
        }
        for (String pluginName : depend) {
            if (this.loaders0 == null) {
                throw new UnknownDependencyException(pluginName);
            }
            PluginClassLoader current = this.loaders0.get(pluginName);
            if (current != null) continue;
            throw new UnknownDependencyException(pluginName);
        }
        PluginClassLoader loader = null;
        JavaPlugin result = null;
        try {
            URL[] urls = new URL[]{file.toURI().toURL()};
            if (description.getClassLoaderOf() != null) {
                loader = this.loaders0.get(description.getClassLoaderOf());
                loader.addURL(urls[0]);
            } else {
                loader = new PluginClassLoader(this, urls, this.getClass().getClassLoader(), description);
            }
            Class<?> jarClass = Class.forName(description.getMain(), true, loader);
            Class<JavaPlugin> plugin = jarClass.asSubclass(JavaPlugin.class);
            Constructor<JavaPlugin> constructor = plugin.getConstructor(new Class[0]);
            result = constructor.newInstance(new Object[0]);
            result.initialize(this, this.server, description, dataFolder, file, loader);
        }
        catch (InvocationTargetException ex) {
            throw new InvalidPluginException(ex.getCause());
        }
        catch (Throwable ex) {
            throw new InvalidPluginException(ex);
        }
        this.loaders0.put(description.getName(), loader);
        return result;
    }

    @Deprecated
    public Plugin loadPlugin(File file, boolean ignoreSoftDependencies) throws InvalidPluginException {
        if (this.warn) {
            this.server.getLogger().log(Level.WARNING, "Method \"public Plugin loadPlugin(File, boolean)\" is Deprecated, and may be removed in a future version of Bukkit", new AuthorNagException(""));
            this.warn = false;
        }
        return this.loadPlugin(file);
    }

    @Deprecated
    protected File getDataFolder(File file) {
        if (this.warn) {
            this.server.getLogger().log(Level.WARNING, "Method \"protected File getDataFolder(File)\" is Deprecated, and may be removed in a future version of Bukkit", new AuthorNagException(""));
            this.warn = false;
        }
        return this.getDataFolder0(file);
    }

    private File getDataFolder0(File file) {
        File dataFolder = null;
        String filename = file.getName();
        int index = file.getName().lastIndexOf(".");
        if (index != -1) {
            String name = filename.substring(0, index);
            dataFolder = new File(file.getParentFile(), name);
        } else {
            dataFolder = new File(file.getParentFile(), filename + "_");
        }
        return dataFolder;
    }

    @Override
    public PluginDescriptionFile getPluginDescription(File file) throws InvalidDescriptionException {
        Validate.notNull((Object)file, (String)"File cannot be null");
        JarFile jar = null;
        InputStream stream = null;
        try {
            jar = new JarFile(file);
            JarEntry entry = jar.getJarEntry("plugin.yml");
            if (entry == null) {
                throw new InvalidDescriptionException(new FileNotFoundException("Jar does not contain plugin.yml"));
            }
            stream = jar.getInputStream(entry);
            PluginDescriptionFile pluginDescriptionFile = new PluginDescriptionFile(stream);
            return pluginDescriptionFile;
        }
        catch (IOException ex) {
            throw new InvalidDescriptionException(ex);
        }
        catch (YAMLException ex) {
            throw new InvalidDescriptionException(ex);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException e) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public Pattern[] getPluginFileFilters() {
        return (Pattern[])this.fileFilters0.clone();
    }

    @Deprecated
    public Class<?> getClassByName(String name) {
        if (this.warn) {
            this.server.getLogger().log(Level.WARNING, "Method \"public Class<?> getClassByName(String)\" is Deprecated, and may be removed in a future version of Bukkit", new AuthorNagException(""));
            this.warn = false;
        }
        return this.getClassByName0(name);
    }

    Class<?> getClassByName0(String name) {
        Class<?> cachedClass = this.classes0.get(name);
        if (cachedClass != null) {
            return cachedClass;
        }
        for (String current : this.loaders0.keySet()) {
            PluginClassLoader loader = this.loaders0.get(current);
            try {
                cachedClass = loader.extended ? loader.findClass(name, false) : loader.findClass0(name, false);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            if (cachedClass == null) continue;
            return cachedClass;
        }
        return null;
    }

    @Deprecated
    public void setClass(String name, Class<?> clazz) {
        if (this.warn) {
            this.server.getLogger().log(Level.WARNING, "Method \"public void setClass(String, Class<?>)\" is Deprecated, and may be removed in a future version of Bukkit", new AuthorNagException(""));
            this.warn = false;
        }
        this.setClass0(name, clazz);
    }

    void setClass0(String name, Class<?> clazz) {
        if (!this.classes0.containsKey(name)) {
            this.classes0.put(name, clazz);
            if (ConfigurationSerializable.class.isAssignableFrom(clazz)) {
                Class<ConfigurationSerializable> serializable = clazz.asSubclass(ConfigurationSerializable.class);
                ConfigurationSerialization.registerClass(serializable);
            }
        }
    }

    @Deprecated
    public void removeClass(String name) {
        if (this.warn) {
            this.server.getLogger().log(Level.WARNING, "Method \"public void removeClass(String)\" is Deprecated, and may be removed in a future version of Bukkit", new AuthorNagException(""));
            this.warn = false;
        }
        this.removeClass0(name);
    }

    private void removeClass0(String name) {
        Class<?> clazz = this.classes0.remove(name);
        try {
            if (clazz != null && ConfigurationSerializable.class.isAssignableFrom(clazz)) {
                Class<ConfigurationSerializable> serializable = clazz.asSubclass(ConfigurationSerializable.class);
                ConfigurationSerialization.unregisterClass(serializable);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public Map<Class<? extends Event>, Set<RegisteredListener>> createRegisteredListeners(Listener listener, Plugin plugin) {
        HashSet<Method> methods;
        Validate.notNull((Object)plugin, (String)"Plugin can not be null");
        Validate.notNull((Object)listener, (String)"Listener can not be null");
        boolean useTimings = this.server.getPluginManager().useTimings();
        HashMap<Class<? extends Event>, Set<RegisteredListener>> ret = new HashMap<Class<? extends Event>, Set<RegisteredListener>>();
        try {
            Method[] publicMethods = listener.getClass().getMethods();
            methods = new HashSet<Method>(publicMethods.length, Float.MAX_VALUE);
            for (Method method : publicMethods) {
                methods.add(method);
            }
            for (Method method : listener.getClass().getDeclaredMethods()) {
                methods.add(method);
            }
        }
        catch (NoClassDefFoundError e) {
            plugin.getLogger().severe("Plugin " + plugin.getDescription().getFullName() + " has failed to register events for " + listener.getClass() + " because " + e.getMessage() + " does not exist.");
            return ret;
        }
        for (final Method method : methods) {
            Class<?> checkClass;
            EventHandler eh = method.getAnnotation(EventHandler.class);
            if (eh == null) continue;
            if (method.getParameterTypes().length != 1 || !Event.class.isAssignableFrom(checkClass = method.getParameterTypes()[0])) {
                plugin.getLogger().severe(plugin.getDescription().getFullName() + " attempted to register an invalid EventHandler method signature \"" + method.toGenericString() + "\" in " + listener.getClass());
                continue;
            }
            final Class<Event> eventClass = checkClass.asSubclass(Event.class);
            method.setAccessible(true);
            HashSet<RegisteredListener> eventSet = (HashSet<RegisteredListener>)ret.get(eventClass);
            if (eventSet == null) {
                eventSet = new HashSet<RegisteredListener>();
                ret.put(eventClass, eventSet);
            }
            Class<Event> clazz = eventClass;
            while (Event.class.isAssignableFrom(clazz)) {
                if (clazz.getAnnotation(Deprecated.class) != null) {
                    Warning warning = clazz.getAnnotation(Warning.class);
                    Warning.WarningState warningState = this.server.getWarningState();
                    if (!warningState.printFor(warning)) break;
                    plugin.getLogger().log(Level.WARNING, String.format("\"%s\" has registered a listener for %s on method \"%s\", but the event is Deprecated. \"%s\"; please notify the authors %s.", plugin.getDescription().getFullName(), clazz.getName(), method.toGenericString(), warning != null && warning.reason().length() != 0 ? warning.reason() : "Server performance will be affected", Arrays.toString(plugin.getDescription().getAuthors().toArray())), warningState == Warning.WarningState.ON ? new AuthorNagException(null) : null);
                    break;
                }
                clazz = clazz.getSuperclass();
            }
            final CustomTimingsHandler timings = new CustomTimingsHandler("Plugin: " + plugin.getDescription().getFullName() + " Event: " + listener.getClass().getName() + "::" + method.getName() + "(" + eventClass.getSimpleName() + ")", pluginParentTimer);
            EventExecutor executor = new EventExecutor(){

                @Override
                public void execute(Listener listener, Event event) throws EventException {
                    try {
                        if (!eventClass.isAssignableFrom(event.getClass())) {
                            return;
                        }
                        boolean isAsync = event.isAsynchronous();
                        if (!isAsync) {
                            timings.startTiming();
                        }
                        method.invoke((Object)listener, event);
                        if (!isAsync) {
                            timings.stopTiming();
                        }
                    }
                    catch (InvocationTargetException ex) {
                        throw new EventException(ex.getCause());
                    }
                    catch (Throwable t) {
                        throw new EventException(t);
                    }
                }
            };
            eventSet.add(new RegisteredListener(listener, executor, eh.priority(), plugin, eh.ignoreCancelled()));
        }
        return ret;
    }

    @Override
    public void enablePlugin(Plugin plugin) {
        Validate.isTrue((boolean)(plugin instanceof JavaPlugin), (String)"Plugin is not associated with this PluginLoader");
        if (!plugin.isEnabled()) {
            plugin.getLogger().info("Enabling " + plugin.getDescription().getFullName());
            JavaPlugin jPlugin = (JavaPlugin)plugin;
            String pluginName = jPlugin.getDescription().getName();
            if (!this.loaders0.containsKey(pluginName)) {
                this.loaders0.put(pluginName, (PluginClassLoader)jPlugin.getClassLoader());
            }
            try {
                jPlugin.setEnabled(true);
            }
            catch (Throwable ex) {
                this.server.getLogger().log(Level.SEVERE, "Error occurred while enabling " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
            }
            this.server.getPluginManager().callEvent(new PluginEnableEvent(plugin));
        }
    }

    @Override
    public void disablePlugin(Plugin plugin) {
        Validate.isTrue((boolean)(plugin instanceof JavaPlugin), (String)"Plugin is not associated with this PluginLoader");
        if (plugin.isEnabled()) {
            String message = String.format("Disabling %s", plugin.getDescription().getFullName());
            plugin.getLogger().info(message);
            this.server.getPluginManager().callEvent(new PluginDisableEvent(plugin));
            JavaPlugin jPlugin = (JavaPlugin)plugin;
            ClassLoader cloader = jPlugin.getClassLoader();
            try {
                jPlugin.setEnabled(false);
            }
            catch (Throwable ex) {
                this.server.getLogger().log(Level.SEVERE, "Error occurred while disabling " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
            }
            this.loaders0.remove(jPlugin.getDescription().getName());
            if (cloader instanceof PluginClassLoader) {
                PluginClassLoader loader = (PluginClassLoader)cloader;
                Set<String> names = loader.extended ? loader.getClasses() : loader.getClasses0();
                for (String name : names) {
                    if (this.extended) {
                        this.removeClass(name);
                        continue;
                    }
                    this.removeClass0(name);
                }
            }
        }
    }

    public InheritanceMap getGlobalInheritanceMap() {
        if (this.globalInheritanceMap == null) {
            HashMap<String, String> relocationsCurrent = new HashMap<String, String>();
            relocationsCurrent.put("net.minecraft.server", "net.minecraft.server." + PluginClassLoader.getNativeVersion());
            JarMapping currentMappings = new JarMapping();
            try {
                currentMappings.loadMappings(new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("mappings/" + PluginClassLoader.getNativeVersion() + "/cb2numpkg.srg"))), (MappingTransformer)new MavenShade(relocationsCurrent), null, false);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
            BiMap inverseClassMap = HashBiMap.create((Map)currentMappings.classes).inverse();
            this.globalInheritanceMap = new InheritanceMap();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("mappings/" + PluginClassLoader.getNativeVersion() + "/nms.inheritmap")));
            try {
                this.globalInheritanceMap.load(reader, inverseClassMap);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
            System.out.println("Loaded inheritance map of " + this.globalInheritanceMap.size() + " classes");
        }
        return this.globalInheritanceMap;
    }
}

