/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common.blocks;

import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.common.util.Utils;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twistedgate.immersiveposts.common.IPOConfig;
import twistedgate.immersiveposts.common.IPOContent;
import twistedgate.immersiveposts.common.IPOTags;
import twistedgate.immersiveposts.common.blocks.GenericPostBlock;
import twistedgate.immersiveposts.common.blocks.HorizontalTrussBlock;
import twistedgate.immersiveposts.enums.EnumFlipState;
import twistedgate.immersiveposts.enums.EnumHTrussType;
import twistedgate.immersiveposts.enums.EnumPostMaterial;
import twistedgate.immersiveposts.enums.EnumPostType;

public class PostBlock
extends GenericPostBlock
implements IPostBlock,
IWaterLoggable {
    public static final RedstoneParticleData URAN_PARTICLE = new RedstoneParticleData(0.0f, 1.0f, 0.0f, 1.0f);
    public static final VoxelShape POST_SHAPE = VoxelShapes.func_197873_a((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
    public static final VoxelShape LPARM_NORTH_BOUNDS = VoxelShapes.func_197873_a((double)0.3125, (double)0.25, (double)0.0, (double)0.6875, (double)0.75, (double)0.3125);
    public static final VoxelShape LPARM_SOUTH_BOUNDS = VoxelShapes.func_197873_a((double)0.3125, (double)0.25, (double)0.6875, (double)0.6875, (double)0.75, (double)1.0);
    public static final VoxelShape LPARM_EAST_BOUNDS = VoxelShapes.func_197873_a((double)0.6875, (double)0.25, (double)0.3125, (double)1.0, (double)0.75, (double)0.6875);
    public static final VoxelShape LPARM_WEST_BOUNDS = VoxelShapes.func_197873_a((double)0.0, (double)0.25, (double)0.3125, (double)0.3125, (double)0.75, (double)0.6875);
    public static final BooleanProperty LPARM_NORTH = BooleanProperty.func_177716_a((String)"parm_north");
    public static final BooleanProperty LPARM_EAST = BooleanProperty.func_177716_a((String)"parm_east");
    public static final BooleanProperty LPARM_SOUTH = BooleanProperty.func_177716_a((String)"parm_south");
    public static final BooleanProperty LPARM_WEST = BooleanProperty.func_177716_a((String)"parm_west");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final EnumProperty<EnumPostType> TYPE = EnumProperty.func_177709_a((String)"type", EnumPostType.class);
    public static final EnumProperty<EnumFlipState> FLIPSTATE = EnumProperty.func_177709_a((String)"flipstate", EnumFlipState.class);
    private static final VoxelShape X_BOUNDS = VoxelShapes.func_197873_a((double)0.0, (double)0.34375, (double)0.3125, (double)1.0, (double)1.0, (double)0.6875);
    private static final VoxelShape Z_BOUNDS = VoxelShapes.func_197873_a((double)0.3125, (double)0.34375, (double)0.0, (double)0.6875, (double)1.0, (double)1.0);
    private static final Byte2ObjectMap<VoxelShape> armMap = new Byte2ObjectArrayMap();
    private static final Byte2ObjectMap<VoxelShape> defaultMap = new Byte2ObjectArrayMap();

    public PostBlock(EnumPostMaterial postMaterial) {
        super(postMaterial);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(FLIPSTATE, (Comparable)((Object)EnumFlipState.UP))).func_206870_a(TYPE, (Comparable)((Object)EnumPostType.POST_TOP))).func_206870_a((Property)LPARM_NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LPARM_EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LPARM_SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LPARM_WEST, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED, FACING, FLIPSTATE, TYPE, LPARM_NORTH, LPARM_EAST, LPARM_SOUTH, LPARM_WEST});
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0;
    }

    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) == false;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        FluidState fs = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fs.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (((EnumPostType)((Object)state.func_177229_b(TYPE))).id() > 1) {
            return state;
        }
        boolean b0 = PostBlock.canConnect((IBlockReader)world, pos, Direction.NORTH);
        boolean b1 = PostBlock.canConnect((IBlockReader)world, pos, Direction.EAST);
        boolean b2 = PostBlock.canConnect((IBlockReader)world, pos, Direction.SOUTH);
        boolean b3 = PostBlock.canConnect((IBlockReader)world, pos, Direction.WEST);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)LPARM_NORTH, (Comparable)Boolean.valueOf(b0))).func_206870_a((Property)LPARM_EAST, (Comparable)Boolean.valueOf(b1))).func_206870_a((Property)LPARM_SOUTH, (Comparable)Boolean.valueOf(b2))).func_206870_a((Property)LPARM_WEST, (Comparable)Boolean.valueOf(b3));
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.postMaterial == EnumPostMaterial.URANIUM && stateIn.func_177229_b(TYPE) != EnumPostType.ARM && rand.nextFloat() < 0.125f) {
            double x = (double)pos.func_177958_n() + 0.375 + 0.25 * rand.nextDouble();
            double y = (double)pos.func_177956_o() + rand.nextDouble();
            double z = (double)pos.func_177952_p() + 0.375 + 0.25 * rand.nextDouble();
            worldIn.func_195594_a((IParticleData)URAN_PARTICLE, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.postMaterial.getItemStack();
    }

    public boolean canConnectTransformer(IBlockReader world, BlockPos pos) {
        return ((EnumPostType)((Object)world.func_180495_p(pos).func_177229_b(TYPE))).id() < 2;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult hit) {
        block36: {
            block38: {
                ItemStack held;
                block37: {
                    if (worldIn.field_72995_K) break block36;
                    held = playerIn.func_184614_ca();
                    if (!EnumPostMaterial.isValidItem(held)) break block37;
                    if (!held.func_77969_a(this.postMaterial.getItemStack())) {
                        playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("immersiveposts.expectedlocal", new Object[]{this.postMaterial.getItemStack().func_200301_q()}), true);
                        return ActionResultType.SUCCESS;
                    }
                    for (int y = 0; y <= worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE, pos.func_177958_n(), pos.func_177952_p()) - pos.func_177956_o(); ++y) {
                        BlockPos nPos = pos.func_177982_a(0, y, 0);
                        BlockState nState = worldIn.func_180495_p(nPos);
                        if (nState.func_177230_c() instanceof PostBlock) {
                            EnumPostType type = (EnumPostType)((Object)nState.func_177229_b(TYPE));
                            if (type != EnumPostType.POST && type != EnumPostType.POST_TOP && nState.func_177229_b(FLIPSTATE) == EnumFlipState.DOWN) {
                                return ActionResultType.SUCCESS;
                            }
                            nState = worldIn.func_180495_p(nPos.func_177972_a(Direction.UP));
                            if (nState.func_177230_c() instanceof PostBlock && (type = (EnumPostType)((Object)nState.func_177229_b(TYPE))) != EnumPostType.POST && type != EnumPostType.POST_TOP) {
                                return ActionResultType.SUCCESS;
                            }
                        }
                        if (worldIn.func_175623_d(nPos) || worldIn.func_180495_p(nPos).func_177230_c() == Blocks.field_150355_j) {
                            BlockState fb = (BlockState)EnumPostMaterial.getPostState(held).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.func_180495_p(nPos).func_177230_c() == Blocks.field_150355_j));
                            if (fb != null && !playerIn.func_233580_cy_().equals((Object)nPos) && worldIn.func_175656_a(nPos, fb) && !playerIn.func_184812_l_()) {
                                held.func_190918_g(1);
                            }
                            return ActionResultType.SUCCESS;
                        }
                        if (worldIn.func_180495_p(nPos).func_177230_c() instanceof PostBlock) continue;
                        return ActionResultType.SUCCESS;
                    }
                    break block36;
                }
                if (!Utils.isHammer((ItemStack)held)) break block36;
                if (!playerIn.func_225608_bj_()) break block38;
                switch ((EnumPostType)((Object)state.func_177229_b(TYPE))) {
                    case POST: 
                    case POST_TOP: {
                        BlockState nState;
                        BlockPos nPos;
                        int size;
                        Direction facing = hit.func_216354_b();
                        if (!Direction.Plane.HORIZONTAL.test(facing)) break;
                        BlockPos p = pos.func_177972_a(facing);
                        BlockState hstate = worldIn.func_180495_p(p);
                        if (hstate.func_177230_c() instanceof HorizontalTrussBlock) {
                            this.replaceSelf(hstate, worldIn, p);
                            return ActionResultType.SUCCESS;
                        }
                        boolean success = false;
                        for (size = 0; size <= (Integer)IPOConfig.MAIN.maxTrussLength.get(); ++size) {
                            nPos = pos.func_177967_a(facing, size + 1);
                            nState = worldIn.func_180495_p(nPos);
                            if (nState.func_177230_c().isAir(nState, (IBlockReader)worldIn, nPos)) continue;
                            if (nState.func_177230_c() instanceof HorizontalTrussBlock) {
                                return ActionResultType.FAIL;
                            }
                            if (nState.func_177230_c() instanceof PostBlock && ((EnumPostType)((Object)nState.func_177229_b(TYPE))).id() <= 1) {
                                if (this.getPostMaterial() != ((PostBlock)nState.func_177230_c()).getPostMaterial()) {
                                    playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("immersiveposts.truss_notsametype"), true);
                                    return ActionResultType.FAIL;
                                }
                                success = true;
                                break;
                            }
                            if (nState.func_177230_c() != Blocks.field_150355_j) break;
                        }
                        if (success && size >= 1) {
                            if (size == 1) {
                                nPos = pos.func_177972_a(facing);
                                nState = worldIn.func_180495_p(nPos);
                                BlockState hState = (BlockState)((BlockState)IPOContent.Blocks.HorizontalTruss.get(this.getPostMaterial()).func_176223_P().func_206870_a((Property)HorizontalTrussBlock.FACING, (Comparable)facing)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(nState.func_177230_c() == Blocks.field_150355_j));
                                worldIn.func_175656_a(nPos, hState.func_196956_a(null, null, (IWorld)worldIn, nPos, null));
                            } else {
                                for (int i = 0; i < size; ++i) {
                                    BlockPos nPos2 = pos.func_177967_a(facing, i + 1);
                                    BlockState nState2 = worldIn.func_180495_p(nPos2);
                                    BlockState hState = (BlockState)((BlockState)IPOContent.Blocks.HorizontalTruss.get(this.getPostMaterial()).func_176223_P().func_206870_a((Property)HorizontalTrussBlock.FACING, (Comparable)facing)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(nState2.func_177230_c() == Blocks.field_150355_j));
                                    hState = i == 0 ? (BlockState)hState.func_206870_a(HorizontalTrussBlock.TYPE, (Comparable)((Object)EnumHTrussType.MULTI_A)) : (i == size - 1 ? (i % 2 == 0 ? (BlockState)hState.func_206870_a(HorizontalTrussBlock.TYPE, (Comparable)((Object)EnumHTrussType.MULTI_D_ODD)) : (BlockState)hState.func_206870_a(HorizontalTrussBlock.TYPE, (Comparable)((Object)EnumHTrussType.MULTI_D_EVEN))) : (i % 2 == 0 ? (BlockState)hState.func_206870_a(HorizontalTrussBlock.TYPE, (Comparable)((Object)EnumHTrussType.MULTI_C)) : (BlockState)hState.func_206870_a(HorizontalTrussBlock.TYPE, (Comparable)((Object)EnumHTrussType.MULTI_B))));
                                    worldIn.func_175656_a(nPos2, hState.func_196956_a(null, null, (IWorld)worldIn, nPos2, null));
                                }
                            }
                            return ActionResultType.SUCCESS;
                        }
                        if (size == 0) {
                            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("immersiveposts.truss_minimumdistance"), true);
                            break;
                        }
                        if (!success && size >= 1) {
                            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("immersiveposts.truss_postnotfound"), true);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block36;
            }
            switch ((EnumPostType)((Object)state.func_177229_b(TYPE))) {
                case POST: 
                case POST_TOP: {
                    Direction facing = hit.func_216354_b();
                    BlockState defaultState = (BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)EnumPostType.ARM));
                    switch (facing) {
                        case NORTH: 
                        case EAST: 
                        case SOUTH: 
                        case WEST: {
                            BlockPos nPos = pos.func_177972_a(facing);
                            BlockState nState = worldIn.func_180495_p(nPos);
                            if (nState.func_177230_c().isAir(nState, (IBlockReader)worldIn, nPos) || nState.func_177230_c() == Blocks.field_150355_j) {
                                defaultState = (BlockState)((BlockState)defaultState.func_206870_a((Property)FACING, (Comparable)facing)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(nState.func_177230_c() == Blocks.field_150355_j));
                                worldIn.func_175656_a(nPos, defaultState);
                                defaultState.func_215697_a(worldIn, nPos, (Block)this, null, false);
                                break;
                            }
                            if (PostBlock.getBlockFrom((IBlockReader)worldIn, nPos) != this) break;
                            switch ((EnumPostType)((Object)nState.func_177229_b(TYPE))) {
                                case ARM: 
                                case EMPTY: {
                                    this.replaceSelf(nState, worldIn, nPos);
                                    return ActionResultType.SUCCESS;
                                }
                            }
                        }
                    }
                    return ActionResultType.SUCCESS;
                }
                case ARM: {
                    Direction bfacing = (Direction)state.func_177229_b((Property)FACING);
                    BlockPos offset = pos.func_177972_a(bfacing);
                    if (worldIn.func_175623_d(offset) || worldIn.func_180495_p(offset).func_177230_c() == Blocks.field_150355_j) {
                        worldIn.func_175656_a(offset, (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)((Object)EnumPostType.ARM_DOUBLE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.func_180495_p(offset).func_177230_c() == Blocks.field_150355_j)));
                        worldIn.func_175656_a(pos, (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)EnumPostType.EMPTY)));
                    }
                    return ActionResultType.SUCCESS;
                }
                case ARM_DOUBLE: {
                    Direction bfacing = (Direction)state.func_177229_b((Property)FACING);
                    this.replaceSelf(state, worldIn, pos);
                    worldIn.func_175656_a(pos.func_177972_a(bfacing.func_176734_d()), (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)EnumPostType.ARM)));
                    return ActionResultType.SUCCESS;
                }
                case EMPTY: {
                    Direction bfacing = (Direction)state.func_177229_b((Property)FACING);
                    worldIn.func_175656_a(pos, (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)EnumPostType.ARM)));
                    this.replaceSelf(state, worldIn, pos.func_177972_a(bfacing));
                    return ActionResultType.SUCCESS;
                }
            }
        }
        if (Utils.isHammer((ItemStack)playerIn.func_184614_ca()) || EnumPostMaterial.isValidItem(playerIn.func_184614_ca())) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (world.field_72995_K) {
            return;
        }
        this.updateState(state, world, pos);
    }

    private void updateState(BlockState stateIn, World world, BlockPos pos) {
        BlockState state;
        EnumPostType thisType = (EnumPostType)((Object)stateIn.func_177229_b(TYPE));
        if (thisType.id() <= 1 && ((state = world.func_180495_p(pos.func_177972_a(Direction.DOWN))).func_177230_c() == Blocks.field_150350_a || state.func_177230_c() == Blocks.field_150355_j)) {
            Block.func_220075_c((BlockState)stateIn, (World)world, (BlockPos)pos);
            this.replaceSelf(stateIn, world, pos);
            return;
        }
        BlockState aboveState = world.func_180495_p(pos.func_177972_a(Direction.UP));
        Block aboveBlock = aboveState.func_177230_c();
        switch (thisType) {
            case POST: {
                if (!(aboveBlock instanceof PostBlock)) {
                    world.func_175656_a(pos, (BlockState)stateIn.func_206870_a(TYPE, (Comparable)((Object)EnumPostType.POST_TOP)));
                }
                return;
            }
            case POST_TOP: {
                if (aboveBlock instanceof PostBlock && aboveState.func_177229_b(TYPE) == EnumPostType.POST_TOP) {
                    world.func_175656_a(pos, (BlockState)stateIn.func_206870_a(TYPE, (Comparable)((Object)EnumPostType.POST)));
                }
                return;
            }
            case ARM: {
                Direction f = ((Direction)stateIn.func_177229_b((Property)FACING)).func_176734_d();
                BlockState state2 = world.func_180495_p(pos.func_177972_a(f));
                if (state2 != null && !(state2.func_177230_c() instanceof PostBlock)) {
                    this.replaceSelf(stateIn, world, pos);
                } else {
                    world.func_175656_a(pos, (BlockState)stateIn.func_206870_a(FLIPSTATE, (Comparable)((Object)this.getFlipState((IBlockReader)world, pos))));
                }
                return;
            }
            case ARM_DOUBLE: {
                Direction f = ((Direction)stateIn.func_177229_b((Property)FACING)).func_176734_d();
                BlockState state3 = world.func_180495_p(pos.func_177972_a(f));
                if (state3 != null && !(state3.func_177230_c() instanceof PostBlock)) {
                    this.replaceSelf(stateIn, world, pos);
                }
                return;
            }
            case EMPTY: {
                BlockState state4 = world.func_180495_p(pos.func_177972_a(((Direction)stateIn.func_177229_b((Property)FACING)).func_176734_d()));
                if (state4 != null && !(state4.func_177230_c() instanceof PostBlock)) {
                    this.replaceSelf(stateIn, world, pos);
                    return;
                }
                state4 = world.func_180495_p(pos.func_177972_a((Direction)stateIn.func_177229_b((Property)FACING)));
                if (state4.func_177230_c() != Blocks.field_150350_a && state4.func_177230_c() != Blocks.field_150355_j) break;
                this.replaceSelf(stateIn, world, pos);
            }
        }
    }

    private EnumFlipState getFlipState(IBlockReader world, BlockPos pos) {
        boolean down;
        BlockState aboveState = world.func_180495_p(pos.func_177972_a(Direction.UP));
        BlockState belowState = world.func_180495_p(pos.func_177972_a(Direction.DOWN));
        Block aboveBlock = aboveState.func_177230_c();
        Block belowBlock = belowState.func_177230_c();
        boolean up = PostBlock.canConnect(world, pos, Direction.UP) && (!(aboveBlock instanceof PostBlock) || aboveState.func_177229_b(TYPE) != EnumPostType.ARM);
        boolean bl = down = PostBlock.canConnect(world, pos, Direction.DOWN) && (!(belowBlock instanceof PostBlock) || belowState.func_177229_b(TYPE) != EnumPostType.ARM);
        EnumFlipState flipState = up && down ? EnumFlipState.BOTH : (down ? EnumFlipState.DOWN : EnumFlipState.UP);
        return flipState;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return PostBlock.stateBounds(state);
    }

    private static VoxelShape stateBounds(BlockState state) {
        EnumPostType type = (EnumPostType)((Object)state.func_177229_b(TYPE));
        switch (type) {
            case ARM: 
            case ARM_DOUBLE: {
                Direction dir = (Direction)state.func_177229_b((Property)FACING);
                EnumFlipState flipstate = (EnumFlipState)((Object)state.func_177229_b(FLIPSTATE));
                byte bid = 0;
                switch (flipstate) {
                    case UP: {
                        bid = 16;
                        break;
                    }
                    case DOWN: {
                        bid = 32;
                        break;
                    }
                    case BOTH: {
                        bid = 48;
                    }
                }
                switch (dir) {
                    case WEST: {
                        bid = (byte)(bid | 8);
                        break;
                    }
                    case SOUTH: {
                        bid = (byte)(bid | 4);
                        break;
                    }
                    case EAST: {
                        bid = (byte)(bid | 2);
                        break;
                    }
                    default: {
                        bid = (byte)(bid | 1);
                    }
                }
                if (!armMap.containsKey(bid)) {
                    double minY = 0.0;
                    double maxY = 1.0;
                    switch (flipstate) {
                        case UP: {
                            minY = 0.34375;
                            maxY = 1.0;
                            break;
                        }
                        case DOWN: {
                            minY = 0.0;
                            maxY = 0.65625;
                            break;
                        }
                        case BOTH: {
                            minY = 0.0;
                            maxY = 1.0;
                        }
                    }
                    double minX = dir == Direction.EAST ? 0.0 : 0.3125;
                    double maxX = dir == Direction.WEST ? 1.0 : 0.6875;
                    double minZ = dir == Direction.SOUTH ? 0.0 : 0.3125;
                    double maxZ = dir == Direction.NORTH ? 1.0 : 0.6875;
                    VoxelShape shape = VoxelShapes.func_197873_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
                    armMap.put(bid, (Object)shape);
                    return shape;
                }
                return (VoxelShape)armMap.get(bid);
            }
            case EMPTY: {
                if (((Direction)state.func_177229_b((Property)FACING)).func_176740_k() == Direction.Axis.X) {
                    return X_BOUNDS;
                }
                return Z_BOUNDS;
            }
        }
        byte bid = 0;
        if (((Boolean)state.func_177229_b((Property)LPARM_NORTH)).booleanValue()) {
            bid = (byte)(bid | 1);
        }
        if (((Boolean)state.func_177229_b((Property)LPARM_SOUTH)).booleanValue()) {
            bid = (byte)(bid | 2);
        }
        if (((Boolean)state.func_177229_b((Property)LPARM_EAST)).booleanValue()) {
            bid = (byte)(bid | 4);
        }
        if (((Boolean)state.func_177229_b((Property)LPARM_WEST)).booleanValue()) {
            bid = (byte)(bid | 8);
        }
        if (!defaultMap.containsKey(bid)) {
            VoxelShape shape = POST_SHAPE;
            if (((Boolean)state.func_177229_b((Property)LPARM_NORTH)).booleanValue()) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)LPARM_NORTH_BOUNDS, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (((Boolean)state.func_177229_b((Property)LPARM_SOUTH)).booleanValue()) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)LPARM_SOUTH_BOUNDS, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (((Boolean)state.func_177229_b((Property)LPARM_EAST)).booleanValue()) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)LPARM_EAST_BOUNDS, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (((Boolean)state.func_177229_b((Property)LPARM_WEST)).booleanValue()) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)LPARM_WEST_BOUNDS, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            shape = shape.func_197753_c();
            defaultMap.put(bid, (Object)shape);
            return shape;
        }
        return (VoxelShape)defaultMap.get(bid);
    }

    public static boolean canConnect(IBlockReader worldIn, BlockPos posIn, Direction facingIn) {
        BlockPos nPos = posIn.func_177972_a(facingIn);
        BlockState otherState = worldIn.func_180495_p(nPos);
        Block otherBlock = otherState.func_177230_c();
        if (otherBlock == Blocks.field_150350_a || otherBlock.isAir(otherState, worldIn, nPos)) {
            return false;
        }
        if (otherBlock instanceof FourWayBlock || otherBlock instanceof PostBlock || otherBlock instanceof HorizontalTrussBlock) {
            return false;
        }
        if (IPOTags.IGNORED_BY_POSTARM.func_230235_a_((Object)otherBlock)) {
            return false;
        }
        VoxelShape shape = otherState.func_196954_c(worldIn, nPos);
        if (!shape.func_197766_b()) {
            boolean b;
            AxisAlignedBB box = shape.func_197752_a();
            switch (facingIn) {
                case UP: {
                    return MathHelper.func_219806_b((double)0.0, (double)box.field_72338_b);
                }
                case DOWN: {
                    boolean bool = otherBlock instanceof PostBlock;
                    return !bool && MathHelper.func_219806_b((double)1.0, (double)box.field_72337_e);
                }
                case NORTH: {
                    b = MathHelper.func_219806_b((double)1.0, (double)box.field_72334_f);
                    break;
                }
                case SOUTH: {
                    b = MathHelper.func_219806_b((double)0.0, (double)box.field_72339_c);
                    break;
                }
                case WEST: {
                    b = MathHelper.func_219806_b((double)1.0, (double)box.field_72336_d);
                    break;
                }
                case EAST: {
                    b = MathHelper.func_219806_b((double)0.0, (double)box.field_72340_a);
                    break;
                }
                default: {
                    b = false;
                }
            }
            if (b) {
                if (facingIn == Direction.SOUTH || facingIn == Direction.NORTH) {
                    AxisAlignedBB arm = LPARM_SOUTH_BOUNDS.func_197752_a();
                    if ((box.field_72340_a > 0.0 && box.field_72336_d < 1.0 || box.field_72338_b > 0.0 && box.field_72337_e < 1.0) && box.field_72340_a <= arm.field_72340_a && box.field_72336_d >= arm.field_72336_d && box.field_72338_b <= arm.field_72338_b && box.field_72337_e >= arm.field_72337_e) {
                        return true;
                    }
                } else if (facingIn == Direction.EAST || facingIn == Direction.WEST) {
                    AxisAlignedBB arm = LPARM_EAST_BOUNDS.func_197752_a();
                    if ((box.field_72339_c > 0.0 && box.field_72334_f < 1.0 || box.field_72338_b > 0.0 && box.field_72337_e < 1.0) && box.field_72339_c <= arm.field_72339_c && box.field_72334_f >= arm.field_72334_f && box.field_72338_b <= arm.field_72338_b && box.field_72337_e >= arm.field_72337_e) {
                        return true;
                    }
                }
                if (facingIn.func_176740_k() == Direction.Axis.Z && box.field_72340_a > 0.0 && box.field_72336_d < 1.0) {
                    return true;
                }
                if (facingIn.func_176740_k() == Direction.Axis.X && box.field_72339_c > 0.0 && box.field_72334_f < 1.0) {
                    return true;
                }
            }
        }
        return false;
    }
}

