/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.enums;

import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;
import twistedgate.immersiveposts.common.IPOConfig;
import twistedgate.immersiveposts.common.IPOContent;
import twistedgate.immersiveposts.common.blocks.PostBlock;
import twistedgate.immersiveposts.enums.EnumPostType;

public enum EnumPostMaterial implements IStringSerializable
{
    WOOD("woodpost", () -> IEBlocks.WoodenDecoration.treatedFence),
    ALUMINIUM("aluminiumpost", () -> IEBlocks.MetalDecoration.aluFence),
    STEEL("steelpost", () -> IEBlocks.MetalDecoration.steelFence),
    NETHERBRICK("netherpost", Blocks.field_150386_bk),
    IRON("ironpost", (Block)IPOContent.Blocks.Fences.iron),
    GOLD("goldpost", (Block)IPOContent.Blocks.Fences.gold),
    COPPER("copperpost", (Block)IPOContent.Blocks.Fences.copper),
    LEAD("leadpost", (Block)IPOContent.Blocks.Fences.lead),
    SILVER("silverpost", (Block)IPOContent.Blocks.Fences.silver),
    NICKEL("nickelpost", (Block)IPOContent.Blocks.Fences.nickel),
    CONSTANTAN("constantanpost", (Block)IPOContent.Blocks.Fences.constantan),
    ELECTRUM("electrumpost", (Block)IPOContent.Blocks.Fences.electrum),
    URANIUM("uraniumpost", (Block)IPOContent.Blocks.Fences.uranium),
    CONCRETE("concretepost", () -> (Block)IEBlocks.toSlab.get(IEBlocks.StoneDecoration.concrete)),
    CONCRETE_LEADED("leadedconcretepost", () -> (Block)IEBlocks.toSlab.get(IEBlocks.StoneDecoration.concreteLeaded));

    private String name;
    private Block block;
    private Supplier<Block> supplier;
    private boolean isFence;
    private AbstractBlock.Properties props;
    private static final Material WOOD_LIKE;
    private static final Material STONE_LIKE;
    private static final Material METAL_LIKE;

    private EnumPostMaterial(String name, Block block) {
        this.name = name;
        this.block = block;
        this.isFence = block instanceof FenceBlock;
    }

    private EnumPostMaterial(String name, Supplier<Block> supplier) {
        this.name = name;
        this.supplier = supplier;
    }

    public ItemStack getItemStack() {
        Block block = this.getBlock();
        return block == null ? ItemStack.field_190927_a : new ItemStack((IItemProvider)block);
    }

    public ResourceLocation getTexture() {
        return new ResourceLocation("immersiveposts", "block/posts/post_" + this.toString().toLowerCase());
    }

    public Block getBlock() {
        if (this.block == null) {
            this.block = this.supplier.get();
            this.isFence = this.block != null && this.block instanceof FenceBlock;
        }
        return this.block;
    }

    public boolean isFence() {
        return this.isFence;
    }

    public String func_176610_l() {
        return this.name;
    }

    public AbstractBlock.Properties getProperties() {
        if (this.props == null) {
            this.props = EnumPostMaterial.blockPropertiesFrom(this);
        }
        return this.props;
    }

    public static AbstractBlock.Properties blockPropertiesFrom(EnumPostMaterial postMaterial) {
        AbstractBlock.Properties prop = null;
        switch (postMaterial) {
            case WOOD: {
                prop = AbstractBlock.Properties.func_200945_a((Material)WOOD_LIKE).func_200947_a(SoundType.field_185848_a).harvestTool(ToolType.AXE).func_200948_a(2.0f, 5.0f).func_226896_b_().func_235847_c_((s, r, p) -> false);
                break;
            }
            case NETHERBRICK: 
            case CONCRETE: 
            case CONCRETE_LEADED: {
                prop = AbstractBlock.Properties.func_200945_a((Material)STONE_LIKE).func_200947_a(SoundType.field_185851_d).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200948_a(1.5f, 6.0f).func_226896_b_().func_235847_c_((s, r, p) -> false);
                break;
            }
            default: {
                prop = AbstractBlock.Properties.func_200945_a((Material)METAL_LIKE).func_200947_a(SoundType.field_185852_e).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200948_a(3.0f, 15.0f).func_226896_b_().func_235847_c_((s, r, p) -> false);
                if (postMaterial != URANIUM) break;
                prop.func_235838_a_(s -> 8);
            }
        }
        return prop;
    }

    public static BlockState getPostState(ItemStack stack) {
        EnumPostMaterial mat = EnumPostMaterial.getFrom(stack);
        if (mat != null) {
            PostBlock block = IPOContent.Blocks.Posts.get(mat);
            return (BlockState)block.func_176223_P().func_206870_a(PostBlock.TYPE, (Comparable)((Object)EnumPostType.POST_TOP));
        }
        return null;
    }

    public static EnumPostMaterial getFrom(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return null;
        }
        for (EnumPostMaterial mat : EnumPostMaterial.values()) {
            if (!stack.func_77969_a(mat.getItemStack())) continue;
            return mat;
        }
        return null;
    }

    public static boolean isValidItem(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        for (EnumPostMaterial mat : EnumPostMaterial.values()) {
            if (mat.getItemStack() == ItemStack.field_190927_a || !stack.func_77969_a(mat.getItemStack()) || !IPOConfig.MAIN.isEnabled(mat)) continue;
            return true;
        }
        return false;
    }

    private static Material material(MaterialColor color, boolean isLiquid, boolean isSolid, boolean blocksMovement, boolean isOpaque, boolean flammable, boolean replaceable, PushReaction pushReaction) {
        return new Material(color, isLiquid, isSolid, blocksMovement, isOpaque, flammable, replaceable, pushReaction);
    }

    static {
        WOOD_LIKE = EnumPostMaterial.material(MaterialColor.field_151663_o, false, true, true, true, false, false, PushReaction.BLOCK);
        STONE_LIKE = EnumPostMaterial.material(MaterialColor.field_151665_m, false, true, true, true, false, false, PushReaction.BLOCK);
        METAL_LIKE = EnumPostMaterial.material(MaterialColor.field_151668_h, false, true, true, true, false, false, PushReaction.BLOCK);
    }
}

