/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.util.IOrientable;
import appeng.block.AEBaseBlock;
import appeng.block.networking.CableBusBlock;
import appeng.tile.AEBaseInvTileEntity;
import appeng.tile.AEBaseTileEntity;
import appeng.tile.networking.CableBusTileEntity;
import appeng.tile.storage.SkyChestTileEntity;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class AEBaseTileBlock<T extends AEBaseTileEntity>
extends AEBaseBlock {
    @Nonnull
    private Class<T> tileEntityClass;
    @Nonnull
    private Supplier<T> tileEntityFactory;

    public AEBaseTileBlock(AbstractBlock.Properties props) {
        super(props);
    }

    public void setTileEntity(Class<T> tileEntityClass, Supplier<T> factory) {
        this.tileEntityClass = tileEntityClass;
        this.tileEntityFactory = factory;
        this.setInventory(AEBaseInvTileEntity.class.isAssignableFrom(tileEntityClass));
    }

    public boolean hasTileEntity(BlockState state) {
        return this.hasBlockTileEntity();
    }

    private boolean hasBlockTileEntity() {
        return true;
    }

    public Class<T> getTileEntityClass() {
        return this.tileEntityClass;
    }

    @Nullable
    public T getTileEntity(IBlockReader w, int x, int y, int z) {
        return this.getTileEntity(w, new BlockPos(x, y, z));
    }

    @Nullable
    public T getTileEntity(IBlockReader w, BlockPos pos) {
        if (!this.hasBlockTileEntity()) {
            return null;
        }
        TileEntity te = w.func_175625_s(pos);
        if (this.tileEntityClass != null && this.tileEntityClass.isInstance(te)) {
            return (T)((AEBaseTileEntity)this.tileEntityClass.cast(te));
        }
        return null;
    }

    public final TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return (TileEntity)this.tileEntityFactory.get();
    }

    public void func_196243_a(BlockState state, World w, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() == state.func_177230_c()) {
            return;
        }
        T te = this.getTileEntity((IBlockReader)w, pos);
        if (te != null) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            if (((AEBaseTileEntity)te).dropItems()) {
                ((AEBaseTileEntity)te).getDrops(w, pos, drops);
            } else {
                ((AEBaseTileEntity)te).getNoDrops(w, pos, drops);
            }
            Platform.spawnDrops(w, pos, drops);
        }
        super.func_196243_a(state, w, pos, newState, isMoving);
    }

    @Override
    public int func_180641_l(BlockState state, World w, BlockPos pos) {
        AEBaseInvTileEntity invTile;
        T te = this.getTileEntity((IBlockReader)w, pos);
        if (te instanceof AEBaseInvTileEntity && (invTile = (AEBaseInvTileEntity)te).getInternalInventory().getSlots() > 0) {
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)invTile.getInternalInventory());
        }
        return 0;
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int eventID, int eventParam) {
        super.func_189539_a(state, worldIn, pos, eventID, eventParam);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null ? tileentity.func_145842_c(eventID, eventParam) : false;
    }

    public void func_180633_a(World w, BlockPos pos, BlockState state, LivingEntity placer, ItemStack is) {
        T te = this.getTileEntity((IBlockReader)w, pos);
        if (te == null) {
            return;
        }
        ITextComponent displayName = is.func_200301_q();
        if (displayName instanceof StringTextComponent) {
            ((AEBaseTileEntity)te).setName(((StringTextComponent)displayName).func_150265_g());
        }
        if (is.func_77942_o()) {
            ((AEBaseTileEntity)te).uploadSettings(SettingsFrom.DISMANTLE_ITEM, is.func_77978_p());
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (player != null && !player.func_184586_b(hand).func_190926_b()) {
            ItemStack heldItem = player.func_184586_b(hand);
            if (InteractionUtil.isWrench(player, heldItem, pos) && InteractionUtil.isInAlternateUseMode(player)) {
                BlockState blockState = world.func_180495_p(pos);
                Block block = blockState.func_177230_c();
                T tile = this.getTileEntity((IBlockReader)world, pos);
                if (tile == null) {
                    return ActionResultType.FAIL;
                }
                if (tile instanceof CableBusTileEntity || tile instanceof SkyChestTileEntity) {
                    return ActionResultType.FAIL;
                }
                Object[] itemDropCandidates = Platform.getBlockDrops(world, pos);
                ItemStack op = new ItemStack((IItemProvider)this);
                for (ItemStack itemStack : itemDropCandidates) {
                    CompoundNBT tag;
                    if (!Platform.itemComparisons().isEqualItemType(itemStack, op) || (tag = ((AEBaseTileEntity)tile).downloadSettings(SettingsFrom.DISMANTLE_ITEM)) == null) continue;
                    itemStack.func_77982_d(tag);
                }
                if (block.removedByPlayer(blockState, world, pos, player, false, world.func_204610_c(pos))) {
                    ArrayList itemsToDrop = Lists.newArrayList((Object[])itemDropCandidates);
                    Platform.spawnDrops(world, pos, itemsToDrop);
                    world.func_217377_a(pos, false);
                }
                return ActionResultType.FAIL;
            }
            if (heldItem.func_77973_b() instanceof IMemoryCard && !(this instanceof CableBusBlock)) {
                IMemoryCard memoryCard = (IMemoryCard)heldItem.func_77973_b();
                T tileEntity = this.getTileEntity((IBlockReader)world, pos);
                if (tileEntity == null) {
                    return ActionResultType.FAIL;
                }
                String name = this.func_149739_a();
                if (InteractionUtil.isInAlternateUseMode(player)) {
                    CompoundNBT data = ((AEBaseTileEntity)tileEntity).downloadSettings(SettingsFrom.MEMORY_CARD);
                    if (data != null) {
                        memoryCard.setMemoryCardContents(heldItem, name, data);
                        memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
                    }
                } else {
                    String savedName = memoryCard.getSettingsName(heldItem);
                    CompoundNBT data = memoryCard.getData(heldItem);
                    if (this.func_149739_a().equals(savedName)) {
                        ((AEBaseTileEntity)tileEntity).uploadSettings(SettingsFrom.MEMORY_CARD, data);
                        memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                    } else {
                        memoryCard.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
                    }
                }
                return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
            }
        }
        return this.onActivated(world, pos, player, hand, player.func_184586_b(hand), hit);
    }

    public ActionResultType onActivated(World w, BlockPos pos, PlayerEntity player, Hand hand, @Nullable ItemStack heldItem, BlockRayTraceResult hit) {
        return ActionResultType.PASS;
    }

    @Override
    public IOrientable getOrientable(IBlockReader w, BlockPos pos) {
        return this.getTileEntity(w, pos);
    }

    public final BlockState getTileEntityBlockState(BlockState current, TileEntity te) {
        if (current.func_177230_c() != this || !this.tileEntityClass.isInstance(te)) {
            return current;
        }
        return this.updateBlockStateFromTileEntity(current, (AEBaseTileEntity)this.tileEntityClass.cast(te));
    }

    protected BlockState updateBlockStateFromTileEntity(BlockState currentState, T te) {
        return currentState;
    }
}

