/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseBlock;
import appeng.client.render.effects.ParticleTypes;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.helpers.AEMaterials;
import appeng.helpers.MetaRotation;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class QuartzFixtureBlock
extends AEBaseBlock
implements IOrientableBlock,
IWaterLoggable {
    private static final Map<Direction, VoxelShape> SHAPES = new EnumMap<Direction, VoxelShape>(Direction.class);
    public static final DirectionProperty FACING;
    public static final BooleanProperty ODD;
    public static final BooleanProperty WATERLOGGED;

    public QuartzFixtureBlock() {
        super(QuartzFixtureBlock.defaultProps(AEMaterials.FIXTURE).func_200942_a().func_226896_b_().func_200943_b(0.0f).func_235838_a_(b -> 14).func_200947_a(SoundType.field_185853_f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.UP)).func_206870_a((Property)ODD, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, ODD, WATERLOGGED});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction[] adirection;
        BlockState blockstate = super.func_196258_a(context);
        BlockPos pos = context.func_195995_a();
        FluidState fluidState = context.func_195991_k().func_204610_c(pos);
        boolean oddPlacement = (pos.func_177958_n() + pos.func_177956_o() + pos.func_177952_p()) % 2 != 0;
        blockstate = (BlockState)((BlockState)blockstate.func_206870_a((Property)ODD, (Comparable)Boolean.valueOf(oddPlacement))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
        World iworldreader = context.func_195991_k();
        for (Direction direction : adirection = context.func_196009_e()) {
            if (!this.canPlaceAt((IWorldReader)iworldreader, pos, direction)) continue;
            return (BlockState)blockstate.func_206870_a((Property)FACING, (Comparable)direction.func_176734_d());
        }
        return null;
    }

    public BlockState func_196271_a(BlockState blockState, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)blockState.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        Direction fixtureFacing = (Direction)blockState.func_177229_b((Property)FACING);
        if (facing.func_176734_d() == fixtureFacing && !this.canPlaceAt((IWorldReader)world, currentPos, facing)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return blockState;
    }

    @Override
    public boolean isValidOrientation(IWorld w, BlockPos pos, Direction forward, Direction up) {
        return this.canPlaceAt((IWorldReader)w, pos, up.func_176734_d());
    }

    private boolean canPlaceAt(IWorldReader w, BlockPos pos, Direction dir) {
        BlockPos test = pos.func_177972_a(dir);
        BlockState blockstate = w.func_180495_p(test);
        return blockstate.func_224755_d((IBlockReader)w, test, dir.func_176734_d());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        return SHAPES.get(facing);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World w, BlockPos pos, Random r) {
        if (!AEConfig.instance().isEnableEffects()) {
            return;
        }
        if ((double)r.nextFloat() < 0.98) {
            return;
        }
        Direction up = this.getOrientable((IBlockReader)w, pos).getUp();
        double xOff = -0.3 * (double)up.func_82601_c();
        double yOff = -0.3 * (double)up.func_96559_d();
        double zOff = -0.3 * (double)up.func_82599_e();
        for (int bolts = 0; bolts < 3; ++bolts) {
            if (!AppEng.proxy.shouldAddParticles(r)) continue;
            w.func_195594_a((IParticleData)ParticleTypes.LIGHTNING, xOff + 0.5 + (double)pos.func_177958_n(), yOff + 0.5 + (double)pos.func_177956_o(), zOff + 0.5 + (double)pos.func_177952_p(), 0.0, 0.0, 0.0);
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        Direction up = this.getOrientable((IBlockReader)world, pos).getUp();
        if (!this.canPlaceAt((IWorldReader)world, pos, up.func_176734_d())) {
            this.dropTorch(world, pos);
        }
    }

    private void dropTorch(World w, BlockPos pos) {
        BlockState prev = w.func_180495_p(pos);
        w.func_175655_b(pos, true);
        w.func_184138_a(pos, prev, w.func_180495_p(pos), 3);
    }

    public boolean func_196260_a(BlockState state, IWorldReader w, BlockPos pos) {
        for (Direction dir : Direction.values()) {
            if (!this.canPlaceAt(w, pos, dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IOrientable getOrientable(IBlockReader w, BlockPos pos) {
        return new MetaRotation(w, pos, (Property<Direction>)FACING);
    }

    public FluidState func_204507_t(BlockState blockState) {
        return (Boolean)blockState.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(blockState);
    }

    static {
        for (Direction facing : Direction.values()) {
            double xOff = -0.3 * (double)facing.func_82601_c();
            double yOff = -0.3 * (double)facing.func_96559_d();
            double zOff = -0.3 * (double)facing.func_82599_e();
            VoxelShape shape = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(xOff + 0.3, yOff + 0.3, zOff + 0.3, xOff + 0.7, yOff + 0.7, zOff + 0.7));
            SHAPES.put(facing, shape);
        }
        FACING = BlockStateProperties.field_208155_H;
        ODD = BooleanProperty.func_177716_a((String)"odd");
        WATERLOGGED = BlockStateProperties.field_208198_y;
    }
}

