/*
 * Decompiled with CFR 0.152.
 */
package appeng.bootstrap;

import appeng.api.features.AEFeature;
import appeng.block.AEBaseTileBlock;
import appeng.bootstrap.FeatureFactory;
import appeng.bootstrap.TileEntityRendering;
import appeng.bootstrap.TileEntityRenderingCustomizer;
import appeng.bootstrap.definitions.TileEntityDefinition;
import appeng.core.features.ActivityState;
import appeng.core.features.BlockStackSrc;
import appeng.tile.AEBaseTileEntity;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class TileEntityBuilder<T extends AEBaseTileEntity> {
    private final FeatureFactory factory;
    private final String registryName;
    private final Class<T> tileClass;
    private TileEntityType<T> type;
    private final Function<TileEntityType<T>, T> supplier;
    @OnlyIn(value=Dist.CLIENT)
    private TileEntityRendering<T> tileEntityRendering;
    private final List<Block> blocks = new ArrayList<Block>();
    private final EnumSet<AEFeature> features = EnumSet.noneOf(AEFeature.class);

    public TileEntityBuilder(FeatureFactory factory, String registryName, Class<T> tileClass, Function<TileEntityType<T>, T> supplier) {
        this.factory = factory;
        this.registryName = registryName;
        this.tileClass = tileClass;
        this.supplier = supplier;
        if (Platform.hasClientClasses()) {
            this.tileEntityRendering = new TileEntityRendering();
        }
    }

    public TileEntityBuilder<T> features(AEFeature ... features) {
        this.features.clear();
        this.addFeatures(features);
        return this;
    }

    public TileEntityBuilder<T> addFeatures(AEFeature ... features) {
        Collections.addAll(this.features, features);
        return this;
    }

    public TileEntityBuilder<T> rendering(TileEntityRenderingCustomizer<T> customizer) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> customizer.customize(this.tileEntityRendering));
        return this;
    }

    public TileEntityDefinition build() {
        this.factory.addBootstrapComponent(registry -> {
            if (this.blocks.isEmpty()) {
                throw new IllegalStateException("No blocks make use of this tile entity: " + this.tileClass);
            }
            Supplier<AEBaseTileEntity> factory = () -> (AEBaseTileEntity)this.supplier.apply(this.type);
            this.type = TileEntityType.Builder.func_223042_a(factory, (Block[])this.blocks.toArray(new Block[0])).func_206865_a(null);
            this.type.setRegistryName("appliedenergistics2", this.registryName);
            registry.register(this.type);
            AEBaseTileEntity.registerTileItem(this.tileClass, new BlockStackSrc(this.blocks.get(0), ActivityState.Enabled));
            for (Block block : this.blocks) {
                if (!(block instanceof AEBaseTileBlock)) continue;
                AEBaseTileBlock baseTileBlock = (AEBaseTileBlock)block;
                baseTileBlock.setTileEntity(this.tileClass, factory);
            }
        });
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::buildClient);
        return new TileEntityDefinition(this::addBlock);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void buildClient() {
        this.factory.addBootstrapComponent(() -> {
            if (this.tileEntityRendering.tileEntityRenderer != null) {
                ClientRegistry.bindTileEntityRenderer(this.type, this.tileEntityRendering.tileEntityRenderer);
            }
        });
    }

    private void addBlock(Block block) {
        Preconditions.checkState((this.type == null ? 1 : 0) != 0, (Object)"No more blocks can be added after registration completed.");
        this.blocks.add(block);
    }
}

