/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.AccessRestriction;
import appeng.api.config.ActionItems;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.Upgrades;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.container.implementations.StorageBusContainer;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class StorageBusScreen
extends UpgradeableScreen<StorageBusContainer> {
    private final SettingToggleButton<AccessRestriction> rwMode;
    private final SettingToggleButton<StorageFilter> storageFilter;
    private final SettingToggleButton<FuzzyMode> fuzzyMode;

    public StorageBusScreen(StorageBusContainer container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title, style);
        this.widgets.addOpenPriorityButton();
        this.addToLeftToolbar(new ActionButton(ActionItems.CLOSE, btn -> this.clear()));
        this.addToLeftToolbar(new ActionButton(ActionItems.WRENCH, btn -> this.partition()));
        this.rwMode = new ServerSettingToggleButton<AccessRestriction>(Settings.ACCESS, AccessRestriction.READ_WRITE);
        this.storageFilter = new ServerSettingToggleButton<StorageFilter>(Settings.STORAGE_FILTER, StorageFilter.EXTRACTABLE_ONLY);
        this.fuzzyMode = new ServerSettingToggleButton<FuzzyMode>(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.addToLeftToolbar(this.storageFilter);
        this.addToLeftToolbar(this.fuzzyMode);
        this.addToLeftToolbar(this.rwMode);
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.storageFilter.set(((StorageBusContainer)this.field_147002_h).getStorageFilter());
        this.rwMode.set(((StorageBusContainer)this.field_147002_h).getReadWriteMode());
        this.fuzzyMode.set(((StorageBusContainer)this.field_147002_h).getFuzzyMode());
        this.fuzzyMode.setVisibility(((StorageBusContainer)this.field_147002_h).hasUpgrade(Upgrades.FUZZY));
    }

    private void partition() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("StorageBus.Action", "Partition"));
    }

    private void clear() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("StorageBus.Action", "Clear"));
    }
}

