/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.items;

import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.me.common.Repo;
import appeng.client.gui.me.items.ItemSorters;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.util.text.ITextComponent;

public class ItemRepo
extends Repo<IAEItemStack> {
    public ItemRepo(IScrollSource src, ISortSource sortSrc) {
        super(src, sortSrc);
        this.setSynchronizeWithJEI(true);
    }

    @Override
    protected boolean matchesSearch(Repo.SearchMode searchMode, Pattern searchPattern, IAEItemStack stack) {
        if (searchMode == Repo.SearchMode.MOD) {
            String modId = Platform.getModId(stack);
            return searchPattern.matcher(modId).find();
        }
        AEItemStack aeStack = (AEItemStack)stack;
        String displayName = aeStack.getDisplayName().getString();
        if (searchPattern.matcher(displayName).find()) {
            return true;
        }
        if (searchMode == Repo.SearchMode.NAME_OR_TOOLTIP) {
            List<ITextComponent> tooltip = aeStack.getToolTip();
            for (ITextComponent line : tooltip) {
                if (!searchPattern.matcher(line.getString()).find()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected Comparator<? super IAEItemStack> getComparator(SortOrder sortBy, SortDir sortDir) {
        return ItemSorters.getComparator(sortBy, sortDir);
    }
}

