/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.networktool;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.CommonButtons;
import appeng.client.gui.widgets.Scrollbar;
import appeng.container.me.networktool.MachineGroup;
import appeng.container.me.networktool.NetworkStatus;
import appeng.container.me.networktool.NetworkStatusContainer;
import appeng.core.localization.GuiText;
import appeng.util.Platform;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class NetworkStatusScreen
extends AEBaseScreen<NetworkStatusContainer> {
    private static final int ROWS = 4;
    private static final int COLUMNS = 5;
    private static final int TABLE_X = 14;
    private static final int TABLE_Y = 41;
    private static final int CELL_WIDTH = 30;
    private static final int CELL_HEIGHT = 18;
    private NetworkStatus status = new NetworkStatus();
    private final Scrollbar scrollbar = this.widgets.addScrollBar("scrollbar");

    public NetworkStatusScreen(NetworkStatusContainer container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title, style);
        this.addToLeftToolbar(CommonButtons.togglePowerUnit());
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.setTextContent("stored_power", (ITextComponent)GuiText.StoredPower.text(Platform.formatPower(this.status.getStoredPower(), false)));
        this.setTextContent("max_power", (ITextComponent)GuiText.MaxPower.text(Platform.formatPower(this.status.getMaxStoredPower(), false)));
        this.setTextContent("power_input_rate", (ITextComponent)GuiText.PowerInputRate.text(Platform.formatPower(this.status.getAveragePowerInjection(), true)));
        this.setTextContent("power_usage_rate", (ITextComponent)GuiText.PowerUsageRate.text(Platform.formatPower(this.status.getAveragePowerUsage(), true)));
    }

    @Override
    public void drawFG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        int x = 0;
        int y = 0;
        int viewStart = this.scrollbar.getCurrentScroll() * 5;
        int viewEnd = viewStart + 20;
        ArrayList<Object> tooltip = null;
        List<MachineGroup> machines = this.status.getGroupedMachines();
        for (int i = viewStart; i < Math.min(viewEnd, machines.size()); ++i) {
            MachineGroup entry = machines.get(i);
            int cellX = 14 + x * 30;
            int cellY = 41 + y * 18;
            int itemX = cellX + 30 - 17;
            int itemY = cellY + 1;
            this.drawMachineCount(matrixStack, itemX, cellY, entry.getCount());
            this.drawItem(itemX, itemY, entry.getDisplay());
            if (this.func_195359_a(cellX, cellY, 30, 18, mouseX, mouseY)) {
                tooltip = new ArrayList<Object>();
                tooltip.add(entry.getDisplay().func_200301_q());
                tooltip.add(GuiText.Installed.text(entry.getCount()));
                if (entry.getIdlePowerUsage() > 0.0) {
                    tooltip.add(GuiText.EnergyDrain.text(Platform.formatPower(entry.getIdlePowerUsage(), true)));
                }
            }
            if (++x < 5) continue;
            ++y;
            x = 0;
        }
        if (tooltip != null) {
            this.drawTooltip(matrixStack, mouseX - offsetX, mouseY - offsetY, tooltip);
        }
    }

    private void drawMachineCount(MatrixStack matrixStack, int x, int y, long count) {
        String str = count >= 10000L ? Long.toString(count / 1000L) + 'k' : Long.toString(count);
        float textWidth = (float)this.field_230712_o_.func_78256_a(str) / 2.0f;
        this.field_230712_o_.getClass();
        float textHeight = 9.0f / 2.0f;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)((float)(x - 1) - textWidth), (double)((float)y + (18.0f - textHeight) / 2.0f), 0.0);
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        this.field_230712_o_.func_238421_b_(matrixStack, str, 0.0f, 0.0f, this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB());
        matrixStack.func_227865_b_();
    }

    public void processServerUpdate(NetworkStatus status) {
        this.status = status;
        this.setScrollBar();
    }

    private void setScrollBar() {
        int size = this.status.getGroupedMachines().size();
        int overflowRows = (size + 5 - 1) / 5 - 4;
        this.scrollbar.setRange(0, overflowRows, 1);
    }
}

