/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.tesr;

import appeng.block.storage.DriveSlotsState;
import appeng.client.render.BakedModelUnwrapper;
import appeng.client.render.DelegateBakedModel;
import appeng.client.render.FacingToRotation;
import appeng.client.render.model.DriveBakedModel;
import appeng.client.render.tesr.CellLedRenderer;
import appeng.core.Api;
import appeng.tile.storage.ChestTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class ChestTileEntityRenderer
extends TileEntityRenderer<ChestTileEntity> {
    private final ModelManager modelManager;
    private final BlockModelRenderer blockRenderer;

    public ChestTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        Minecraft client = Minecraft.func_71410_x();
        this.modelManager = client.func_209506_al();
        this.blockRenderer = client.func_175602_ab().func_175019_b();
    }

    public void render(ChestTileEntity chest, float partialTicks, MatrixStack matrices, IRenderTypeBuffer buffers, int combinedLight, int combinedOverlay) {
        World world = chest.func_145831_w();
        if (world == null) {
            return;
        }
        DriveSlotsState driveSlotState = DriveSlotsState.fromChestOrDrive(chest);
        Item cellItem = driveSlotState.getCell(0);
        if (cellItem == null || cellItem == Items.field_190931_a) {
            return;
        }
        DriveBakedModel driveModel = this.getDriveModel();
        if (driveModel == null) {
            return;
        }
        IBakedModel cellModel = driveModel.getCellChassisModel(cellItem);
        matrices.func_227860_a_();
        matrices.func_227861_a_(0.5, 0.5, 0.5);
        FacingToRotation rotation = FacingToRotation.get(chest.getForward(), chest.getUp());
        rotation.push(matrices);
        matrices.func_227861_a_(-0.5, -0.5, -0.5);
        matrices.func_227861_a_(0.3125, 0.25, 0.0);
        IVertexBuilder buffer = buffers.getBuffer(RenderType.func_228643_e_());
        FaceRotatingModel rotatedModel = new FaceRotatingModel(cellModel, rotation);
        this.blockRenderer.renderModel((IBlockDisplayReader)world, (IBakedModel)rotatedModel, chest.func_195044_w(), chest.func_174877_v(), matrices, buffer, false, new Random(), 0L, combinedOverlay, (IModelData)EmptyModelData.INSTANCE);
        IVertexBuilder ledBuffer = buffers.getBuffer(CellLedRenderer.RENDER_LAYER);
        CellLedRenderer.renderLed(chest, 0, ledBuffer, matrices, partialTicks);
        matrices.func_227865_b_();
    }

    private DriveBakedModel getDriveModel() {
        IBakedModel driveModel = this.modelManager.func_174954_c().func_178125_b(Api.instance().definitions().blocks().drive().block().func_176223_P());
        return BakedModelUnwrapper.unwrap(driveModel, DriveBakedModel.class);
    }

    private static class FaceRotatingModel
    extends DelegateBakedModel {
        private final FacingToRotation r;

        protected FaceRotatingModel(IBakedModel base, FacingToRotation r) {
            super(base);
            this.r = r;
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            if (side != null) {
                side = this.r.resultingRotate(side);
            }
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(super.getQuads(state, side, rand, extraData));
            for (int i = 0; i < quads.size(); ++i) {
                BakedQuad quad = (BakedQuad)quads.get(i);
                quads.set(i, new BakedQuad(quad.func_178209_a(), quad.func_178211_c(), this.r.rotate(quad.func_178210_d()), quad.func_187508_a(), quad.func_239287_f_()));
            }
            return quads;
        }
    }
}

