/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InterfaceTerminalPacket;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.InventoryAction;
import appeng.items.misc.EncodedPatternItem;
import appeng.parts.misc.InterfacePart;
import appeng.parts.reporting.InterfaceTerminalPart;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.misc.InterfaceTileEntity;
import appeng.util.InventoryAdaptor;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.WrapperCursorItemHandler;
import appeng.util.inv.WrapperFilteredItemHandler;
import appeng.util.inv.WrapperRangeItemHandler;
import appeng.util.inv.filter.IAEItemFilter;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandler;

public final class InterfaceTerminalContainer
extends AEBaseContainer {
    public static final ContainerType<InterfaceTerminalContainer> TYPE = ContainerTypeBuilder.create(InterfaceTerminalContainer::new, InterfaceTerminalPart.class).requirePermission(SecurityPermissions.BUILD).build("interfaceterminal");
    private static long inventorySerial = Long.MIN_VALUE;
    private final Map<IInterfaceHost, InvTracker> diList = new IdentityHashMap<IInterfaceHost, InvTracker>();
    private final Long2ObjectOpenHashMap<InvTracker> byId = new Long2ObjectOpenHashMap();

    public InterfaceTerminalContainer(int id, PlayerInventory ip, InterfaceTerminalPart anchor) {
        super(TYPE, id, ip, anchor);
        this.createPlayerInventorySlots(ip);
    }

    @Override
    public void func_75142_b() {
        InterfaceTerminalPacket packet;
        if (this.isClient()) {
            return;
        }
        super.func_75142_b();
        IGrid grid = this.getGrid();
        VisitorState state = new VisitorState();
        if (grid != null) {
            this.visitInterfaceHosts(grid, InterfaceTileEntity.class, state);
            this.visitInterfaceHosts(grid, InterfacePart.class, state);
        }
        if ((packet = state.total != this.diList.size() || state.forceFullUpdate ? this.createFullUpdate(grid) : this.createIncrementalUpdate()) != null) {
            NetworkHandler.instance().sendTo(packet, (ServerPlayerEntity)this.getPlayerInventory().field_70458_d);
        }
    }

    @Nullable
    private IGrid getGrid() {
        IGridNode agn;
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            return agn.getGrid();
        }
        return null;
    }

    private <T extends IInterfaceHost & IGridHost> void visitInterfaceHosts(IGrid grid, Class<T> machineClass, VisitorState state) {
        for (IGridNode gn : grid.getMachines(machineClass)) {
            IInterfaceHost ih;
            DualityInterface dual;
            if (!gn.isActive() || (dual = (ih = (IInterfaceHost)((Object)gn.getMachine())).getInterfaceDuality()).getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) continue;
            InvTracker t = this.diList.get(ih);
            if (t == null || !t.name.equals(dual.getTermName())) {
                state.forceFullUpdate = true;
            }
            ++state.total;
        }
    }

    @Override
    public void doAction(ServerPlayerEntity player, InventoryAction action, int slot, long id) {
        InvTracker inv = (InvTracker)this.byId.get(id);
        if (inv == null) {
            return;
        }
        if (slot < 0 || slot >= inv.server.getSlots()) {
            AELog.warn("Client refers to invalid slot %d of inventory %s", slot, inv.name.getString());
            return;
        }
        ItemStack is = inv.server.getStackInSlot(slot);
        boolean hasItemInHand = !player.field_71071_by.func_70445_o().func_190926_b();
        AdaptorItemHandler playerHand = new AdaptorItemHandler((IItemHandler)new WrapperCursorItemHandler(player.field_71071_by));
        WrapperFilteredItemHandler theSlot = new WrapperFilteredItemHandler((IItemHandler)new WrapperRangeItemHandler(inv.server, slot, slot + 1), new PatternSlotFilter());
        AdaptorItemHandler interfaceSlot = new AdaptorItemHandler((IItemHandler)theSlot);
        switch (action) {
            case PICKUP_OR_SET_DOWN: {
                if (hasItemInHand) {
                    ItemStack inSlot = theSlot.getStackInSlot(0);
                    if (inSlot.func_190926_b()) {
                        player.field_71071_by.func_70437_b(((InventoryAdaptor)interfaceSlot).addItems(player.field_71071_by.func_70445_o()));
                        break;
                    }
                    inSlot = inSlot.func_77946_l();
                    ItemStack inHand = player.field_71071_by.func_70445_o().func_77946_l();
                    ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, 0, ItemStack.field_190927_a);
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                    player.field_71071_by.func_70437_b(((InventoryAdaptor)interfaceSlot).addItems(inHand.func_77946_l()));
                    if (player.field_71071_by.func_70445_o().func_190926_b()) {
                        player.field_71071_by.func_70437_b(inSlot);
                        break;
                    }
                    player.field_71071_by.func_70437_b(inHand);
                    ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, 0, inSlot);
                    break;
                }
                ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, 0, ((InventoryAdaptor)playerHand).addItems(theSlot.getStackInSlot(0)));
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (hasItemInHand) {
                    ItemStack extra = ((InventoryAdaptor)playerHand).removeItems(1, ItemStack.field_190927_a, null);
                    if (!extra.func_190926_b()) {
                        extra = ((InventoryAdaptor)interfaceSlot).addItems(extra);
                    }
                    if (extra.func_190926_b()) break;
                    ((InventoryAdaptor)playerHand).addItems(extra);
                    break;
                }
                if (is.func_190926_b()) break;
                ItemStack extra = ((InventoryAdaptor)interfaceSlot).removeItems((is.func_190916_E() + 1) / 2, ItemStack.field_190927_a, null);
                if (!extra.func_190926_b()) {
                    extra = ((InventoryAdaptor)playerHand).addItems(extra);
                }
                if (extra.func_190926_b()) break;
                ((InventoryAdaptor)interfaceSlot).addItems(extra);
                break;
            }
            case SHIFT_CLICK: {
                InventoryAdaptor playerInv = InventoryAdaptor.getAdaptor((PlayerEntity)player);
                ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, 0, playerInv.addItems(theSlot.getStackInSlot(0)));
                break;
            }
            case MOVE_REGION: {
                InventoryAdaptor playerInvAd = InventoryAdaptor.getAdaptor((PlayerEntity)player);
                for (int x = 0; x < inv.server.getSlots(); ++x) {
                    ItemHandlerUtil.setStackInSlot(inv.server, x, playerInvAd.addItems(inv.server.getStackInSlot(x)));
                }
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.field_71075_bZ.field_75098_d || hasItemInHand) break;
                player.field_71071_by.func_70437_b(is.func_190926_b() ? ItemStack.field_190927_a : is.func_77946_l());
                break;
            }
            default: {
                return;
            }
        }
        this.updateHeld(player);
    }

    private InterfaceTerminalPacket createFullUpdate(@Nullable IGrid grid) {
        DualityInterface dual;
        IInterfaceHost ih;
        this.byId.clear();
        this.diList.clear();
        if (grid == null) {
            return new InterfaceTerminalPacket(true, new CompoundNBT());
        }
        for (IGridNode gn : grid.getMachines(InterfaceTileEntity.class)) {
            ih = (IInterfaceHost)((Object)gn.getMachine());
            dual = ih.getInterfaceDuality();
            if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
            this.diList.put(ih, new InvTracker(dual, dual.getPatterns(), dual.getTermName()));
        }
        for (IGridNode gn : grid.getMachines(InterfacePart.class)) {
            ih = (IInterfaceHost)((Object)gn.getMachine());
            dual = ih.getInterfaceDuality();
            if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
            this.diList.put(ih, new InvTracker(dual, dual.getPatterns(), dual.getTermName()));
        }
        CompoundNBT data = new CompoundNBT();
        for (Map.Entry<IInterfaceHost, InvTracker> en : this.diList.entrySet()) {
            InvTracker inv = en.getValue();
            this.byId.put(inv.serverId, (Object)inv);
            this.addItems(data, inv, 0, inv.server.getSlots());
        }
        return new InterfaceTerminalPacket(true, data);
    }

    private InterfaceTerminalPacket createIncrementalUpdate() {
        CompoundNBT data = null;
        for (Map.Entry<IInterfaceHost, InvTracker> en : this.diList.entrySet()) {
            InvTracker inv = en.getValue();
            for (int x = 0; x < inv.server.getSlots(); ++x) {
                if (!this.isDifferent(inv.server.getStackInSlot(x), inv.client.getStackInSlot(x))) continue;
                if (data == null) {
                    data = new CompoundNBT();
                }
                this.addItems(data, inv, x, 1);
            }
        }
        if (data != null) {
            return new InterfaceTerminalPacket(false, data);
        }
        return null;
    }

    private boolean isDifferent(ItemStack a, ItemStack b) {
        if (a.func_190926_b() && b.func_190926_b()) {
            return false;
        }
        if (a.func_190926_b() || b.func_190926_b()) {
            return true;
        }
        return !ItemStack.func_77989_b((ItemStack)a, (ItemStack)b);
    }

    private void addItems(CompoundNBT data, InvTracker inv, int offset, int length) {
        String name = '=' + Long.toString(inv.serverId, 36);
        CompoundNBT tag = data.func_74775_l(name);
        if (tag.isEmpty()) {
            tag.func_74772_a("sortBy", inv.sortBy);
            tag.func_74778_a("un", ITextComponent.Serializer.func_150696_a((ITextComponent)inv.name));
        }
        for (int x = 0; x < length; ++x) {
            CompoundNBT itemNBT = new CompoundNBT();
            ItemStack is = inv.server.getStackInSlot(x + offset);
            ItemHandlerUtil.setStackInSlot(inv.client, x + offset, is.func_190926_b() ? ItemStack.field_190927_a : is.func_77946_l());
            if (!is.func_190926_b()) {
                is.func_77955_b(itemNBT);
            }
            tag.func_218657_a(Integer.toString(x + offset), (INBT)itemNBT);
        }
        data.func_218657_a(name, (INBT)tag);
    }

    static /* synthetic */ long access$708() {
        return inventorySerial++;
    }

    private static class PatternSlotFilter
    implements IAEItemFilter {
        private PatternSlotFilter() {
        }

        @Override
        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            return true;
        }

        @Override
        public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
            return !stack.func_190926_b() && stack.func_77973_b() instanceof EncodedPatternItem;
        }
    }

    private static class InvTracker {
        private final long sortBy;
        private final long serverId = InterfaceTerminalContainer.access$708();
        private final ITextComponent name;
        private final IItemHandler client;
        private final IItemHandler server;

        public InvTracker(DualityInterface dual, IItemHandler patterns, ITextComponent name) {
            this.server = patterns;
            this.client = new AppEngInternalInventory(null, this.server.getSlots());
            this.name = name;
            this.sortBy = dual.getSortValue();
        }
    }

    private static class VisitorState {
        int total;
        boolean forceFullUpdate;

        private VisitorState() {
        }
    }
}

