/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.FuzzyMode;
import appeng.api.config.LevelType;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.container.SlotSemantic;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.container.implementations.UpgradeableContainer;
import appeng.container.slot.FakeTypeOnlySlot;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.parts.automation.LevelEmitterPart;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraftforge.items.IItemHandler;

public class LevelEmitterContainer
extends UpgradeableContainer {
    public static final ContainerType<LevelEmitterContainer> TYPE = ContainerTypeBuilder.create(LevelEmitterContainer::new, LevelEmitterPart.class).requirePermission(SecurityPermissions.BUILD).withInitialData((host, buffer) -> buffer.func_179254_b(host.getReportingValue()), (host, container, buffer) -> {
        container.reportingValue = buffer.func_179260_f();
    }).build("levelemitter");
    private final LevelEmitterPart lvlEmitter;
    @GuiSync(value=2)
    public LevelType lvType;
    @GuiSync(value=3)
    public YesNo cmType;
    private long reportingValue;

    public LevelEmitterContainer(int id, PlayerInventory ip, LevelEmitterPart te) {
        super(TYPE, id, ip, te);
        this.lvlEmitter = te;
    }

    public long getReportingValue() {
        return this.reportingValue;
    }

    public void setReportingValue(long reportingValue) {
        if (this.isClient()) {
            if (reportingValue != this.reportingValue) {
                this.reportingValue = reportingValue;
                NetworkHandler.instance().sendToServer(new ConfigValuePacket("LevelEmitter.Value", String.valueOf(reportingValue)));
            }
        } else {
            this.lvlEmitter.setReportingValue(reportingValue);
        }
    }

    @Override
    protected void setupConfig() {
        this.setupUpgrades();
        IItemHandler inv = this.getUpgradeable().getInventoryByName("config");
        this.addSlot(new FakeTypeOnlySlot(inv, 0), SlotSemantic.CONFIG);
    }

    @Override
    protected boolean supportCapacity() {
        return false;
    }

    @Override
    public int availableUpgrades() {
        return 1;
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (this.isServer()) {
            this.setCraftingMode((YesNo)this.getUpgradeable().getConfigManager().getSetting(Settings.CRAFT_VIA_REDSTONE));
            this.setLevelMode((LevelType)this.getUpgradeable().getConfigManager().getSetting(Settings.LEVEL_TYPE));
            this.setFuzzyMode((FuzzyMode)this.getUpgradeable().getConfigManager().getSetting(Settings.FUZZY_MODE));
            this.setRedStoneMode((RedstoneMode)this.getUpgradeable().getConfigManager().getSetting(Settings.REDSTONE_EMITTER));
        }
        this.standardDetectAndSendChanges();
    }

    @Override
    public YesNo getCraftingMode() {
        return this.cmType;
    }

    @Override
    public void setCraftingMode(YesNo cmType) {
        this.cmType = cmType;
    }

    public LevelType getLevelMode() {
        return this.lvType;
    }

    private void setLevelMode(LevelType lvType) {
        this.lvType = lvType;
    }
}

