/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.helpers.IPriorityHost;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;

public class PriorityContainer
extends AEBaseContainer {
    public static final ContainerType<PriorityContainer> TYPE = ContainerTypeBuilder.create(PriorityContainer::new, IPriorityHost.class).requirePermission(SecurityPermissions.BUILD).withInitialData((host, buffer) -> buffer.func_150787_b(host.getPriority()), (host, container, buffer) -> {
        container.priorityValue = buffer.func_150792_a();
    }).build("priority");
    private final IPriorityHost priHost;
    private int priorityValue;

    public PriorityContainer(int id, PlayerInventory ip, IPriorityHost te) {
        super(TYPE, id, ip, te);
        this.priHost = te;
        this.priorityValue = te.getPriority();
    }

    public void setPriority(int newValue) {
        if (newValue != this.priorityValue) {
            if (this.isClient()) {
                this.priorityValue = newValue;
                NetworkHandler.instance().sendToServer(new ConfigValuePacket("PriorityHost.Priority", String.valueOf(newValue)));
            } else {
                this.priHost.setPriority(newValue);
                this.priorityValue = newValue;
            }
        }
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        this.verifyPermissions(SecurityPermissions.BUILD, false);
    }

    public int getPriorityValue() {
        return this.priorityValue;
    }

    public IPriorityHost getPriorityHost() {
        return this.priHost;
    }
}

