/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.me.crafting;

import appeng.api.networking.crafting.ICraftingCPU;
import javax.annotation.Nonnull;
import net.minecraft.util.text.ITextComponent;

public class CraftingCPURecord
implements Comparable<CraftingCPURecord> {
    private final ICraftingCPU cpu;
    private final long size;
    private final int processors;
    private ITextComponent name;

    public CraftingCPURecord(long size, int coProcessors, ICraftingCPU server) {
        this.size = size;
        this.processors = coProcessors;
        this.cpu = server;
        this.name = server.getName();
    }

    @Override
    public int compareTo(@Nonnull CraftingCPURecord o) {
        int a = Long.compare(o.getProcessors(), this.getProcessors());
        if (a != 0) {
            return a;
        }
        return Long.compare(o.getSize(), this.getSize());
    }

    ICraftingCPU getCpu() {
        return this.cpu;
    }

    int getProcessors() {
        return this.processors;
    }

    long getSize() {
        return this.size;
    }

    public ITextComponent getName() {
        return this.name;
    }

    public void setName(ITextComponent name) {
        this.name = name;
    }
}

