/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.container.AEBaseContainer;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;

public class GuiDataSyncPacket
extends BasePacket {
    private final int windowId;
    private final PacketBuffer data;

    public GuiDataSyncPacket(int windowId, Consumer<PacketBuffer> writer) {
        this.windowId = 0;
        this.data = null;
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.func_150787_b(windowId);
        writer.accept(data);
        this.configureWrite(data);
    }

    public GuiDataSyncPacket(PacketBuffer data) {
        this.windowId = data.func_150792_a();
        this.data = new PacketBuffer(data.copy());
    }

    public PacketBuffer getData() {
        return this.data;
    }

    @Override
    public void clientPacketData(INetworkInfo manager, PlayerEntity player) {
        Container c = player.field_71070_bA;
        if (c instanceof AEBaseContainer && c.field_75152_c == this.windowId) {
            ((AEBaseContainer)c).receiveServerSyncData(this);
        }
    }

    @Override
    public void serverPacketData(INetworkInfo manager, PlayerEntity player) {
        Container c = player.field_71070_bA;
        if (c instanceof AEBaseContainer && c.field_75152_c == this.windowId) {
            ((AEBaseContainer)c).receiveClientAction(this);
        }
    }
}

