/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.client.gui;

import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.implementations.NumberEntryWidget;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.container.SlotSemantic;
import appeng.fluids.client.gui.widgets.FluidSlotWidget;
import appeng.fluids.container.FluidLevelEmitterContainer;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class FluidLevelEmitterScreen
extends UpgradeableScreen<FluidLevelEmitterContainer> {
    private final SettingToggleButton<RedstoneMode> redstoneMode;
    private final NumberEntryWidget level;

    public FluidLevelEmitterScreen(FluidLevelEmitterContainer container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title, style);
        this.addSlot(new FluidSlotWidget(((FluidLevelEmitterContainer)this.field_147002_h).getFluidConfigInventory(), 0), SlotSemantic.CONFIG);
        this.level = new NumberEntryWidget(NumberEntryType.LEVEL_FLUID_VOLUME);
        this.level.setTextFieldBounds(25, 44, 75);
        this.level.setValue(container.getReportingValue());
        this.level.setOnChange(this::saveReportingValue);
        this.level.setOnConfirm(() -> ((FluidLevelEmitterScreen)this).func_231175_as__());
        this.widgets.add("level", this.level);
        this.redstoneMode = new ServerSettingToggleButton<RedstoneMode>(Settings.REDSTONE_EMITTER, RedstoneMode.LOW_SIGNAL);
        this.addToLeftToolbar(this.redstoneMode);
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.redstoneMode.set(((FluidLevelEmitterContainer)this.field_147002_h).getRedStoneMode());
    }

    private void saveReportingValue() {
        this.level.getLongValue().ifPresent(((FluidLevelEmitterContainer)this.field_147002_h)::setReportingValue);
    }

    @Override
    public void drawBG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(matrixStack, offsetX, offsetY, mouseX, mouseY, partialTicks);
        this.level.render(matrixStack, mouseX, mouseY, partialTicks);
    }
}

