/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.widgets.CustomSlotWidget;
import appeng.container.AEBaseContainer;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.FakeSlot;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.fluids.client.gui.widgets.FluidSlotWidget;
import appeng.fluids.util.AEFluidStack;
import appeng.helpers.InventoryAction;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

class GhostIngredientHandler
implements IGhostIngredientHandler<AEBaseScreen> {
    GhostIngredientHandler() {
    }

    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(AEBaseScreen gui, I ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        if (ingredient instanceof ItemStack) {
            GhostIngredientHandler.addItemStackTargets(gui, targets);
        } else if (ingredient instanceof FluidStack) {
            GhostIngredientHandler.addFluidStackTargets(gui, targets);
        }
        return targets;
    }

    private static <I> void addItemStackTargets(AEBaseScreen<?> gui, List<IGhostIngredientHandler.Target<I>> targets) {
        for (Slot slot : ((AEBaseContainer)gui.func_212873_a_()).field_75151_b) {
            AppEngSlot appEngSlot;
            if (!(slot instanceof AppEngSlot) || !(appEngSlot = (AppEngSlot)slot).isSlotEnabled() || !(appEngSlot instanceof FakeSlot)) continue;
            targets.add(new ItemSlotTarget(gui, appEngSlot));
        }
    }

    private static <I> void addFluidStackTargets(AEBaseScreen<?> gui, List<IGhostIngredientHandler.Target<I>> targets) {
        for (CustomSlotWidget slot : gui.getGuiSlots()) {
            if (!slot.isSlotEnabled() || !(slot instanceof FluidSlotWidget)) continue;
            targets.add(new FluidSlotTarget(gui, (FluidSlotWidget)slot));
        }
    }

    public void onComplete() {
    }

    private static class FluidSlotTarget
    implements IGhostIngredientHandler.Target<FluidStack> {
        private final FluidSlotWidget slot;
        private final Rectangle2d area;

        public FluidSlotTarget(AEBaseScreen<?> screen, FluidSlotWidget slot) {
            this.slot = slot;
            this.area = new Rectangle2d(screen.getGuiLeft() + slot.getTooltipAreaX(), screen.getGuiTop() + slot.getTooltipAreaY(), slot.getTooltipAreaWidth(), slot.getTooltipAreaWidth());
        }

        public Rectangle2d getArea() {
            return this.area;
        }

        public void accept(FluidStack ingredient) {
            this.slot.setFluidStack(AEFluidStack.fromFluidStack(ingredient));
        }
    }

    private static class ItemSlotTarget
    implements IGhostIngredientHandler.Target<ItemStack> {
        private final AppEngSlot slot;
        private final Rectangle2d area;

        public ItemSlotTarget(AEBaseScreen<?> screen, AppEngSlot slot) {
            this.slot = slot;
            this.area = new Rectangle2d(screen.getGuiLeft() + slot.field_75223_e, screen.getGuiTop() + slot.field_75221_f, 16, 16);
        }

        public Rectangle2d getArea() {
            return this.area;
        }

        public void accept(ItemStack ingredient) {
            NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.SET_FILTER, this.slot.field_75222_d, ingredient));
        }
    }
}

