/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.storage;

import appeng.api.config.FuzzyMode;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.Api;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.util.item.AEItemStack;
import appeng.util.prioritylist.FuzzyPriorityList;
import appeng.util.prioritylist.IPartitionList;
import appeng.util.prioritylist.MergedPriorityList;
import appeng.util.prioritylist.PrecisePriorityList;
import java.util.Collection;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ViewCellItem
extends AEBaseItem
implements ICellWorkbenchItem {
    public ViewCellItem(Item.Properties properties) {
        super(properties);
    }

    public static IPartitionList<IAEItemStack> createFilter(Collection<ItemStack> list) {
        MergedPriorityList myPartitionList = null;
        MergedPriorityList myMergedList = new MergedPriorityList();
        for (ItemStack currentViewCell : list) {
            ItemStack is;
            int x;
            if (currentViewCell == null || !(currentViewCell.func_77973_b() instanceof ViewCellItem)) continue;
            IItemList<AEItemStack> priorityList = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
            ICellWorkbenchItem vc = (ICellWorkbenchItem)currentViewCell.func_77973_b();
            IItemHandler upgrades = vc.getUpgradesInventory(currentViewCell);
            IItemHandler config = vc.getConfigInventory(currentViewCell);
            FuzzyMode fzMode = vc.getFuzzyMode(currentViewCell);
            boolean hasInverter = false;
            boolean hasFuzzy = false;
            block5: for (x = 0; x < upgrades.getSlots(); ++x) {
                Upgrades u;
                is = upgrades.getStackInSlot(x);
                if (is.func_190926_b() || !(is.func_77973_b() instanceof IUpgradeModule) || (u = ((IUpgradeModule)is.func_77973_b()).getType(is)) == null) continue;
                switch (u) {
                    case FUZZY: {
                        hasFuzzy = true;
                        continue block5;
                    }
                    case INVERTER: {
                        hasInverter = true;
                        continue block5;
                    }
                }
            }
            for (x = 0; x < config.getSlots(); ++x) {
                is = config.getStackInSlot(x);
                if (is.func_190926_b()) continue;
                priorityList.add(AEItemStack.fromItemStack(is));
            }
            if (priorityList.isEmpty()) continue;
            if (hasFuzzy) {
                myMergedList.addNewList(new FuzzyPriorityList(priorityList, fzMode), !hasInverter);
            } else {
                myMergedList.addNewList(new PrecisePriorityList(priorityList), !hasInverter);
            }
            myPartitionList = myMergedList;
        }
        return myPartitionList;
    }

    @Override
    public boolean isEditable(ItemStack is) {
        return true;
    }

    @Override
    public IItemHandler getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    @Override
    public IItemHandler getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = is.func_196082_o().func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        is.func_196082_o().func_74778_a("FuzzyMode", fzMode.name());
    }
}

