/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.recipes.entropy.PropertyUtils;
import appeng.recipes.entropy.StateMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.StateHolder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

class MultipleValuesMatcher<T extends Comparable<T>>
implements StateMatcher {
    private final Property<T> property;
    private final Set<T> propertyValues;

    public MultipleValuesMatcher(Property<T> property, List<String> propertyValues) {
        this.property = Objects.requireNonNull(property, "property must be not null");
        this.propertyValues = propertyValues.stream().map(name -> PropertyUtils.getRequiredPropertyValue(property, name)).collect(Collectors.toSet());
    }

    @Override
    public boolean matches(StateHolder<?, ?> state) {
        return this.propertyValues.contains(state.func_177229_b(this.property));
    }

    @Override
    public void writeToPacket(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)StateMatcher.MatcherType.MULTIPLE);
        buffer.func_180714_a(this.property.func_177701_a());
        buffer.writeInt(this.propertyValues.size());
        for (Comparable value : this.propertyValues) {
            buffer.func_180714_a(this.property.func_177702_a(value));
        }
    }

    public static MultipleValuesMatcher<?> create(StateContainer<?, ?> stateContainer, String propertyName, List<String> values) {
        Property<?> property = PropertyUtils.getRequiredProperty(stateContainer, propertyName);
        return new MultipleValuesMatcher(property, values);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static MultipleValuesMatcher<?> readFromPacket(StateContainer<?, ?> stateContainer, PacketBuffer buffer) {
        String propertyName = buffer.func_218666_n();
        int size = buffer.readInt();
        ArrayList<String> values = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            values.add(buffer.func_218666_n());
        }
        return MultipleValuesMatcher.create(stateContainer, propertyName, values);
    }
}

