/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.recipes.entropy.PropertyUtils;
import appeng.recipes.entropy.StateMatcher;
import java.util.Objects;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.StateHolder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

class SingleValueMatcher<T extends Comparable<T>>
implements StateMatcher {
    private final Property<T> property;
    private final T value;

    private SingleValueMatcher(Property<T> property, String value) {
        this.property = Objects.requireNonNull(property, "property must not be null");
        this.value = PropertyUtils.getRequiredPropertyValue(property, value);
    }

    @Override
    public boolean matches(StateHolder<?, ?> state) {
        return this.value.equals(state.func_177229_b(this.property));
    }

    @Override
    public void writeToPacket(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)StateMatcher.MatcherType.SINGLE);
        buffer.func_180714_a(this.property.func_177701_a());
        buffer.func_180714_a(this.property.func_177702_a(this.value));
    }

    public static SingleValueMatcher<?> create(StateContainer<?, ?> stateContainer, String propertyName, String value) {
        Property<?> property = PropertyUtils.getRequiredProperty(stateContainer, propertyName);
        return new SingleValueMatcher(property, value);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static SingleValueMatcher<?> readFromPacket(StateContainer<?, ?> stateContainer, PacketBuffer buffer) {
        String propertyName = buffer.func_218666_n();
        String value = buffer.func_218666_n();
        return SingleValueMatcher.create(stateContainer, propertyName, value);
    }
}

