/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.server.ISubCommand;
import appeng.worldgen.meteorite.MeteoriteStructure;
import appeng.worldgen.meteorite.MeteoriteStructurePiece;
import appeng.worldgen.meteorite.PlacedMeteoriteSettings;
import com.google.common.math.StatsAccumulator;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class TestMeteoritesCommand
implements ISubCommand {
    @Override
    public void addArguments(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(Commands.func_197057_a((String)"force").executes(ctx -> {
            TestMeteoritesCommand.test(ServerLifecycleHooks.getCurrentServer(), (CommandSource)ctx.getSource(), true);
            return 1;
        }));
    }

    @Override
    public void call(MinecraftServer srv, CommandContext<CommandSource> ctx, CommandSource sender) {
        TestMeteoritesCommand.test(srv, sender, false);
    }

    private static void test(MinecraftServer srv, CommandSource sender, boolean force) {
        BlockPos centerBlock;
        ServerWorld world;
        int radius = 100;
        ServerPlayerEntity player = null;
        try {
            player = sender.func_197035_h();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (player != null) {
            world = player.func_71121_q();
            centerBlock = new BlockPos(player.func_226277_ct_(), 0.0, player.func_226281_cx_());
        } else {
            world = srv.func_71218_a(World.field_234918_g_);
            centerBlock = world.func_241135_u_();
        }
        ChunkPos center = new ChunkPos(centerBlock);
        ChunkGenerator generator = world.func_72863_F().func_201711_g();
        ArrayList<PlacedMeteoriteSettings> found = new ArrayList<PlacedMeteoriteSettings>();
        int chunksChecked = 0;
        for (int cx = center.field_77276_a - radius; cx <= center.field_77276_a + radius; ++cx) {
            for (int cz = center.field_77275_b - radius; cz <= center.field_77275_b + radius; ++cz) {
                IChunk chunk;
                MeteoriteStructurePiece piece;
                ++chunksChecked;
                ChunkPos cp = new ChunkPos(cx, cz);
                BlockPos p = new BlockPos(cp.func_180334_c(), 0, cp.func_180333_d());
                BlockPos nearest = generator.func_235956_a_(world, MeteoriteStructure.INSTANCE, p, 0, false);
                if (nearest == null || (piece = TestMeteoritesCommand.getMeteoritePieceFromChunk(chunk = world.func_217348_a(cx, cz, ChunkStatus.field_222606_b))) == null) continue;
                found.add(piece.getSettings());
            }
        }
        StatsAccumulator stats = new StatsAccumulator();
        for (PlacedMeteoriteSettings settings2 : found) {
            double closestOther = Double.NaN;
            for (PlacedMeteoriteSettings otherSettings : found) {
                if (otherSettings == settings2) continue;
                double d = settings2.getPos().func_177951_i((Vector3i)otherSettings.getPos());
                if (!Double.isNaN(closestOther) && !(d < closestOther)) continue;
                closestOther = d;
            }
            if (Double.isNaN(closestOther)) continue;
            stats.add(Math.sqrt(closestOther));
        }
        found.sort(Comparator.comparingDouble(settings -> settings.getPos().func_177951_i((Vector3i)centerBlock)));
        TestMeteoritesCommand.sendLine(sender, "Chunks checked: %d", chunksChecked);
        TestMeteoritesCommand.sendLine(sender, "Meteorites found: %d", found.size());
        TestMeteoritesCommand.sendLine(sender, "Closest: min=%.2f max=%.2f mean=%.2f stddev=%.2f", stats.min(), stats.max(), stats.mean(), stats.populationStandardDeviation());
        int closestCount = Math.min(10, found.size());
        for (int i = 0; i < closestCount; ++i) {
            PlacedMeteoriteSettings settings3 = (PlacedMeteoriteSettings)found.get(i);
            BlockPos pos = settings3.getPos();
            String state = "not final";
            if (force && settings3.getFallout() == null) {
                IChunk chunk = world.func_217349_x(pos);
                MeteoriteStructurePiece piece = TestMeteoritesCommand.getMeteoritePieceFromChunk(chunk);
                if (piece == null) {
                    state = "removed";
                } else {
                    settings3 = piece.getSettings();
                    pos = settings3.getPos();
                }
            }
            StringTextComponent restOfLine = settings3.getFallout() == null ? new StringTextComponent(String.format(Locale.ROOT, ", radius=%.2f [%s]", Float.valueOf(settings3.getMeteoriteRadius()), state)) : new StringTextComponent(String.format(Locale.ROOT, ", radius=%.2f, crater=%s, fallout=%s", Float.valueOf(settings3.getMeteoriteRadius()), settings3.getCraterType().name().toLowerCase(), settings3.getFallout().name().toLowerCase()));
            StringTextComponent msg = new StringTextComponent(" #" + (i + 1) + " ");
            msg.func_230529_a_(TestMeteoritesCommand.getClickablePosition(world, settings3, pos)).func_230529_a_((ITextComponent)restOfLine);
            String biomeId = world.func_242406_i(pos).map(bk -> bk.func_240901_a_().toString()).orElse("unknown");
            IFormattableTextComponent tooltip = new StringTextComponent(settings3.toString() + "\nBiome: ").func_230532_e_().func_240702_b_(biomeId);
            msg.func_240700_a_(arg_0 -> TestMeteoritesCommand.lambda$test$3((ITextComponent)tooltip, arg_0));
            sender.func_197030_a((ITextComponent)msg, true);
        }
    }

    private static ITextComponent getClickablePosition(ServerWorld world, PlacedMeteoriteSettings settings, BlockPos pos) {
        BlockPos tpPos = pos.func_177981_b((int)Math.ceil(settings.getMeteoriteRadius()));
        int surfaceY = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, tpPos).func_177956_o();
        if (surfaceY > tpPos.func_177956_o()) {
            tpPos = new BlockPos(tpPos.func_177958_n(), surfaceY, tpPos.func_177952_p());
        }
        String displayText = String.format(Locale.ROOT, "pos=%d,%d,%d", tpPos.func_177958_n(), tpPos.func_177956_o(), tpPos.func_177952_p());
        String tpCommand = String.format(Locale.ROOT, "/tp @s %d %d %d", tpPos.func_177958_n(), tpPos.func_177956_o(), tpPos.func_177952_p());
        return new StringTextComponent(displayText).func_240699_a_(TextFormatting.UNDERLINE).func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, tpCommand)));
    }

    private static MeteoriteStructurePiece getMeteoritePieceFromChunk(IChunk chunk) {
        StructureStart start = chunk.func_230342_a_(MeteoriteStructure.INSTANCE);
        if (start != null && start.func_186161_c().size() > 0 && start.func_186161_c().get(0) instanceof MeteoriteStructurePiece) {
            return (MeteoriteStructurePiece)((Object)start.func_186161_c().get(0));
        }
        return null;
    }

    private static void sendLine(CommandSource sender, String text, Object ... args) {
        sender.func_197030_a((ITextComponent)new StringTextComponent(String.format(Locale.ROOT, text, args)), true);
    }

    private static /* synthetic */ Style lambda$test$3(ITextComponent tooltip, Style style) {
        return style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)tooltip));
    }
}

