/*
 * Decompiled with CFR 0.152.
 */
package appeng.services;

import appeng.tile.spatial.SpatialAnchorTileEntity;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;

public class ChunkLoadingService
implements ForgeChunkManager.LoadingValidationCallback {
    private static final ChunkLoadingService INSTANCE = new ChunkLoadingService();
    private boolean running = true;

    public static void register() {
        ForgeChunkManager.setForcedChunkLoadingCallback((String)"appliedenergistics2", (ForgeChunkManager.LoadingValidationCallback)INSTANCE);
    }

    public void onServerAboutToStart(FMLServerAboutToStartEvent evt) {
        this.running = true;
    }

    public void onServerStopping(FMLServerStoppingEvent event) {
        this.running = false;
    }

    public static ChunkLoadingService getInstance() {
        return INSTANCE;
    }

    public void validateTickets(ServerWorld world, ForgeChunkManager.TicketHelper ticketHelper) {
        ticketHelper.getBlockTickets().forEach((blockPos, chunks) -> {
            TileEntity tileEntity = world.func_175625_s(blockPos);
            if (tileEntity instanceof SpatialAnchorTileEntity) {
                SpatialAnchorTileEntity anchor = (SpatialAnchorTileEntity)tileEntity;
                for (Long chunk : (LongSet)chunks.getSecond()) {
                    anchor.registerChunk(new ChunkPos(chunk.longValue()));
                }
            } else {
                ticketHelper.removeAllTickets(blockPos);
            }
        });
    }

    public boolean forceChunk(ServerWorld world, BlockPos owner, ChunkPos position, boolean ticking) {
        if (this.running) {
            return ForgeChunkManager.forceChunk((ServerWorld)world, (String)"appliedenergistics2", (BlockPos)owner, (int)position.field_77276_a, (int)position.field_77275_b, (boolean)true, (boolean)true);
        }
        return false;
    }

    public boolean releaseChunk(ServerWorld world, BlockPos owner, ChunkPos position, boolean ticking) {
        if (this.running) {
            return ForgeChunkManager.forceChunk((ServerWorld)world, (String)"appliedenergistics2", (BlockPos)owner, (int)position.field_77276_a, (int)position.field_77275_b, (boolean)false, (boolean)true);
        }
        return false;
    }
}

