/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.api.movable.IMovableHandler;
import appeng.api.movable.IMovableRegistry;
import appeng.api.util.AEPartLocation;
import appeng.api.util.WorldCoord;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.worlddata.WorldData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EmptyBlockReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ServerTickList;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.ServerWorldLightManager;

public class CachedPlane {
    private final int x_size;
    private final int z_size;
    private final int cx_size;
    private final int cz_size;
    private final int x_offset;
    private final int y_offset;
    private final int z_offset;
    private final int y_size;
    private final Chunk[][] myChunks;
    private final Column[][] myColumns;
    private final List<TileEntity> tiles = new ArrayList<TileEntity>();
    private final List<NextTickListEntry<Block>> ticks = new ArrayList<NextTickListEntry<Block>>();
    private final ServerWorld world;
    private final IMovableRegistry reg = Api.instance().registries().movable();
    private final List<WorldCoord> updates = new ArrayList<WorldCoord>();
    private int verticalBits;
    private final BlockState matrixBlockState;

    public CachedPlane(ServerWorld w, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        Block matrixFrameBlock = Api.instance().definitions().blocks().matrixFrame().maybeBlock().orElse(null);
        this.matrixBlockState = matrixFrameBlock != null ? matrixFrameBlock.func_176223_P() : null;
        this.world = w;
        this.x_size = maxX - minX + 1;
        this.y_size = maxY - minY + 1;
        this.z_size = maxZ - minZ + 1;
        this.x_offset = minX;
        this.y_offset = minY;
        this.z_offset = minZ;
        int minCX = minX >> 4;
        int minCY = minY >> 4;
        int minCZ = minZ >> 4;
        int maxCX = maxX >> 4;
        int maxCY = maxY >> 4;
        int maxCZ = maxZ >> 4;
        this.cx_size = maxCX - minCX + 1;
        int cy_size = maxCY - minCY + 1;
        this.cz_size = maxCZ - minCZ + 1;
        this.myChunks = new Chunk[this.cx_size][this.cz_size];
        this.myColumns = new Column[this.x_size][this.z_size];
        this.verticalBits = 0;
        for (int cy = 0; cy < cy_size; ++cy) {
            this.verticalBits |= 1 << minCY + cy;
        }
        for (int x = 0; x < this.x_size; ++x) {
            for (int z = 0; z < this.z_size; ++z) {
                this.myColumns[x][z] = new Column(w.func_212866_a_(minX + x >> 4, minZ + z >> 4), minX + x & 0xF, minZ + z & 0xF, minCY, cy_size);
            }
        }
        IMovableRegistry mr = Api.instance().registries().movable();
        for (int cx = 0; cx < this.cx_size; ++cx) {
            for (int cz = 0; cz < this.cz_size; ++cz) {
                Chunk c;
                ArrayList<BlockPos> deadTiles = new ArrayList<BlockPos>();
                this.myChunks[cx][cz] = c = w.func_212866_a_(minCX + cx, minCZ + cz);
                ArrayList rawTiles = new ArrayList(c.func_177434_r().entrySet());
                for (Map.Entry entry : rawTiles) {
                    BlockPos cp = (BlockPos)entry.getKey();
                    TileEntity te = (TileEntity)entry.getValue();
                    BlockPos tePOS = te.func_174877_v();
                    if (tePOS.func_177958_n() < minX || tePOS.func_177958_n() > maxX || tePOS.func_177956_o() < minY || tePOS.func_177956_o() > maxY || tePOS.func_177952_p() < minZ || tePOS.func_177952_p() > maxZ) continue;
                    if (mr.askToMove(te)) {
                        this.tiles.add(te);
                        deadTiles.add(cp);
                        continue;
                    }
                    BlockStorageData details = new BlockStorageData();
                    this.myColumns[tePOS.func_177958_n() - minX][tePOS.func_177952_p() - minZ].fillData(tePOS.func_177956_o(), details);
                    if (details.state.isAir((IBlockReader)EmptyBlockReader.INSTANCE, tePOS)) {
                        w.func_217377_a(tePOS, false);
                        continue;
                    }
                    this.myColumns[tePOS.func_177958_n() - minX][tePOS.func_177952_p() - minZ].setSkip(tePOS.func_177956_o());
                }
                for (BlockPos blockPos : deadTiles) {
                    c.func_177434_r().remove(blockPos);
                }
                long gameTime = this.getWorld().func_82737_E();
                ServerTickList pendingBlockTicks = this.getWorld().func_205220_G_();
                if (!(pendingBlockTicks instanceof ServerTickList)) continue;
                List pending = pendingBlockTicks.func_223188_a(c.func_76632_l(), false, true);
                for (NextTickListEntry entry : pending) {
                    BlockPos tePOS = entry.field_180282_a;
                    if (tePOS.func_177958_n() < minX || tePOS.func_177958_n() > maxX || tePOS.func_177956_o() < minY || tePOS.func_177956_o() > maxY || tePOS.func_177952_p() < minZ || tePOS.func_177952_p() > maxZ) continue;
                    this.ticks.add((NextTickListEntry<Block>)new NextTickListEntry(tePOS, entry.func_151351_a(), entry.field_235017_b_ - gameTime, entry.field_82754_f));
                }
            }
        }
        for (TileEntity te : this.tiles) {
            try {
                this.getWorld().field_147482_g.remove(te);
                if (!(te instanceof ITickableTileEntity)) continue;
                this.getWorld().field_175730_i.remove(te);
            }
            catch (Exception e) {
                AELog.debug(e);
            }
        }
    }

    private IMovableHandler getHandler(TileEntity te) {
        IMovableRegistry mr = Api.instance().registries().movable();
        return mr.getHandler(te);
    }

    void swap(CachedPlane dst) {
        IMovableRegistry mr = Api.instance().registries().movable();
        if (dst.x_size == this.x_size && dst.y_size == this.y_size && dst.z_size == this.z_size) {
            AELog.info("Block Copy Scale: " + this.x_size + ", " + this.y_size + ", " + this.z_size, new Object[0]);
            long startTime = System.nanoTime();
            BlockStorageData aD = new BlockStorageData();
            BlockStorageData bD = new BlockStorageData();
            for (int x = 0; x < this.x_size; ++x) {
                for (int z = 0; z < this.z_size; ++z) {
                    Column a = this.myColumns[x][z];
                    Column b = dst.myColumns[x][z];
                    for (int y = 0; y < this.y_size; ++y) {
                        int n = y + this.y_offset;
                        int dst_y = y + dst.y_offset;
                        if (a.doNotSkip(n) && b.doNotSkip(dst_y)) {
                            a.fillData(n, aD);
                            b.fillData(dst_y, bD);
                            a.setBlockState(n, bD);
                            b.setBlockState(dst_y, aD);
                            continue;
                        }
                        this.markForUpdate(x + this.x_offset, n, z + this.z_offset);
                        dst.markForUpdate(x + dst.x_offset, dst_y, z + dst.z_offset);
                    }
                }
            }
            long endTime = System.nanoTime();
            long duration = endTime - startTime;
            AELog.info("Block Copy Time: " + duration, new Object[0]);
            for (TileEntity tileEntity : this.tiles) {
                BlockPos tePOS = tileEntity.func_174877_v();
                dst.addTile(tePOS.func_177958_n() - this.x_offset, tePOS.func_177956_o() - this.y_offset, tePOS.func_177952_p() - this.z_offset, tileEntity, this, mr);
            }
            for (TileEntity tileEntity : dst.tiles) {
                BlockPos tePOS = tileEntity.func_174877_v();
                this.addTile(tePOS.func_177958_n() - dst.x_offset, tePOS.func_177956_o() - dst.y_offset, tePOS.func_177952_p() - dst.z_offset, tileEntity, dst, mr);
            }
            for (NextTickListEntry nextTickListEntry : this.ticks) {
                BlockPos tePOS = nextTickListEntry.field_180282_a;
                dst.addTick(tePOS.func_177958_n() - this.x_offset, tePOS.func_177956_o() - this.y_offset, tePOS.func_177952_p() - this.z_offset, (NextTickListEntry<Block>)nextTickListEntry);
            }
            for (NextTickListEntry nextTickListEntry : dst.ticks) {
                BlockPos tePOS = nextTickListEntry.field_180282_a;
                this.addTick(tePOS.func_177958_n() - dst.x_offset, tePOS.func_177956_o() - dst.y_offset, tePOS.func_177952_p() - dst.z_offset, (NextTickListEntry<Block>)nextTickListEntry);
            }
            startTime = System.nanoTime();
            this.updateChunks();
            dst.updateChunks();
            endTime = System.nanoTime();
            duration = endTime - startTime;
            AELog.info("Update Time: " + duration, new Object[0]);
        }
    }

    private void markForUpdate(int x, int y, int z) {
        this.updates.add(new WorldCoord(x, y, z));
        for (AEPartLocation d : AEPartLocation.SIDE_LOCATIONS) {
            this.updates.add(new WorldCoord(x + d.xOffset, y + d.yOffset, z + d.zOffset));
        }
    }

    private void addTick(int x, int y, int z, NextTickListEntry<Block> entry) {
        BlockPos where = new BlockPos(x + this.x_offset, y + this.y_offset, z + this.z_offset);
        this.world.func_205220_G_().func_205362_a(where, entry.func_151351_a(), (int)entry.field_235017_b_, entry.field_82754_f);
    }

    private void addTile(int x, int y, int z, TileEntity te, CachedPlane alternateDestination, IMovableRegistry mr) {
        block5: {
            try {
                Column c = this.myColumns[x][z];
                if (c.doNotSkip(y + this.y_offset) || alternateDestination == null) {
                    IMovableHandler handler = this.getHandler(te);
                    try {
                        handler.moveTile(te, (World)this.world, new BlockPos(x + this.x_offset, y + this.y_offset, z + this.z_offset));
                    }
                    catch (Throwable e) {
                        AELog.debug(e);
                        BlockPos pos = new BlockPos(x, y, z);
                        c.c.func_150813_a(te);
                        this.world.func_184138_a(pos, this.world.func_180495_p(pos), this.world.func_180495_p(pos), z);
                    }
                    mr.doneMoving(te);
                    break block5;
                }
                alternateDestination.addTile(x, y, z, te, null, mr);
            }
            catch (Throwable e) {
                AELog.debug(e);
            }
        }
    }

    private void updateChunks() {
        WorldLightManager lightManager = this.world.func_225524_e_();
        if (lightManager instanceof ServerWorldLightManager) {
            ServerWorldLightManager serverLightManager = (ServerWorldLightManager)lightManager;
            for (int x = 0; x < this.cx_size; ++x) {
                for (int z = 0; z < this.cz_size; ++z) {
                    Chunk c = this.myChunks[x][z];
                    serverLightManager.func_215593_a((IChunk)c, false);
                    c.func_76630_e();
                }
            }
        }
        for (int x = 0; x < this.cx_size; ++x) {
            for (int z = 0; z < this.cz_size; ++z) {
                Chunk c = this.myChunks[x][z];
                WorldData.instance().compassData().service().updateArea(this.getWorld(), (IChunk)c);
                SChunkDataPacket cdp = new SChunkDataPacket(c, this.verticalBits);
                this.world.func_72863_F().field_217237_a.func_219097_a(c.func_76632_l(), false).forEach(spe -> spe.field_71135_a.func_147359_a((IPacket)cdp));
            }
        }
        this.world.func_72863_F().func_217207_a(() -> false);
    }

    List<WorldCoord> getUpdates() {
        return this.updates;
    }

    ServerWorld getWorld() {
        return this.world;
    }

    private class Column {
        private final int x;
        private final int z;
        private final Chunk c;
        private List<Integer> skipThese = null;

        public Column(Chunk chunk, int x, int z, int chunkY, int chunkHeight) {
            this.x = x;
            this.z = z;
            this.c = chunk;
            ChunkSection[] storage = this.c.func_76587_i();
            for (int ay = 0; ay < chunkHeight; ++ay) {
                int by = ay + chunkY;
                ChunkSection extendedblockstorage = storage[by];
                if (extendedblockstorage != null) continue;
                extendedblockstorage = storage[by] = new ChunkSection(by << 4);
            }
        }

        private void setBlockState(int y, BlockStorageData data) {
            if (data.state == CachedPlane.this.matrixBlockState) {
                data.state = Blocks.field_150350_a.func_176223_P();
            }
            ChunkSection[] storage = this.c.func_76587_i();
            ChunkSection extendedBlockStorage = storage[y >> 4];
            extendedBlockStorage.func_222629_a(this.x, y & 0xF, this.z, data.state);
        }

        private void fillData(int y, BlockStorageData data) {
            ChunkSection[] storage = this.c.func_76587_i();
            ChunkSection extendedblockstorage = storage[y >> 4];
            data.state = extendedblockstorage.func_177485_a(this.x, y & 0xF, this.z);
        }

        private boolean doNotSkip(int y) {
            ChunkSection[] storage = this.c.func_76587_i();
            ChunkSection extendedblockstorage = storage[y >> 4];
            if (CachedPlane.this.reg.isBlacklisted(extendedblockstorage.func_177485_a(this.x, y & 0xF, this.z).func_177230_c())) {
                return false;
            }
            return this.skipThese == null || !this.skipThese.contains(y);
        }

        private void setSkip(int yCoord) {
            if (this.skipThese == null) {
                this.skipThese = new ArrayList<Integer>();
            }
            this.skipThese.add(yCoord);
        }
    }

    private static class BlockStorageData {
        public BlockState state;

        private BlockStorageData() {
        }
    }
}

