/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import java.time.Instant;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public final class TransitionInfo {
    public static final String TAG_WORLD_ID = "world_id";
    public static final String TAG_MIN = "min";
    public static final String TAG_MAX = "max";
    public static final String TAG_TIMESTAMP = "timestamp";
    private final ResourceLocation worldId;
    private final BlockPos min;
    private final BlockPos max;
    private final Instant timestamp;

    public TransitionInfo(ResourceLocation worldId, BlockPos min, BlockPos max, Instant timestamp) {
        this.worldId = worldId;
        this.min = min.func_185334_h();
        this.max = max.func_185334_h();
        this.timestamp = timestamp;
    }

    public ResourceLocation getWorldId() {
        return this.worldId;
    }

    public BlockPos getMin() {
        return this.min;
    }

    public BlockPos getMax() {
        return this.max;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public CompoundNBT toTag() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a(TAG_WORLD_ID, this.worldId.toString());
        tag.func_218657_a(TAG_MIN, (INBT)NBTUtil.func_186859_a((BlockPos)this.min));
        tag.func_218657_a(TAG_MAX, (INBT)NBTUtil.func_186859_a((BlockPos)this.max));
        tag.func_74772_a(TAG_TIMESTAMP, this.timestamp.toEpochMilli());
        return tag;
    }

    public static TransitionInfo fromTag(CompoundNBT tag) {
        ResourceLocation worldId = new ResourceLocation(tag.func_74779_i(TAG_WORLD_ID));
        BlockPos min = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l(TAG_MIN));
        BlockPos max = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l(TAG_MAX));
        Instant timestamp = Instant.ofEpochMilli(tag.func_74763_f(TAG_TIMESTAMP));
        return new TransitionInfo(worldId, min, max, timestamp);
    }
}

