/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile;

import appeng.tile.AEBaseTileEntity;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public abstract class AEBaseInvTileEntity
extends AEBaseTileEntity
implements IAEAppEngInventory {
    public AEBaseInvTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT data) {
        super.func_230337_a_(blockState, data);
        IItemHandler inv = this.getInternalInventory();
        if (inv != EmptyHandler.INSTANCE) {
            CompoundNBT opt = data.func_74775_l("inv");
            for (int x = 0; x < inv.getSlots(); ++x) {
                CompoundNBT item = opt.func_74775_l("item" + x);
                ItemHandlerUtil.setStackInSlot(inv, x, ItemStack.func_199557_a((CompoundNBT)item));
            }
        }
    }

    @Nonnull
    public abstract IItemHandler getInternalInventory();

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        super.func_189515_b(data);
        IItemHandler inv = this.getInternalInventory();
        if (inv != EmptyHandler.INSTANCE) {
            CompoundNBT opt = new CompoundNBT();
            for (int x = 0; x < inv.getSlots(); ++x) {
                CompoundNBT item = new CompoundNBT();
                ItemStack is = inv.getStackInSlot(x);
                if (!is.func_190926_b()) {
                    is.func_77955_b(item);
                }
                opt.func_218657_a("item" + x, (INBT)item);
            }
            data.func_218657_a("inv", (INBT)opt);
        }
        return data;
    }

    @Override
    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        IItemHandler inv = this.getInternalInventory();
        for (int l = 0; l < inv.getSlots(); ++l) {
            ItemStack is = inv.getStackInSlot(l);
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
    }

    @Override
    public abstract void onChangeInventory(IItemHandler var1, int var2, InvOperation var3, ItemStack var4, ItemStack var5);

    @Nonnull
    protected IItemHandler getItemHandlerForSide(@Nonnull Direction side) {
        return this.getInternalInventory();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return LazyOptional.of(this::getInternalInventory);
            }
            return LazyOptional.of(() -> this.getItemHandlerForSide(facing));
        }
        return super.getCapability(capability, facing);
    }
}

