/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.definitions.ITileDefinition;
import appeng.api.features.InscriberProcessType;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.core.Api;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.parts.automation.DefinitionUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.tile.grid.AENetworkPowerTileEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.misc.InscriberRecipes;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperChainedItemHandler;
import appeng.util.inv.WrapperFilteredItemHandler;
import appeng.util.inv.filter.IAEItemFilter;
import appeng.util.item.AEItemStack;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class InscriberTileEntity
extends AENetworkPowerTileEntity
implements IGridTickable,
IUpgradeableHost,
IConfigManagerHost {
    private final int maxProcessingTime = 100;
    private final IConfigManager settings;
    private final UpgradeInventory upgrades;
    private int processingTime = 0;
    private boolean smash;
    private int finalStep;
    private long clientStart;
    private final AppEngInternalInventory topItemHandler = new AppEngInternalInventory(this, 1, 1);
    private final AppEngInternalInventory bottomItemHandler = new AppEngInternalInventory(this, 1, 1);
    private final AppEngInternalInventory sideItemHandler = new AppEngInternalInventory(this, 2, 1);
    private final IItemHandler topItemHandlerExtern;
    private final IItemHandler bottomItemHandlerExtern;
    private final IItemHandler sideItemHandlerExtern;
    private InscriberRecipe cachedTask = null;
    private final IItemHandlerModifiable inv = new WrapperChainedItemHandler(new IItemHandler[]{this.topItemHandler, this.bottomItemHandler, this.sideItemHandler});

    public InscriberTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.getProxy().setValidSides(EnumSet.noneOf(Direction.class));
        this.setInternalMaxPower(1600.0);
        this.getProxy().setIdlePowerUsage(0.0);
        this.settings = new ConfigManager(this);
        ITileDefinition inscriberDefinition = Api.instance().definitions().blocks().inscriber();
        this.upgrades = new DefinitionUpgradeInventory(inscriberDefinition, this, this.getUpgradeSlots());
        this.sideItemHandler.setMaxStackSize(1, 64);
        ItemHandlerFilter filter = new ItemHandlerFilter();
        this.topItemHandlerExtern = new WrapperFilteredItemHandler((IItemHandler)this.topItemHandler, filter);
        this.bottomItemHandlerExtern = new WrapperFilteredItemHandler((IItemHandler)this.bottomItemHandler, filter);
        this.sideItemHandlerExtern = new WrapperFilteredItemHandler((IItemHandler)this.sideItemHandler, filter);
    }

    private int getUpgradeSlots() {
        return 3;
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.COVERED;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        super.func_189515_b(data);
        this.upgrades.writeToNBT(data, "upgrades");
        this.settings.writeToNBT(data);
        return data;
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT data) {
        super.func_230337_a_(blockState, data);
        this.upgrades.readFromNBT(data, "upgrades");
        this.settings.readFromNBT(data);
    }

    @Override
    protected boolean readFromStream(PacketBuffer data) throws IOException {
        boolean newSmash;
        boolean c = super.readFromStream(data);
        byte slot = data.readByte();
        boolean oldSmash = this.isSmash();
        boolean bl = newSmash = (slot & 0x40) == 64;
        if (oldSmash != newSmash && newSmash) {
            this.setSmash(true);
            this.setClientStart(System.currentTimeMillis());
        }
        for (int num = 0; num < this.inv.getSlots(); ++num) {
            if ((slot & 1 << num) > 0) {
                this.inv.setStackInSlot(num, AEItemStack.fromPacket(data).createItemStack());
                continue;
            }
            this.inv.setStackInSlot(num, ItemStack.field_190927_a);
        }
        this.cachedTask = null;
        return c;
    }

    @Override
    protected void writeToStream(PacketBuffer data) throws IOException {
        int num;
        super.writeToStream(data);
        int slot = this.isSmash() ? 64 : 0;
        for (num = 0; num < this.inv.getSlots(); ++num) {
            if (this.inv.getStackInSlot(num).func_190926_b()) continue;
            slot |= 1 << num;
        }
        data.writeByte(slot);
        for (num = 0; num < this.inv.getSlots(); ++num) {
            if ((slot & 1 << num) <= 0) continue;
            AEItemStack st = AEItemStack.fromItemStack(this.inv.getStackInSlot(num));
            st.writeToPacket(data);
        }
    }

    @Override
    public void setOrientation(Direction inForward, Direction inUp) {
        super.setOrientation(inForward, inUp);
        this.getProxy().setValidSides(EnumSet.complementOf(EnumSet.of(this.getForward())));
        this.setPowerSides(EnumSet.complementOf(EnumSet.of(this.getForward())));
    }

    @Override
    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        super.getDrops(w, pos, drops);
        for (int h = 0; h < this.upgrades.getSlots(); ++h) {
            ItemStack is = this.upgrades.getStackInSlot(h);
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        try {
            if (slot == 0) {
                this.setProcessingTime(0);
            }
            if (!this.isSmash()) {
                this.markForUpdate();
            }
            this.cachedTask = null;
            this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Inscriber.getMin(), TickRates.Inscriber.getMax(), !this.hasWork(), false);
    }

    private boolean hasWork() {
        if (this.getTask() != null) {
            return true;
        }
        this.setProcessingTime(0);
        return this.isSmash();
    }

    @Nullable
    public InscriberRecipe getTask() {
        if (this.cachedTask == null && this.field_145850_b != null) {
            ItemStack input = this.sideItemHandler.getStackInSlot(0);
            ItemStack plateA = this.topItemHandler.getStackInSlot(0);
            ItemStack plateB = this.bottomItemHandler.getStackInSlot(0);
            if (input.func_190926_b()) {
                return null;
            }
            if (input.func_190916_E() > 1 || plateA.func_190916_E() > 1 || plateB.func_190916_E() > 1) {
                return null;
            }
            this.cachedTask = InscriberRecipes.findRecipe(this.field_145850_b, input, plateA, plateB, true);
        }
        return this.cachedTask;
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.isSmash()) {
            ++this.finalStep;
            if (this.finalStep == 8) {
                ItemStack outputCopy;
                InscriberRecipe out = this.getTask();
                if (out != null && this.sideItemHandler.insertItem(1, outputCopy = out.getOutput().func_77946_l(), false).func_190926_b()) {
                    this.setProcessingTime(0);
                    if (out.getProcessType() == InscriberProcessType.PRESS) {
                        this.topItemHandler.setStackInSlot(0, ItemStack.field_190927_a);
                        this.bottomItemHandler.setStackInSlot(0, ItemStack.field_190927_a);
                    }
                    this.sideItemHandler.setStackInSlot(0, ItemStack.field_190927_a);
                }
                this.saveChanges();
            } else if (this.finalStep == 16) {
                this.finalStep = 0;
                this.setSmash(false);
                this.markForUpdate();
            }
        } else {
            try {
                IEnergyGrid eg = this.getProxy().getEnergy();
                IEnergySource src = this;
                int speedFactor = 1 + this.upgrades.getInstalledUpgrades(Upgrades.SPEED);
                int powerConsumption = 10 * speedFactor;
                double powerThreshold = (double)powerConsumption - 0.01;
                double powerReq = this.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                if (powerReq <= powerThreshold) {
                    src = eg;
                    powerReq = eg.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                }
                if (powerReq > powerThreshold) {
                    src.extractAEPower(powerConsumption, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    if (this.getProcessingTime() == 0) {
                        this.setProcessingTime(this.getProcessingTime() + speedFactor);
                    } else {
                        this.setProcessingTime(this.getProcessingTime() + ticksSinceLastCall * speedFactor);
                    }
                }
            }
            catch (GridAccessException eg) {
                // empty catch block
            }
            if (this.getProcessingTime() > this.getMaxProcessingTime()) {
                ItemStack outputCopy;
                this.setProcessingTime(this.getMaxProcessingTime());
                InscriberRecipe out = this.getTask();
                if (out != null && this.sideItemHandler.insertItem(1, outputCopy = out.getOutput().func_77946_l(), true).func_190926_b()) {
                    this.setSmash(true);
                    this.finalStep = 0;
                    this.markForUpdate();
                }
            }
        }
        return this.hasWork() ? TickRateModulation.URGENT : TickRateModulation.SLEEP;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.settings;
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("inv")) {
            return this.getInternalInventory();
        }
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        return null;
    }

    @Override
    protected IItemHandler getItemHandlerForSide(@Nonnull Direction facing) {
        if (facing == this.getUp()) {
            return this.topItemHandlerExtern;
        }
        if (facing == this.getUp().func_176734_d()) {
            return this.bottomItemHandlerExtern;
        }
        return this.sideItemHandlerExtern;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
    }

    public long getClientStart() {
        return this.clientStart;
    }

    private void setClientStart(long clientStart) {
        this.clientStart = clientStart;
    }

    public boolean isSmash() {
        return this.smash;
    }

    public void setSmash(boolean smash) {
        this.smash = smash;
    }

    public int getMaxProcessingTime() {
        return this.maxProcessingTime;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    private void setProcessingTime(int processingTime) {
        this.processingTime = processingTime;
    }

    private class ItemHandlerFilter
    implements IAEItemFilter {
        private ItemHandlerFilter() {
        }

        @Override
        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            if (InscriberTileEntity.this.isSmash()) {
                return false;
            }
            return inv == InscriberTileEntity.this.topItemHandler || inv == InscriberTileEntity.this.bottomItemHandler || slot == 1;
        }

        @Override
        public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
            if (slot == 1) {
                return false;
            }
            if (InscriberTileEntity.this.isSmash()) {
                return false;
            }
            if (inv == InscriberTileEntity.this.topItemHandler || inv == InscriberTileEntity.this.bottomItemHandler) {
                if (Api.instance().definitions().materials().namePress().isSameAs(stack)) {
                    return true;
                }
                return InscriberRecipes.isValidOptionalIngredient(InscriberTileEntity.this.func_145831_w(), stack);
            }
            return true;
        }
    }
}

