/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.storage;

import appeng.block.storage.SkyChestBlock;
import appeng.tile.AEBaseInvTileEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.inv.InvOperation;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;

@OnlyIn(value=Dist.CLIENT, _interface=IChestLid.class)
public class SkyChestTileEntity
extends AEBaseInvTileEntity
implements ITickableTileEntity,
IChestLid {
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 36);
    private int numPlayersUsing;
    private float lidAngle;
    private float prevLidAngle;

    public SkyChestTileEntity(TileEntityType<? extends SkyChestTileEntity> type) {
        super(type);
    }

    @Override
    protected void writeToStream(PacketBuffer data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.numPlayersUsing > 0);
    }

    @Override
    protected boolean readFromStream(PacketBuffer data) throws IOException {
        boolean c = super.readFromStream(data);
        int wasOpen = this.numPlayersUsing;
        this.numPlayersUsing = data.readBoolean() ? 1 : 0;
        return wasOpen != this.numPlayersUsing || c;
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.inv;
    }

    public void openInventory(PlayerEntity player) {
        if (!player.func_175149_v() && !this.isRemote()) {
            ++this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    public void closeInventory(PlayerEntity player) {
        if (!player.func_175149_v() && !this.isRemote()) {
            this.numPlayersUsing = Math.max(this.numPlayersUsing - 1, 0);
            this.onOpenOrClose();
        }
    }

    private void onOpenOrClose() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof SkyChestBlock) {
            this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, this.numPlayersUsing);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
    }

    public void func_73660_a() {
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.playSound(SoundEvents.field_187657_V);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f) {
            this.lidAngle = Math.max(this.lidAngle - 0.1f, 0.0f);
            if (this.lidAngle < 0.5f && this.prevLidAngle >= 0.5f) {
                this.playSound(SoundEvents.field_187651_T);
            }
        } else if (this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            this.lidAngle = Math.min(this.lidAngle + 0.1f, 1.0f);
        }
    }

    private void playSound(SoundEvent soundIn) {
        double d0 = (double)this.field_174879_c.func_177958_n() + 0.5;
        double d1 = (double)this.field_174879_c.func_177956_o() + 0.5;
        double d2 = (double)this.field_174879_c.func_177952_p() + 0.5;
        this.field_145850_b.func_184148_a((PlayerEntity)null, d0, d1, d2, soundIn, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    public float func_195480_a(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevLidAngle, (float)this.lidAngle);
    }
}

