/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite.debug;

import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.PlacedMeteoriteSettings;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;

public class MeteoriteSpawner {
    public PlacedMeteoriteSettings trySpawnMeteoriteAtSuitableHeight(IWorldReader world, BlockPos startPos, float coreRadius, CraterType craterType, boolean pureCrater, boolean worldGen) {
        int stepSize = Math.min(5, (int)Math.ceil(coreRadius) + 1);
        int minY = 10 + stepSize;
        BlockPos.Mutable mutablePos = startPos.func_239590_i_();
        mutablePos.func_189534_c(Direction.DOWN, stepSize);
        while (mutablePos.func_177956_o() > minY) {
            PlacedMeteoriteSettings spawned = this.trySpawnMeteorite(world, (BlockPos)mutablePos, coreRadius, craterType, pureCrater);
            if (spawned != null) {
                return spawned;
            }
            mutablePos.func_185336_p(mutablePos.func_177956_o() - stepSize);
        }
        return null;
    }

    @Nullable
    public PlacedMeteoriteSettings trySpawnMeteorite(IWorldReader world, BlockPos pos, float coreRadius, CraterType craterType, boolean pureCrater) {
        boolean solid;
        if (!this.areSurroundingsSuitable(world, pos)) {
            return null;
        }
        int skyMode = this.countBlockWithSkyLight(world, pos);
        boolean placeCrater = skyMode > 10;
        boolean bl = solid = !MeteoriteSpawner.isAirBelowSpawnPoint(world, pos);
        if (!solid || placeCrater) {
            // empty if block
        }
        boolean craterLake = false;
        return new PlacedMeteoriteSettings(pos, coreRadius, craterType, null, pureCrater, craterLake);
    }

    private static boolean isAirBelowSpawnPoint(IWorldReader w, BlockPos pos) {
        BlockPos.Mutable testPos = pos.func_239590_i_();
        for (int j = pos.func_177956_o() - 15; j < pos.func_177956_o() - 1; ++j) {
            testPos.func_185336_p(j);
            if (!w.func_175623_d((BlockPos)testPos)) continue;
            return true;
        }
        return false;
    }

    private int countBlockWithSkyLight(IWorldReader w, BlockPos pos) {
        int skyMode = 0;
        BlockPos.Mutable testPos = new BlockPos.Mutable();
        for (int i = pos.func_177958_n() - 15; i < pos.func_177958_n() + 15; ++i) {
            testPos.func_223471_o(i);
            for (int j = pos.func_177956_o() - 15; j < pos.func_177956_o() + 11; ++j) {
                testPos.func_185336_p(j);
                for (int k = pos.func_177952_p() - 15; k < pos.func_177952_p() + 15; ++k) {
                    testPos.func_223472_q(k);
                    if (!w.func_175710_j((BlockPos)testPos)) continue;
                    ++skyMode;
                }
            }
        }
        return skyMode;
    }

    private boolean areSurroundingsSuitable(IWorldReader w, BlockPos pos) {
        int realValidBlocks = 0;
        BlockPos.Mutable testPos = new BlockPos.Mutable();
        for (int i = pos.func_177958_n() - 6; i < pos.func_177958_n() + 6; ++i) {
            testPos.func_223471_o(i);
            for (int j = pos.func_177956_o() - 6; j < pos.func_177956_o() + 6; ++j) {
                testPos.func_185336_p(j);
                for (int k = pos.func_177952_p() - 6; k < pos.func_177952_p() + 6; ++k) {
                    testPos.func_223472_q(k);
                    Block block = w.func_180495_p((BlockPos)testPos).func_177230_c();
                    ++realValidBlocks;
                }
            }
        }
        int validBlocks = 0;
        for (int i = pos.func_177958_n() - 15; i < pos.func_177958_n() + 15; ++i) {
            testPos.func_223471_o(i);
            for (int j = pos.func_177956_o() - 15; j < pos.func_177956_o() + 15; ++j) {
                testPos.func_185336_p(j);
                for (int k = pos.func_177952_p() - 15; k < pos.func_177952_p() + 15; ++k) {
                    testPos.func_223472_q(k);
                    Block testBlk = w.func_180495_p((BlockPos)testPos).func_177230_c();
                    ++validBlocks;
                }
            }
        }
        int minBlocks = 200;
        return validBlocks > 200 && realValidBlocks > 80;
    }
}

